/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mailintegration.utils;

import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.exoplatform.web.security.security.TokenServiceInitializationException;

public class MailIntegrationUtils {
    private static final Log LOG = ExoLogger.getLogger(MailIntegrationUtils.class);

    private MailIntegrationUtils() {
    }

    public static String encode(String password) {
        try {
            CodecInitializer codecInitializer = (CodecInitializer)CommonsUtils.getService(CodecInitializer.class);
            return codecInitializer.getCodec().encode(password);
        }
        catch (TokenServiceInitializationException e) {
            LOG.warn((Object)"Error when encoding password", (Throwable)e);
            return null;
        }
    }

    public static String decode(String password) {
        try {
            CodecInitializer codecInitializer = (CodecInitializer)CommonsUtils.getService(CodecInitializer.class);
            return codecInitializer.getCodec().decode(password);
        }
        catch (TokenServiceInitializationException e) {
            LOG.warn((Object)"Error when decoding password", (Throwable)e);
            return null;
        }
    }

    public static final long getCurrentUserIdentityId(IdentityManager identityManager) {
        String currentUser = MailIntegrationUtils.getCurrentUser();
        Identity identity = identityManager.getOrCreateIdentity("organization", currentUser);
        return identity == null ? 0L : Long.parseLong(identity.getId());
    }

    public static final String getCurrentUser() {
        return ConversationState.getCurrent().getIdentity().getUserId();
    }
}

