/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mailintegration.service;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.mailintegration.service.MailIntegrationService;
import org.exoplatform.services.user.UserStateService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.hibernate.ObjectNotFoundException;
import org.junit.After;
import org.junit.Before;

public abstract class BaseMailIntegrationTest {
    protected Identity user1Identity;
    protected PortalContainer container;
    protected MailIntegrationService mailIntegrationService;
    protected IdentityManager identityManager;
    protected UserStateService userStateService;
    protected CodecInitializer codecInitializer;

    @Before
    public void setUp() throws ObjectNotFoundException {
        this.container = PortalContainer.getInstance();
        this.initServices();
        this.begin();
        this.injectData();
    }

    private void initServices() {
        this.mailIntegrationService = (MailIntegrationService)this.container.getComponentInstanceOfType(MailIntegrationService.class);
        this.identityManager = (IdentityManager)this.container.getComponentInstanceOfType(IdentityManager.class);
    }

    @After
    public void tearDown() throws ObjectNotFoundException {
        this.end();
    }

    protected void injectData() throws ObjectNotFoundException {
        this.user1Identity = this.identityManager.getOrCreateIdentity("organization", "testuser1");
    }

    protected void begin() {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
    }

    protected void end() {
        RequestLifeCycle.end();
    }
}

