/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mailintegration.storage;

import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.mailintegration.dao.MailIntegrationDAO;
import org.exoplatform.mailintegration.entity.MailIntegrationSettingEntity;
import org.exoplatform.mailintegration.model.MailIntegrationSetting;
import org.exoplatform.mailintegration.utils.EntityMapper;

public class MailIntegrationStorage {
    private MailIntegrationDAO mailIntegrationDAO;

    public MailIntegrationStorage(MailIntegrationDAO mailIntegrationDAO) {
        this.mailIntegrationDAO = mailIntegrationDAO;
    }

    public MailIntegrationSetting createMailIntegrationSetting(MailIntegrationSetting mailIntegrationSetting) {
        MailIntegrationSettingEntity mailIntegrationSettingEntity = EntityMapper.toMailIntegrationSettingEntity(mailIntegrationSetting);
        mailIntegrationSettingEntity = (MailIntegrationSettingEntity)this.mailIntegrationDAO.create(mailIntegrationSettingEntity);
        return EntityMapper.fromMailIntegrationSettingEntity(mailIntegrationSettingEntity);
    }

    public List<MailIntegrationSetting> getMailIntegrationSettingsByUserId(long userIdentityId) {
        List<MailIntegrationSettingEntity> mailIntegrationSettingEntities = this.mailIntegrationDAO.findMailIntegrationSettingsByUserId(userIdentityId);
        return mailIntegrationSettingEntities.stream().map(EntityMapper::fromMailIntegrationSettingEntity).collect(Collectors.toList());
    }

    public void deleteMailIntegrationSetting(long mailIntegrationSettingId) {
        MailIntegrationSettingEntity mailIntegrationSettingEntity = (MailIntegrationSettingEntity)this.mailIntegrationDAO.find(Long.valueOf(mailIntegrationSettingId));
        this.mailIntegrationDAO.delete(mailIntegrationSettingEntity);
    }

    public List<MailIntegrationSetting> getMailIntegrationSettings() {
        List mailIntegrationSettingEntities = this.mailIntegrationDAO.findAll();
        return mailIntegrationSettingEntities.stream().map(EntityMapper::fromMailIntegrationSettingEntity).collect(Collectors.toList());
    }

    public MailIntegrationSetting getMailIntegrationSettingById(long mailIntegrationSettingId) {
        return EntityMapper.fromMailIntegrationSettingEntity((MailIntegrationSettingEntity)this.mailIntegrationDAO.find(Long.valueOf(mailIntegrationSettingId)));
    }

    public List<MailIntegrationSetting> getMailIntegrationSettingByMailIntegrationSettingIdAndUserId(long mailIntegrationSettingId, long userId) {
        List<MailIntegrationSettingEntity> mailIntegrationSettingEntities = this.mailIntegrationDAO.findMailIntegrationSettingsByIdAndUserId(mailIntegrationSettingId, userId);
        return mailIntegrationSettingEntities.stream().map(EntityMapper::fromMailIntegrationSettingEntity).collect(Collectors.toList());
    }

    public MailIntegrationSetting updateMailIntegrationSetting(MailIntegrationSetting mailIntegrationSetting) {
        MailIntegrationSettingEntity mailIntegrationSettingEntity = EntityMapper.toMailIntegrationSettingEntity(mailIntegrationSetting);
        mailIntegrationSettingEntity = (MailIntegrationSettingEntity)this.mailIntegrationDAO.update(mailIntegrationSettingEntity);
        return EntityMapper.fromMailIntegrationSettingEntity(mailIntegrationSettingEntity);
    }
}

