/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.marketplace.dao.hibernate;

import java.util.logging.Logger;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.exoplatform.addon.marketplace.bo.Category;
import org.exoplatform.addon.marketplace.dao.CategoryDAO;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.commons.utils.ListAccess;

public class CategoryDAOImpl
extends GenericDAOJPAImpl<Category, Long>
implements CategoryDAO {
    private static final Logger LOG = Logger.getLogger("ProjectDAOImpl");

    public Category update(Category entity) {
        return (Category)super.update((Object)entity);
    }

    public void delete(Category entity) {
        Category p = (Category)this.getEntityManager().find(Category.class, (Object)entity.getId());
        if (p != null) {
            super.delete((Object)p);
        }
    }

    @Override
    public Category removeCategory(long categoryId, boolean deleteChild) {
        Category c = (Category)this.getEntityManager().find(Category.class, (Object)categoryId);
        if (c == null) {
            return null;
        }
        if (!deleteChild && c.getChildren() != null) {
            for (Category pj : c.getChildren()) {
                pj.setParent(c.getParent());
                this.getEntityManager().persist((Object)pj);
            }
            c.getChildren().clear();
        }
        super.delete((Object)c);
        return c;
    }

    @Override
    public Category findCategoryByName(String name) {
        TypedQuery query = this.getEntityManager().createNamedQuery("category.findCategoryByName", Category.class);
        query.setParameter("name", (Object)name);
        try {
            return (Category)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    @Override
    public ListAccess<Category> findSubCategory(Category category) {
        return null;
    }

    @Override
    public ListAccess<Category> findCategories(String query) {
        return null;
    }
}

