/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.community.portlet.addon.search;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.addon.marketplace.Constants;
import org.exoplatform.addon.marketplace.bo.Category;
import org.exoplatform.addon.marketplace.service.MarketPlaceService;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.community.portlet.addon.search.UIAddOnSearchForm;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIDropDownControl;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * Exception performing whole class analysis ignored.
 */
@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/AddOnSearchPortlet/UIAddOnSearchForm.gtmpl", events={@EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={SortActionListener.class})}), @ComponentConfig(type=UIDropDownControl.class, id="DisplayModesDropDown", template="system:/groovy/webui/core/UIDropDownControl.gtmpl", events={@EventConfig(listeners={ChangeOptionActionListener.class})}), @ComponentConfig(type=UIDropDownControl.class, id="CategoryNameDropDown", template="system:/groovy/webui/core/UIDropDownControl.gtmpl", events={@EventConfig(listeners={ChangeCategoryActionListener.class})})})
public class UIAddOnSearchForm
extends UIForm
implements Constants {
    private static final Log LOG = ExoLogger.getLogger((String)UIAddOnSearchForm.class.getName());
    private String featuredCategory = "";
    private static final String EXO_MARKETPLACE_FEATUED_CATEGORY_NAME = "exo.addon.marketplace.featured.category.name";
    public static String filterSelected = "";
    public static String categorySelected = "";
    public static Boolean REFRESH = true;
    private Boolean btnBackToAddonsVisible = false;
    UIDropDownControl categoryNameDropDown = null;
    List<SelectItemOption<String>> categoriesList = null;
    MarketPlaceService marketPlaceService = (MarketPlaceService)this.getApplicationComponent(MarketPlaceService.class);

    public UIAddOnSearchForm() throws Exception {
        UIFormStringInput uiKeywordInput = new UIFormStringInput("keywordInput", "keywordInput", null);
        uiKeywordInput.setHTMLAttribute("placeholder", "Search");
        this.addUIFormInput((UIFormInput)uiKeywordInput);
        ResourceBundle resourceBundle = WebuiRequestContext.getCurrentInstance().getApplicationResourceBundle();
        ArrayList<SelectItemOption> displayModes = new ArrayList<SelectItemOption>(4);
        displayModes.add(new SelectItemOption(resourceBundle.getString("UIAddOnSearchPortlet.label.sort-popular"), (Object)"popular"));
        displayModes.add(new SelectItemOption(resourceBundle.getString("UIAddOnSearchPortlet.label.sort-az"), (Object)"az"));
        displayModes.add(new SelectItemOption(resourceBundle.getString("UIAddOnSearchPortlet.label.sort-za"), (Object)"za"));
        displayModes.add(new SelectItemOption(resourceBundle.getString("UIAddOnSearchPortlet.label.sort-latest"), (Object)"latest"));
        UIDropDownControl uiDropDownControl = (UIDropDownControl)this.addChild(UIDropDownControl.class, "DisplayModesDropDown", null);
        uiDropDownControl.setOptions(displayModes);
        this.setSelectedMode(uiDropDownControl);
        this.categoryNameDropDown = (UIDropDownControl)this.addChild(UIDropDownControl.class, "CategoryNameDropDown", null);
        this.featuredCategory = PropertyManager.getProperty((String)"exo.addon.marketplace.featured.category.name").trim();
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        if (REFRESH.booleanValue()) {
            filterSelected = "";
        }
        List categories = this.marketPlaceService.findAllCategories();
        this.categoriesList = new ArrayList();
        this.categoriesList.add(new SelectItemOption("ALL", (Object)"ALL"));
        if (this.featuredCategory != null && this.featuredCategory.length() > 0) {
            this.categoriesList.add(new SelectItemOption(this.featuredCategory, (Object)this.featuredCategory));
        }
        for (Category category : categories) {
            if (category.getName().equalsIgnoreCase(this.featuredCategory)) continue;
            this.categoriesList.add(new SelectItemOption(category.getName(), (Object)category.getName()));
        }
        this.categoryNameDropDown.setOptions(this.categoriesList);
        super.processRender(context);
    }

    private void setSelectedMode(UIDropDownControl uiDropDownControl) {
        if (filterSelected != null && filterSelected.length() > 0 && !filterSelected.equals("myaddons")) {
            uiDropDownControl.setValue(filterSelected);
        } else {
            uiDropDownControl.setValue("popular");
        }
    }

    public Boolean isMyAddonsVisible() {
        String userId = Util.getPortalRequestContext().getRemoteUser();
        if (userId != null) {
            return true;
        }
        return false;
    }

    public Boolean isAdminUser() {
        UserACL userACL = (UserACL)UIAddOnSearchForm.getService(UserACL.class);
        return userACL.isUserInGroup(userACL.getAdminGroups());
    }

    public String getStyleFilterSelected(String strIn) {
        if (filterSelected.equals(strIn)) {
            return "btnFilter btn active";
        }
        return "actionIcon btnFilter";
    }

    public void setBtnBackToAddonsVisible(Boolean visible) {
        this.btnBackToAddonsVisible = visible;
    }

    public Boolean getBtnBackToAddonsVisible() {
        return this.btnBackToAddonsVisible;
    }

    public static <T> T getService(Class<T> clazz) {
        return (T)UIAddOnSearchForm.getService(clazz, null);
    }

    public static <T> T getService(Class<T> clazz, String containerName) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (containerName != null) {
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        if (container.getComponentInstanceOfType(clazz) == null) {
            containerName = PortalContainer.getCurrentPortalContainerName();
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        return clazz.cast(container.getComponentInstanceOfType(clazz));
    }
}

