/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.community.portlet.addon.search;

import java.util.ArrayList;
import java.util.Collection;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.addon.marketplace.Constants;
import org.exoplatform.addon.service.AddOnService;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.community.portlet.addon.search.UIAddOnSearchOne;
import org.exoplatform.community.portlet.addon.search.UIAddOnSearchResult;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/AddOnSearchPortlet/UIAddOnSearchResult.gtmpl", events={@EventConfig(listeners={ShowMoreActionListener.class})})
public class UIAddOnSearchResult
extends UIContainer
implements Constants {
    private static final Log log = ExoLogger.getLogger(UIAddOnSearchResult.class);
    private ArrayList<Node> data = new ArrayList();
    public static final Integer ITEMS_PER_PAGE = 9;
    public static Boolean REFRESH = true;
    private int showMoreCount = 0;
    private String sqlOrder;
    private int queryStart = 0;
    private String sqlCondition;
    private int totaItem = 0;
    private String keyword = "";
    private Boolean canEdit = false;
    private String addonHomePath;
    private int totalAddon = 0;

    public void processRender(WebuiRequestContext context) throws Exception {
        HttpServletRequest request;
        if (REFRESH.booleanValue()) {
            this.init();
            this.SortAddons("popular", PropertyManager.getProperty((String)"exo.addon.marketplace.featured.category.name").trim().toUpperCase());
        }
        if ((request = Util.getPortalRequestContext().getRequest()).getParameter("category") != null) {
            log.debug("MarketPlace Addon, Load addons based on parameter passed through URL {} ", new Object[]{request.getParameter("category")});
            this.SortAddons("popular", request.getParameter("category").toUpperCase());
        }
        super.processRender(context);
    }

    public void setSQLOrder(String order) {
        this.sqlOrder = order;
    }

    public String getSQLOrder() {
        return this.sqlOrder;
    }

    public void setSQLCondition(String cond) {
        this.sqlCondition = cond;
    }

    public String getSQLCondition() {
        return this.sqlCondition;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword = keyword.trim();
        String cond = " AND ( (exo:title LIKE '%" + keyword + "%') OR ( exo:description LIKE '%" + keyword + "%' )  OR (exo:author LIKE '%" + keyword + "%') ) ";
        if (keyword != null && !"".equals(keyword)) {
            cond = " AND ( contains(exo:title,'" + keyword + "') OR (exo:title LIKE '%" + keyword + "%') OR (exo:name LIKE '%" + keyword + "%') OR  contains( exo:description,'" + keyword + "' ) OR (exo:description LIKE '%" + keyword + "%') OR contains(exo:author,'" + keyword + "') OR (exo:author LIKE '%" + keyword + "%')  ) ";
        }
        this.setSQLCondition(cond);
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setQueryStart(int st) {
        this.queryStart = st;
    }

    public int getQueryStart() {
        return this.queryStart;
    }

    public void setShowMoreCount(int count) {
        this.showMoreCount = count;
    }

    public int getShowMoreCount() {
        return this.showMoreCount;
    }

    public void setTotalItem(int total) {
        this.totaItem = total;
    }

    public int getTotalItem() {
        return this.totaItem;
    }

    public Boolean getCanEdit() {
        return this.canEdit;
    }

    public void setCanEdit(Boolean canEdit) {
        this.canEdit = canEdit;
    }

    private boolean checkLoginUserPermission() {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortalRequestContext prc = (PortalRequestContext)context.getParentAppRequestContext();
        UIPortalApplication portalApp = (UIPortalApplication)prc.getUIApplication();
        UIPortal portal = portalApp.getCurrentSite();
        UserACL userACL = (UserACL)portal.getApplicationComponent(UserACL.class);
        String loginUserId = prc.getRemoteUser();
        if (null == loginUserId || loginUserId.length() == 0) {
            return false;
        }
        if (userACL.getSuperUser().equalsIgnoreCase(loginUserId)) {
            return true;
        }
        try {
            OrganizationService organizationService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
            Collection membershipCollection = organizationService.getMembershipHandler().findMembershipsByUserAndGroup(loginUserId, "/platform/administrators");
            if (membershipCollection.isEmpty()) {
                return false;
            }
            for (Membership membership : membershipCollection) {
                String membershipType = membership.getMembershipType();
                if (!membershipType.equals("*") && !membershipType.equals("manager")) continue;
                return true;
            }
        }
        catch (Exception e) {
            log.warn((Object)e);
            return false;
        }
        return false;
    }

    public void init() throws Exception {
        this.addonHomePath = AddOnService.getAddOnHomePath();
        this.setCanEdit(Boolean.valueOf(this.checkLoginUserPermission()));
        this.clearResult();
        this.setKeyword("");
        this.searchDBAddonByKey();
        this.getTotalDBResources();
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        portletRequestContext.addUIComponentToUpdateByAjax((UIComponent)this);
    }

    public void clearResult() throws RepositoryException {
        this.resetChild();
        this.setData(new ArrayList());
        this.setShowMoreCount(0);
        this.setQueryStart(0);
        this.setSQLOrder(" ORDER BY exo:title ASC ");
    }

    private void resetChild() throws RepositoryException {
        if (this.getData().size() > 0) {
            for (Node aNode : this.getData()) {
                this.removeChild(UIAddOnSearchOne.class);
            }
        }
    }

    public void setData(ArrayList<Node> data) {
        this.data = data;
    }

    public ArrayList<Node> getData() {
        return this.data;
    }

    public void doSearch() throws Exception {
        this.searchDBAddonByKey();
        this.getTotalDBResources();
    }

    public void showMyAddons() {
        REFRESH = false;
        try {
            this.clearResult();
            String sqlCond = this.getSQLCondition();
            String userID = Util.getPortalRequestContext().getRemoteUser();
            sqlCond = sqlCond + " AND exo:owner = '" + userID + "' ";
            this.setSQLCondition(sqlCond);
            this.doSearch();
        }
        catch (RepositoryException e) {
            log.error((Object)"ERR show my addons");
        }
        catch (Exception e) {
            log.error((Object)"ERR show my addons");
        }
    }

    public void showAddonsByCategory(String categoryName) {
        REFRESH = false;
        StringBuffer sqlQuery = null;
        try {
            this.clearResult();
            sqlQuery = new StringBuffer("SELECT * FROM exo:addon WHERE jcr:path like '" + this.addonHomePath + "%' AND NOT jcr:path LIKE '" + this.addonHomePath + "%/%' AND publication:currentState='published' AND NOT (jcr:mixinTypes = 'exo:restoreLocation') ");
            if (!categoryName.equalsIgnoreCase("ALL")) {
                sqlQuery.append(" AND UPPER (mix:mpkaceAddonCatName) = '" + categoryName + "' ");
            }
            QueryResult result = this.excSQL(sqlQuery.toString(), Boolean.valueOf(true));
            NodeIterator it = result.getNodes();
            while (it.hasNext()) {
                Node findedNode = it.nextNode();
                if (super.getChildById(findedNode.getUUID()) == null) {
                    UIAddOnSearchOne uiAddOnSearchOne = (UIAddOnSearchOne)this.addChild(UIAddOnSearchOne.class, null, findedNode.getUUID());
                    uiAddOnSearchOne.setNodeId(findedNode.getUUID());
                    uiAddOnSearchOne.setCanEdit(this.getCanEdit());
                }
                this.data.add(findedNode);
            }
        }
        catch (RepositoryException re) {
            log.error((Object)("Error to load addons within the category called " + categoryName));
        }
        catch (Exception e) {
            log.error((Object)("Error to load addons within the category called " + categoryName));
        }
    }

    public void SortAddons(String sort, String selectedCat) {
        REFRESH = false;
        try {
            this.clearResult();
            if (sort.equals("za")) {
                if (!selectedCat.equalsIgnoreCase("ALL")) {
                    this.setSQLOrder(" AND UPPER (mix:mpkaceAddonCatName) = '" + selectedCat + "' ORDER BY exo:title DESC ");
                } else {
                    this.setSQLOrder(" ORDER BY exo:title DESC ");
                }
            } else if (sort.equals("az")) {
                if (!selectedCat.equalsIgnoreCase("ALL")) {
                    this.setSQLOrder(" AND UPPER (mix:mpkaceAddonCatName) = '" + selectedCat + "' ORDER BY exo:title ASC ");
                } else {
                    this.setSQLOrder(" ORDER BY exo:title ASC ");
                }
            } else if (sort.equals("latest")) {
                if (!selectedCat.equalsIgnoreCase("ALL")) {
                    this.setSQLOrder(" AND UPPER (mix:mpkaceAddonCatName) = '" + selectedCat + "' ORDER BY exo:dateModified DESC ");
                } else {
                    this.setSQLOrder(" ORDER BY exo:dateModified DESC ");
                }
            } else if (!selectedCat.equalsIgnoreCase("ALL")) {
                this.setSQLOrder(" AND UPPER (mix:mpkaceAddonCatName) = '" + selectedCat + "' ORDER BY exo:voteTotal DESC, exo:votingRate DESC ");
            } else {
                this.setSQLOrder(" ORDER BY exo:voteTotal DESC, exo:votingRate DESC ");
            }
            this.doSearch();
        }
        catch (RepositoryException e) {
            log.error((Object)"ERR show my addons");
        }
        catch (Exception e) {
            log.error((Object)"ERR show my addons");
        }
    }

    public void searchDBAddonByKey() throws Exception {
        String sqlQuery = "";
        String sqlStatement = " SELECT * FROM exo:addon WHERE jcr:path like '" + this.addonHomePath + "%' AND NOT jcr:path LIKE '" + this.addonHomePath + "%/%' AND publication:currentState='published' AND  NOT (jcr:mixinTypes = 'exo:restoreLocation') ";
        sqlQuery = sqlStatement + this.getSQLCondition() + this.getSQLOrder();
        this.getDBResource(sqlQuery);
    }

    private QueryResult excSQL(String sqlQuery, Boolean limit) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
        Session session = sessionProvider.getSession(WCMCoreUtils.getRepository().getConfiguration().getDefaultWorkspaceName(), WCMCoreUtils.getRepository());
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        QueryImpl query = (QueryImpl)queryManager.createQuery(sqlQuery, "sql");
        if (limit.booleanValue()) {
            if (this.getQueryStart() != 0) {
                query.setOffset((long)this.getQueryStart());
                log.debug((Object)(" ================ start " + this.getQueryStart() + " ========================== "));
            }
            query.setLimit((long)ITEMS_PER_PAGE.intValue());
        }
        QueryResult result = query.execute();
        return result;
    }

    private void getDBResource(String sqlQuery) throws Exception {
        QueryResult result = this.excSQL(sqlQuery, Boolean.valueOf(true));
        NodeIterator it = result.getNodes();
        while (it.hasNext()) {
            Node findedNode = it.nextNode();
            if (super.getChildById(findedNode.getUUID()) == null) {
                UIAddOnSearchOne uiAddOnSearchOne = (UIAddOnSearchOne)this.addChild(UIAddOnSearchOne.class, null, findedNode.getUUID());
                uiAddOnSearchOne.setNodeId(findedNode.getUUID());
                uiAddOnSearchOne.setCanEdit(this.getCanEdit());
            }
            this.data.add(findedNode);
        }
    }

    public void getTotalDBResources() throws Exception {
        String sqlQuery = "SELECT exo:name FROM exo:addon WHERE jcr:path like '" + this.addonHomePath + "%' AND NOT jcr:path LIKE '" + this.addonHomePath + "%/%' AND publication:currentState='published' AND NOT (jcr:mixinTypes = 'exo:restoreLocation') ";
        sqlQuery = sqlQuery + this.getSQLCondition();
        QueryResult result = this.excSQL(sqlQuery, Boolean.valueOf(false));
        int count = (int)result.getRows().getSize();
        log.debug((Object)(" ================ total item " + count + " ========================== "));
        this.setTotalItem(count);
    }

    public Boolean isShowMore() {
        if (this.getTotalItem() > this.getData().size()) {
            return true;
        }
        return false;
    }
}

