/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.listeners;

import io.meeds.chat.service.MatrixService;
import jakarta.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MatrixUserListener
extends UserEventListener {
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private MatrixService matrixService;
    @Autowired
    private OrganizationService organizationService;

    @PostConstruct
    public void init() {
        this.organizationService.getUserHandler().addUserEventListener((UserEventListener)this);
    }

    public void postSave(User user, boolean isNew) throws Exception {
        String matrixRestrictedGroup = PropertyManager.getProperty((String)"meeds.matrix.restricted.users.groupId");
        if (StringUtils.isNotBlank((CharSequence)matrixRestrictedGroup) && !this.matrixService.isUserMemberOfGroup(user.getUserName(), matrixRestrictedGroup)) {
            return;
        }
        this.matrixService.saveUserAccount(user, isNew, false);
    }

    public void postSetEnabled(User user) throws Exception {
        Profile userProfile;
        String matrixId;
        if (this.identityManager != null && StringUtils.isNotBlank((CharSequence)(matrixId = (String)(userProfile = this.identityManager.getProfile(this.identityManager.getOrCreateUserIdentity(user.getUserName()))).getProperty("matrixId")))) {
            if (!user.isEnabled()) {
                String matrixUsername = "@" + user.getUserName() + ":" + PropertyManager.getProperty((String)"meeds.matrix.server.name");
                this.matrixService.disableAccount(matrixUsername);
            } else {
                this.matrixService.saveUserAccount(user, false, true);
            }
        }
    }
}

