/*
 * Decompiled with CFR 0.152.
 */
import io.meeds.chat.model.MatrixRoomPermissions;
import io.meeds.chat.service.utils.MatrixHttpClient;
import java.io.IOException;
import java.util.Date;
import java.util.Random;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.idm.UserImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MatrixUtilsTest {
    private String access_token = "syt_ZXhv_BDVYgRelgkgjGduvVCyz_1iXdtf";

    @Before
    public void setUp() {
        System.setProperty("meeds.matrix.server.url", "http://localhost:8008");
        System.setProperty("meeds.matrix.shared_secret_registration", "4fzT.7xvkyp1EA-*bX#fzpVgOc_cb0y9z6*uOCUht1DO5ksad8");
        System.setProperty("meeds.matrix.server.name", "matrix.exo.tn");
    }

    public void testCreateUserAccount() {
        String randomKey = String.valueOf(Math.round(Math.random() * 100.0));
        UserImpl user = new UserImpl("testUser" + randomKey);
        user.setEmail("test@exo.com");
        user.setFirstName("test " + randomKey);
        user.setLastName("User");
        MatrixHttpClient.createUserAccount((User)user, (String)this.access_token);
    }

    public void testSaveUserAccount() {
        String randomKey = String.valueOf(Math.round(Math.random() * 100.0));
        UserImpl user = new UserImpl("testUser" + randomKey);
        user.setEmail("test@exo.com");
        user.setFirstName("test " + randomKey);
        user.setLastName("User");
        MatrixHttpClient.saveUserAccount((User)user, (String)user.getUserName(), (boolean)true, (String)this.access_token, (boolean)false);
    }

    public void testDisableUserAccount() {
        String randomKey = String.valueOf(Math.round(Math.random() * 10000.0));
        UserImpl user = new UserImpl("testUser" + randomKey);
        user.setEmail("test" + randomKey + "@exo.com");
        user.setFirstName("test " + randomKey);
        user.setLastName("User");
        String username = MatrixHttpClient.saveUserAccount((User)user, (String)user.getUserName(), (boolean)true, (String)this.access_token, (boolean)false);
        MatrixHttpClient.disableAccount((String)username, (boolean)false, (String)this.access_token);
    }

    public void testRenameSpace() {
        String roomId = null;
        try {
            roomId = MatrixHttpClient.createRoom((String)"new room", (String)"new room description", (String)this.access_token);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNotNull((Object)MatrixHttpClient.renameRoom((String)roomId, (String)("new room renamed" + new Date().getTime()), (String)this.access_token));
    }

    public void testInviteUser() throws Exception {
        String randomKey = String.valueOf(Math.round(Math.random() * 10000.0));
        UserImpl user = new UserImpl("testUser" + randomKey);
        user.setEmail("test" + randomKey + "@exo.com");
        user.setFirstName("test " + randomKey);
        user.setLastName("User");
        String invitee = MatrixHttpClient.saveUserAccount((User)user, (String)user.getUserName(), (boolean)true, (String)this.access_token, (boolean)false);
        String roomId = MatrixHttpClient.createRoom((String)"Football game", (String)"Description of Football team", (String)this.access_token);
        MatrixHttpClient.inviteUserToRoom((String)roomId, (String)invitee, (String)"Welcome to Football game room !", (String)this.access_token);
    }

    public void testKickUser() {
        String roomId = "!rYdqPkQhIzNWyVPDFX";
        MatrixHttpClient.kickUserFromRoom((String)roomId, (String)"@testuser1:matrix.exo.tn", (String)"Talking too much!", (String)this.access_token);
    }

    public void updateRoomSettings() {
        String roomId = "!rYdqPkQhIzNWyVPDFX";
        MatrixRoomPermissions settings = MatrixHttpClient.getRoomSettings((String)roomId, (String)this.access_token);
        settings.setInvite("0");
        String updateEventId = MatrixHttpClient.updateRoomSettings((String)roomId, (MatrixRoomPermissions)settings, (String)this.access_token);
    }

    public void updateRoomAvatar() {
        try {
            String roomId = "!HaTqHwWINwoSoIGfZx";
            byte[] resource = this.getClass().getClassLoader().getResourceAsStream("meeds.png").readAllBytes();
            String imageStored = MatrixHttpClient.uploadFile((String)"image.png", (String)"image/png", (byte[])resource, (String)this.access_token);
            boolean bl = MatrixHttpClient.updateRoomAvatar((String)roomId, (String)imageStored, (String)this.access_token);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void updateUserAvatar() {
        try {
            String roomId = "@root:matrix.exo.tn";
            int randomInt = new Random().nextInt(3);
            byte[] resource = this.getClass().getClassLoader().getResourceAsStream("avatar" + randomInt + ".png").readAllBytes();
            String imageStored = MatrixHttpClient.uploadFile((String)"image.png", (String)"image/png", (byte[])resource, (String)this.access_token);
            Assert.assertTrue((boolean)MatrixHttpClient.updateUserAvatar((String)roomId, (String)imageStored, (String)this.access_token));
        }
        catch (IOException e) {
            Assert.fail();
        }
    }

    @Test
    public void testCleanMatrixUsername() {
        String[] usernames;
        for (String username : usernames = new String[]{"Samue\u00e2l", "fre@d", "Shazia", "gorkef/", "\u00b2&\u00e9\"'(-\u00e8_\u00e7\u00e0)=\u00b21234567890\u00b0+'azertyuiopqsdfghjklm\u00f9*^$wxcvbn,;:!?./\u00a7%\u00b5\u00a8\u00a3<>\u00b2&~#{[|`\\^@]}"}) {
            String result = MatrixHttpClient.cleanMatrixUsername((String)username);
            Assert.assertNotNull((Object)result);
        }
    }

    public void testDeleteSpace() throws Exception {
        long currentTime = System.currentTimeMillis();
        String matrixRoomId = MatrixHttpClient.createRoom((String)("test space" + currentTime), (String)("test description " + currentTime), (String)this.access_token);
        MatrixHttpClient.deleteRoom((String)matrixRoomId, (String)this.access_token);
    }
}

