/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.notification;

import io.meeds.chat.notification.MessageReceivedPWAPlugin;
import io.meeds.portal.permlink.model.PermanentLinkObject;
import io.meeds.portal.permlink.service.PermanentLinkService;
import io.meeds.pwa.model.PwaNotificationMessage;
import java.util.Locale;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.ResourceBundleService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class MessageReceivedPWAPluginTest {
    private ResourceBundleService resourceBundleService = (ResourceBundleService)Mockito.mock(ResourceBundleService.class);
    private PermanentLinkService permanentLinkService = (PermanentLinkService)Mockito.mock(PermanentLinkService.class);

    MessageReceivedPWAPluginTest() {
    }

    @Test
    void process() {
        String roomId = "thisIsRoomId";
        MessageReceivedPWAPlugin messageReceivedPWAPlugin = new MessageReceivedPWAPlugin(this.resourceBundleService, this.permanentLinkService);
        NotificationInfo notificationInfo = NotificationInfo.instance().to("root").with("MATRIX_ROOM_ID", roomId).with("MATRIX_ROOM_UNREAD_COUNT", "10").key("MatrixMessageReceivedNotificationPlugin").end();
        LocaleConfig localeConfig = (LocaleConfig)Mockito.mock(LocaleConfig.class);
        Mockito.when((Object)localeConfig.getLocale()).thenReturn((Object)Locale.ENGLISH);
        Mockito.when((Object)this.resourceBundleService.getSharedString(ArgumentMatchers.anyString(), (Locale)ArgumentMatchers.any(Locale.class))).thenReturn((Object)"There are {0} unread messages in room {1}");
        Mockito.when((Object)this.permanentLinkService.getPermanentLink((PermanentLinkObject)ArgumentMatchers.any(PermanentLinkObject.class))).thenReturn((Object)("http://exo.com/portal/dw/matrixRoomId=" + roomId));
        PwaNotificationMessage pwaNotificationMessage = messageReceivedPWAPlugin.process(notificationInfo, localeConfig);
        Assertions.assertNotNull((Object)pwaNotificationMessage);
        Assertions.assertEquals((Object)"There are 10 unread messages in room thisIsRoomId", (Object)pwaNotificationMessage.getTitle());
        Assertions.assertEquals((Object)("http://exo.com/portal/dw/matrixRoomId=" + roomId), (Object)pwaNotificationMessage.getUrl());
    }
}

