/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.oidc.services;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.io.Decoders;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RemoteJwkSigningKeyResolver
implements SigningKeyResolver {
    private final String issuer;
    private final Object lock = new Object();
    private volatile Map<String, Key> keyMap = new HashMap<String, Key>();
    private static final Log LOG = ExoLogger.getLogger(RemoteJwkSigningKeyResolver.class);

    RemoteJwkSigningKeyResolver(String issuer) {
        this.issuer = issuer;
    }

    public Key resolveSigningKey(JwsHeader header, Claims claims) {
        return this.getKey(header.getKeyId());
    }

    public Key resolveSigningKey(JwsHeader header, String plaintext) {
        return this.getKey(header.getKeyId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Key getKey(String keyId) {
        Key result = this.keyMap.get(keyId);
        if (result != null) {
            return result;
        }
        Object object = this.lock;
        synchronized (object) {
            result = this.keyMap.get(keyId);
            if (result != null) {
                return result;
            }
            this.updateKeys();
            return this.keyMap.get(keyId);
        }
    }

    private void updateKeys() {
        JsonObject configuration = this.getJson(this.issuer + "/.well-known/openid-configuration");
        String jwksUrl = configuration.getString("jwks_uri");
        JsonObject keys = this.getJson(jwksUrl);
        Map<String, Key> newKeys = keys.getJsonArray("keys").stream().map(JsonValue::asJsonObject).filter(json -> "sig".equals(json.getString("use"))).filter(json -> "RSA".equals(json.getString("kty"))).collect(Collectors.toMap(jsonObject -> jsonObject.getString("kid"), jsonObject -> {
            BigInteger modulus = this.base64ToBigInteger(jsonObject.getString("n"));
            BigInteger exponent = this.base64ToBigInteger(jsonObject.getString("e"));
            RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(modulus, exponent);
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                return keyFactory.generatePublic(rsaPublicKeySpec);
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                throw new IllegalStateException("Failed to parse public key");
            }
        }));
        this.keyMap = Collections.unmodifiableMap(newKeys);
    }

    private JsonObject getJson(String url) {
        StringBuilder content = new StringBuilder();
        try {
            String line;
            URL wellKnownUrl = new URL(url);
            URLConnection urlConnection = wellKnownUrl.openConnection();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            while ((line = bufferedReader.readLine()) != null) {
                content.append(line + "\n");
            }
            bufferedReader.close();
        }
        catch (Exception e) {
            LOG.error("Error when reading url {}", new Object[]{url});
        }
        JsonReader reader = Json.createReader((Reader)new StringReader(content.toString()));
        return reader.readObject();
    }

    private BigInteger base64ToBigInteger(String value) {
        return new BigInteger(1, (byte[])Decoders.BASE64URL.decode((Object)value));
    }
}

