/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.oidc.services;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.time.Instant;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.exoplatform.addons.oidc.services.OIDCService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/oidc")
@Api(value="/oidc", description="Manages OIDC features")
public class OIDCRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(OIDCRestService.class);

    @Path(value="/settings")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get OIDC Settings", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getOidcSettings(@Context HttpServletRequest request) {
        OIDCService oidcService = (OIDCService)CommonsUtils.getService(OIDCService.class);
        JSONObject result = new JSONObject();
        try {
            result.put("clientId", (Object)oidcService.getClientId());
            result.put("oidcServer", (Object)oidcService.getOidcServer());
            result.put("redirectUri", (Object)(this.getUrl(request) + oidcService.getRedirectUri()));
            return Response.ok().entity((Object)result.toString()).build();
        }
        catch (JSONException e) {
            LOG.error((Object)"Unable to build response", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @Path(value="/token")
    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Register OIDC Token", httpMethod="POST", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=500, message="Internal server error")})
    public Response registerToken(@ApiParam(value="Token to register", required=true) @FormParam(value="token") String token, @ApiParam(value="Nonce to validate", required=true) @FormParam(value="nonce") String nonce, @ApiParam(value="Issuer to validate", required=true) @FormParam(value="issuer") String issuer, @ApiParam(value="ClientId to validate", required=true) @FormParam(value="clientId") String clientId, @Context HttpServletRequest request) {
        HttpSession session = request.getSession();
        OIDCService oidcService = (OIDCService)CommonsUtils.getService(OIDCService.class);
        Instant expirationInstant = oidcService.validateToken(ConversationState.getCurrent().getIdentity().getUserId(), token, nonce, issuer, clientId);
        if (expirationInstant != null) {
            session.setAttribute("mfaValidated", (Object)true);
            session.setAttribute("mfaExpiration", (Object)expirationInstant);
            return Response.ok().build();
        }
        return Response.serverError().build();
    }

    private StringBuilder getUrl(HttpServletRequest request) {
        StringBuilder url = new StringBuilder();
        if (request != null) {
            url.append(request.getScheme()).append("://").append(request.getServerName());
            if (request.getServerPort() != 80 && request.getServerPort() != 443) {
                url.append(':').append(request.getServerPort());
            }
        }
        return url;
    }
}

