/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.oidc.services;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.InvalidClaimException;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MissingClaimException;
import io.jsonwebtoken.SigningKeyResolver;
import java.time.Instant;
import org.exoplatform.addons.oidc.services.RemoteJwkSigningKeyResolver;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class OIDCService {
    private String clientId;
    private String oidcServer;
    private String redirectUri;
    private static final Log LOG = ExoLogger.getLogger(OIDCService.class);
    private RemoteJwkSigningKeyResolver remoteJwkSigningKeyResolver;

    public OIDCService(InitParams initParams) {
        ValueParam redirectUri;
        ValueParam oidcServer;
        ValueParam clientId = initParams.getValueParam("clientId");
        if (clientId != null) {
            this.clientId = clientId.getValue();
        }
        if ((oidcServer = initParams.getValueParam("oidcServer")) != null) {
            this.oidcServer = oidcServer.getValue();
        }
        if ((redirectUri = initParams.getValueParam("redirectUri")) != null) {
            this.redirectUri = redirectUri.getValue();
        }
        this.remoteJwkSigningKeyResolver = new RemoteJwkSigningKeyResolver(this.oidcServer);
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getOidcServer() {
        return this.oidcServer;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public Instant validateToken(String user, String token, String nonce, String issuer, String clientId) {
        try {
            Jwt jwt = Jwts.parser().requireIssuer(issuer).requireAudience(clientId).require("nonce", (Object)nonce).setSigningKeyResolver((SigningKeyResolver)this.remoteJwkSigningKeyResolver).parse(token);
            Claims claims = (Claims)jwt.getBody();
            if (claims.getExpiration().toInstant().isBefore(Instant.now())) {
                LOG.error((Object)"Token is expired");
                return null;
            }
            return claims.getExpiration().toInstant();
        }
        catch (MissingClaimException e) {
            LOG.error("Missing Claim {}", new Object[]{e.getClaimName(), e});
        }
        catch (InvalidClaimException ice) {
            LOG.error("Invalide Claim {}", new Object[]{ice.getClaimName(), ice});
        }
        catch (JwtException e) {
            LOG.error((Object)"Jwt Signature Verification Failed", (Throwable)e);
        }
        return null;
    }
}

