/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.webui.composer;

import org.exoplatform.commons.api.settings.ExoFeatureService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.composer.UIActivityComposer;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.social.webui.profile.UIUserActivitiesDisplay;
import org.exoplatform.social.webui.space.UISpaceActivitiesDisplay;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;

@ComponentConfig(template="war:/groovy/news/webui/composer/UINewsActivityComposer.gtmpl", events={@EventConfig(listeners={UIActivityComposer.CloseActionListener.class}), @EventConfig(listeners={UIActivityComposer.SubmitContentActionListener.class}), @EventConfig(listeners={UIActivityComposer.ActivateActionListener.class})})
public class UINewsActivityComposer
extends UIActivityComposer {
    private static final Log LOG = ExoLogger.getLogger(UINewsActivityComposer.class);
    private static final String NEWS_FEATURE_NAME = "news";
    private static final String REDACTOR_MEMBERSHIP_NAME = "redactor";
    private static final String MANAGER_MEMBERSHIP_NAME = "manager";
    private static final String PUBLISHER_MEMBERSHIP_NAME = "publisher";
    private static final String PLATFORM_WEB_CONTRIBUTORS_GROUP = "/platform/web-contributors";
    private IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
    private ExoFeatureService featureService = (ExoFeatureService)CommonsUtils.getService(ExoFeatureService.class);

    public UINewsActivityComposer() {
        this.setReadyForPostingActivity(true);
    }

    public boolean isEnabled() {
        if (!this.featureService.isActiveFeature(NEWS_FEATURE_NAME)) {
            return false;
        }
        Space space = this.getCurrentSpace();
        if (space == null) {
            return false;
        }
        Identity ownerIdentity = ConversationState.getCurrent().getIdentity();
        return ownerIdentity.isMemberOf(space.getGroupId(), REDACTOR_MEMBERSHIP_NAME) || ownerIdentity.isMemberOf(space.getGroupId(), MANAGER_MEMBERSHIP_NAME) || ownerIdentity.isMemberOf(PLATFORM_WEB_CONTRIBUTORS_GROUP, PUBLISHER_MEMBERSHIP_NAME);
    }

    protected ExoSocialActivity onPostActivity(UIComposer.PostContext postContext, String postedMessage) throws Exception {
        ExoSocialActivityImpl activity = null;
        if (postedMessage.equals("")) {
            WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            UIApplication uiApplication = requestContext.getUIApplication();
            uiApplication.addMessage(new ApplicationMessage("UIComposer.msg.error.Empty_Message", null, 1));
            return activity;
        }
        if (postContext == UIComposer.PostContext.SPACE) {
            UISpaceActivitiesDisplay uiDisplaySpaceActivities = (UISpaceActivitiesDisplay)this.getActivityDisplay();
            Space space = uiDisplaySpaceActivities.getSpace();
            org.exoplatform.social.core.identity.model.Identity spaceIdentity = Utils.getIdentityManager().getOrCreateIdentity("space", space.getPrettyName(), false);
            activity = new ExoSocialActivityImpl(Utils.getViewerIdentity().getId(), "exosocial:spaces", postedMessage, null);
            activity.setType(NEWS_FEATURE_NAME);
            Utils.getActivityManager().saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        } else if (postContext == UIComposer.PostContext.USER) {
            UIUserActivitiesDisplay uiUserActivitiesDisplay = (UIUserActivitiesDisplay)this.getActivityDisplay();
            org.exoplatform.social.core.identity.model.Identity ownerIdentity = Utils.getIdentityManager().getOrCreateIdentity("organization", uiUserActivitiesDisplay.getOwnerName(), false);
            activity = new ExoSocialActivityImpl(Utils.getViewerIdentity().getId(), "exosocial:people", postedMessage, null);
            activity.setType(NEWS_FEATURE_NAME);
            Utils.getActivityManager().saveActivityNoReturn(ownerIdentity, (ExoSocialActivity)activity);
            if (uiUserActivitiesDisplay.getSelectedDisplayMode() == UIUserActivitiesDisplay.DisplayMode.MY_SPACE) {
                uiUserActivitiesDisplay.setSelectedDisplayMode(UIUserActivitiesDisplay.DisplayMode.ALL_ACTIVITIES);
            }
        }
        return activity;
    }

    protected void onPostActivity(UIComposer.PostContext postContext, UIComponent source, WebuiRequestContext requestContext, String postedMessage) throws Exception {
    }

    protected void onClose(Event<UIActivityComposer> event) {
    }

    protected void onSubmit(Event<UIActivityComposer> event) {
    }

    protected void onActivate(Event<UIActivityComposer> event) {
        String userId;
        org.exoplatform.social.core.identity.model.Identity identity;
        String userIdentityId = null;
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null && conversationState.getIdentity() != null && (identity = this.identityManager.getOrCreateIdentity("organization", userId = conversationState.getIdentity().getUserId(), false)) != null) {
            userIdentityId = identity.getId();
        }
        Space space = this.getCurrentSpace();
        LOG.info("service=news operation=display_news_composer parameters=\"space_name:{},space_id:{},user_id:{}\"", new Object[]{space != null ? space.getPrettyName() : null, space != null ? space.getId() : null, userIdentityId});
        this.setReadyForPostingActivity(true);
    }

    public boolean canPinNews() {
        Space space = this.getCurrentSpace();
        if (space == null) {
            return false;
        }
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        return currentIdentity.isMemberOf(PLATFORM_WEB_CONTRIBUTORS_GROUP, PUBLISHER_MEMBERSHIP_NAME);
    }

    private Space getCurrentSpace() {
        Space space = null;
        UIContainer uiContainer = this.getActivityDisplay();
        if (uiContainer instanceof UISpaceActivitiesDisplay) {
            space = ((UISpaceActivitiesDisplay)uiContainer).getSpace();
        }
        return space;
    }
}

