/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.notification.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class PostNewsNotificationPlugin
extends BaseNotificationPlugin {
    private static final Log LOG = ExoLogger.getLogger(PostNewsNotificationPlugin.class);
    public static final String ID = "PostNewsNotificationPlugin";
    public static final ArgumentLiteral<String> CONTENT_TITLE = new ArgumentLiteral(String.class, "CONTENT_TITLE");
    public static final ArgumentLiteral<String> CONTENT_UPDATER = new ArgumentLiteral(String.class, "CONTENT_UPDATER");
    public static final ArgumentLiteral<String> CONTENT_AUTHOR = new ArgumentLiteral(String.class, "CONTENT_AUTHOR");
    public static final ArgumentLiteral<String> CONTENT_SPACE = new ArgumentLiteral(String.class, "CONTENT_SPACE");
    public static final ArgumentLiteral<String> CONTENT_SPACE_ID = new ArgumentLiteral(String.class, "CONTENT_SPACE_ID");
    public static final ArgumentLiteral<String> ILLUSTRATION_URL = new ArgumentLiteral(String.class, "ILLUSTRATION_URL");
    public static final ArgumentLiteral<String> ACTIVITY_LINK = new ArgumentLiteral(String.class, "ACTIVITY_LINK");
    private SpaceService spaceService;
    private UserHandler userhandler;

    public PostNewsNotificationPlugin(InitParams initParams, SpaceService spaceService, OrganizationService organizationService) {
        super(initParams);
        this.spaceService = spaceService;
        this.userhandler = organizationService.getUserHandler();
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        String contentAuthorUserName;
        String contentTitle = (String)ctx.value(CONTENT_TITLE);
        String contentAuthor = contentAuthorUserName = (String)ctx.value(CONTENT_AUTHOR);
        try {
            User contentAuthorUser = this.userhandler.findUserByName(contentAuthorUserName);
            contentAuthor = contentAuthorUser.getFullName();
        }
        catch (Exception e) {
            LOG.error((Object)("An error occured when trying to retreive a user with username " + contentAuthorUserName + " " + e.getMessage()), (Throwable)e);
        }
        String contentSpaceId = (String)ctx.value(CONTENT_SPACE_ID);
        String contentSpaceName = (String)ctx.value(CONTENT_SPACE);
        String illustrationUrl = (String)ctx.value(ILLUSTRATION_URL);
        String activityLink = (String)ctx.value(ACTIVITY_LINK);
        List<Object> receivers = new ArrayList();
        try {
            receivers = this.getReceivers(contentSpaceId, contentAuthorUserName);
        }
        catch (Exception e) {
            LOG.error((Object)("An error occured when trying to have the list of receivers " + e.getMessage()), (Throwable)e);
        }
        return NotificationInfo.instance().setFrom(contentAuthorUserName).with("CONTENT_TITLE", contentTitle).to(receivers).with("CONTENT_AUTHOR", contentAuthor).with("CONTENT_SPACE", contentSpaceName).with("ILLUSTRATION_URL", illustrationUrl).with("ACTIVITY_LINK", activityLink).key(this.getKey()).end();
    }

    private List<String> getReceivers(String contentSpaceId, String contentAuthorUserName) throws Exception {
        Space space = this.spaceService.getSpaceById(contentSpaceId);
        ListAccess members = this.userhandler.findUsersByGroupId(space.getGroupId());
        User[] userArray = (User[])members.load(0, members.getSize());
        List<User> receiverUsers = Arrays.stream(userArray).filter(u -> !u.getUserName().equals(contentAuthorUserName)).collect(Collectors.toList());
        ArrayList receiversIds = new ArrayList();
        receiverUsers.forEach(u -> receiversIds.add(u.getUserName()));
        HashSet receiversSet = new HashSet(receiversIds);
        ArrayList<String> receivers = new ArrayList<String>(receiversSet);
        return receivers;
    }
}

