/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.notification.provider;

import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.webui.utils.TimeConvertUtils;

@TemplateConfigs(templates={@TemplateConfig(pluginId="PostNewsNotificationPlugin", template="war:/notification/templates/mail/postNewsNotificationPlugin.gtmpl"), @TemplateConfig(pluginId="ShareNewsNotificationPlugin", template="war:/notification/templates/mail/postNewsNotificationPlugin.gtmpl"), @TemplateConfig(pluginId="ShareMyNewsNotificationPlugin", template="war:/notification/templates/mail/postNewsNotificationPlugin.gtmpl")})
public class MailTemplateProvider
extends TemplateProvider {
    protected static Log log = ExoLogger.getLogger(MailTemplateProvider.class);
    private IdentityManager identityManager;

    public MailTemplateProvider(InitParams initParams, IdentityManager identityManager) {
        super(initParams);
        this.templateBuilders.put(PluginKey.key((String)"PostNewsNotificationPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"ShareNewsNotificationPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"ShareMyNewsNotificationPlugin"), new TemplateBuilder());
        this.identityManager = identityManager;
    }

    private class TemplateBuilder
    extends AbstractTemplateBuilder {
        private TemplateBuilder() {
        }

        protected MessageInfo makeMessage(NotificationContext ctx) {
            NotificationInfo notification = ctx.getNotificationInfo();
            String pluginId = notification.getKey().getId();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)MailTemplateProvider.this.getChannelKey(), (String)pluginId, (String)language);
            String contentAuthor = notification.getValueOwnerParameter("CONTENT_AUTHOR");
            String currentUser = notification.getValueOwnerParameter("CURRENT_USER");
            String contentTitle = notification.getValueOwnerParameter("CONTENT_TITLE");
            String contentSpaceName = notification.getValueOwnerParameter("CONTENT_SPACE");
            String baseUrl = PropertyManager.getProperty((String)"gatein.email.domain.url");
            String illustrationUrl = baseUrl.concat("/news/images/newsImageDefault.png");
            String activityLink = notification.getValueOwnerParameter("ACTIVITY_LINK");
            String context = notification.getValueOwnerParameter("CONTEXT");
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            templateContext.put((Object)"CONTENT_TITLE", (Object)encoder.encode(contentTitle));
            templateContext.put((Object)"CONTENT_SPACE", (Object)encoder.encode(contentSpaceName));
            templateContext.put((Object)"CONTENT_AUTHOR", (Object)encoder.encode(contentAuthor));
            templateContext.put((Object)"CURRENT_USER", (Object)currentUser);
            templateContext.put((Object)"ILLUSTRATION_URL", (Object)encoder.encode(illustrationUrl));
            templateContext.put((Object)"CONTEXT", (Object)encoder.encode(context));
            templateContext.put((Object)"ACTIVITY_LINK", (Object)encoder.encode(activityLink));
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            Calendar lastModified = Calendar.getInstance();
            lastModified.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)lastModified.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            Identity receiver = MailTemplateProvider.this.identityManager.getOrCreateIdentity("organization", notification.getTo(), true);
            templateContext.put((Object)"FIRST_NAME", (Object)encoder.encode(receiver.getProfile().getProperty("firstName").toString()));
            templateContext.put((Object)"FOOTER_LINK", (Object)LinkProviderUtils.getRedirectUrl((String)"notification_settings", (String)receiver.getRemoteId()));
            String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    }
}

