/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.listener;

import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.news.model.News;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

@Asynchronous
public class AnalyticsNewsListener
extends Listener<String, News> {
    private static final String CREATE_CONTENT_OPERATION_NAME = "createContent";
    private static final String UPDATE_CONTENT_OPERATION_NAME = "updateContent";
    private static final String DELETE_CONTENT_OPERATION_NAME = "deleteContent";
    private static final String VIEW_CONTENT_OPERATION_NAME = "viewContent";
    private static final String SHARE_CONTENT_OPERATION_NAME = "shareContent";
    private static final String LIKE_CONTENT_OPERATION_NAME = "likeContent";
    private static final String COMMENT_CONTENT_OPERATION_NAME = "commentContent";
    private IdentityManager identityManager;
    private SpaceService spaceService;

    public void onEvent(Event<String, News> event) throws Exception {
        News news = (News)event.getData();
        String operation = "";
        switch (event.getEventName()) {
            case "exo.news.postArticle": {
                operation = CREATE_CONTENT_OPERATION_NAME;
                break;
            }
            case "exo.news.updateArticle": {
                operation = UPDATE_CONTENT_OPERATION_NAME;
                break;
            }
            case "exo.news.deleteArticle": {
                operation = DELETE_CONTENT_OPERATION_NAME;
                break;
            }
            case "exo.news.viewArticle": {
                operation = VIEW_CONTENT_OPERATION_NAME;
                break;
            }
            case "exo.news.shareArticle": {
                operation = SHARE_CONTENT_OPERATION_NAME;
                break;
            }
            case "exo.news.commentArticle": {
                operation = COMMENT_CONTENT_OPERATION_NAME;
                break;
            }
            case "exo.news.likeArticle": {
                operation = LIKE_CONTENT_OPERATION_NAME;
            }
        }
        long userId = 0L;
        Identity identity = this.getIdentityManager().getOrCreateIdentity("organization", (String)event.getSource());
        if (identity != null) {
            userId = Long.parseLong(identity.getId());
        }
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("contents");
        statisticData.setSubModule("contents");
        statisticData.setOperation(operation);
        statisticData.setUserId(userId);
        statisticData.addParameter("contentId", (Object)news.getId());
        statisticData.addParameter("contentAuthor", (Object)news.getAuthor());
        statisticData.addParameter("contentLastModifier", (Object)news.getUpdater());
        statisticData.addParameter("contentType", (Object)"News");
        statisticData.addParameter("contentUpdatedDate", (Object)news.getUpdateDate());
        statisticData.addParameter("contentCreationDate", (Object)news.getCreationDate());
        statisticData.addParameter("contentCreationDate", (Object)news.getCreationDate());
        Space space = this.getSpaceService().getSpaceById(news.getSpaceId());
        if (space != null) {
            AnalyticsUtils.addSpaceStatistics((StatisticData)statisticData, (Space)space);
        }
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    public IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = (IdentityManager)ExoContainerContext.getService(IdentityManager.class);
        }
        return this.identityManager;
    }

    public SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)ExoContainerContext.getService(SpaceService.class);
        }
        return this.spaceService;
    }
}

