/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.news.NewsService;
import org.exoplatform.news.model.News;
import org.exoplatform.news.model.SharedNews;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionManager;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionMode;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionType;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.wcm.extensions.publication.PublicationManager;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.impl.LifecyclesConfig;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.publication.WebpagePublicationPlugin;
import org.exoplatform.social.ckeditor.HTMLUploadImageProcessor;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;

public class NewsServiceImpl
implements NewsService {
    public static final String NEWS_NODES_FOLDER = "News";
    public static final String PINNED_NEWS_NODES_FOLDER = "Pinned";
    public static final String APPLICATION_DATA_PATH = "/Application Data";
    private RepositoryService repositoryService;
    private SessionProviderService sessionProviderService;
    private NodeHierarchyCreator nodeHierarchyCreator;
    private DataDistributionType dataDistributionType;
    private SpaceService spaceService;
    private ActivityManager activityManager;
    private IdentityManager identityManager;
    private UploadService uploadService;
    private LinkManager linkManager;
    private HTMLUploadImageProcessor imageProcessor;
    private PublicationService publicationService;
    private PublicationManager publicationManager;
    private WCMPublicationService wCMPublicationService;

    public NewsServiceImpl(RepositoryService repositoryService, SessionProviderService sessionProviderService, NodeHierarchyCreator nodeHierarchyCreator, DataDistributionManager dataDistributionManager, SpaceService spaceService, ActivityManager activityManager, IdentityManager identityManager, UploadService uploadService, HTMLUploadImageProcessor imageProcessor, LinkManager linkManager, PublicationService publicationService, PublicationManager publicationManager, WCMPublicationService wCMPublicationService) {
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.spaceService = spaceService;
        this.activityManager = activityManager;
        this.identityManager = identityManager;
        this.uploadService = uploadService;
        this.imageProcessor = imageProcessor;
        this.linkManager = linkManager;
        this.dataDistributionType = dataDistributionManager.getDataDistributionType(DataDistributionMode.NONE);
        this.publicationService = publicationService;
        this.publicationManager = publicationManager;
        this.wCMPublicationService = wCMPublicationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public News createNews(News news) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        try {
            if (news.getId() == null) {
                news = this.createNewsDraft(news);
            } else {
                this.updateNews(news);
            }
            Node newsNode = session.getNodeByUUID(news.getId());
            this.publicationService.changeState(newsNode, "published", new HashMap());
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        this.postNewsActivity(news);
        if (news.isPinned()) {
            this.pinNews(news.getId());
        }
        return news;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public News getNews(String id) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        try {
            Node node = session.getNodeByUUID(id);
            News news = this.convertNodeToNews(node);
            return news;
        }
        catch (ItemNotFoundException e) {
            News news = null;
            return news;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNews(News news) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        try {
            Node newsNode = session.getNodeByUUID(news.getId());
            if (newsNode != null) {
                newsNode.setProperty("exo:title", news.getTitle());
                newsNode.setProperty("exo:summary", news.getSummary());
                newsNode.setProperty("exo:body", this.imageProcessor.processImages(news.getBody(), newsNode, "images"));
                newsNode.setProperty("exo:dateModified", Calendar.getInstance());
                if (StringUtils.isNotEmpty((CharSequence)news.getUploadId())) {
                    this.attachIllustration(newsNode, news.getUploadId());
                } else if ("".equals(news.getUploadId())) {
                    this.removeIllustration(newsNode);
                }
                newsNode.save();
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Override
    public void pinNews(String newsId) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        News news = this.getNews(newsId);
        Node newsNode = session.getNodeByUUID(newsId);
        newsNode.setProperty("exo:pinned", true);
        newsNode.save();
        Node pinnedRootNode = this.getPinnedNewsFolder();
        Calendar newsCreationCalendar = Calendar.getInstance();
        newsCreationCalendar.setTime(news.getCreationDate());
        Node newsFolderNode = this.dataDistributionType.getOrCreateDataNode(pinnedRootNode, this.getNodeRelativePath(newsCreationCalendar));
        if (newsNode.canAddMixin("exo:privilegeable")) {
            newsNode.addMixin("exo:privilegeable");
        }
        ((ExtendedNode)newsNode).setPermission("*:/platform/users", new String[]{"read"});
        this.linkManager.createLink(newsFolderNode, "exo:symlink", newsNode, null);
    }

    private Node getPinnedNewsFolder() throws Exception {
        Node pinnedRootNode;
        Node newsRootNode;
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        Node applicationDataNode = (Node)session.getItem(APPLICATION_DATA_PATH);
        if (!applicationDataNode.hasNode(NEWS_NODES_FOLDER)) {
            newsRootNode = applicationDataNode.addNode(NEWS_NODES_FOLDER, "nt:unstructured");
            applicationDataNode.save();
        } else {
            newsRootNode = applicationDataNode.getNode(NEWS_NODES_FOLDER);
        }
        if (!newsRootNode.hasNode(PINNED_NEWS_NODES_FOLDER)) {
            pinnedRootNode = newsRootNode.addNode(PINNED_NEWS_NODES_FOLDER, "nt:unstructured");
            newsRootNode.save();
        } else {
            pinnedRootNode = newsRootNode.getNode(PINNED_NEWS_NODES_FOLDER);
        }
        return pinnedRootNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shareNews(SharedNews sharedNews, List<Space> spaces) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        try {
            Identity poster = this.identityManager.getOrCreateIdentity("organization", sharedNews.getPoster(), false);
            for (Space space : spaces) {
                Node newsNode = session.getNodeByUUID(sharedNews.getNewsId());
                if (newsNode != null) {
                    if (newsNode.canAddMixin("exo:privilegeable")) {
                        newsNode.addMixin("exo:privilegeable");
                    }
                    ((ExtendedNode)newsNode).setPermission("*:" + space.getGroupId(), PermissionType.ALL);
                    newsNode.save();
                }
                Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
                ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
                activity.setTitle(sharedNews.getDescription());
                activity.setBody("");
                activity.setType("shared_news");
                activity.setUserId(poster.getId());
                HashMap<String, String> templateParams = new HashMap<String, String>();
                templateParams.put("newsId", sharedNews.getNewsId());
                templateParams.put("sharedActivityId", sharedNews.getActivityId());
                activity.setTemplateParams(templateParams);
                this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<News> getNewsDrafts(String spaceId, String author) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        ArrayList<News> newsDrafts = new ArrayList<News>();
        try {
            StringBuilder sqlQuery = new StringBuilder("SELECT * FROM exo:news WHERE publication:currentState = 'draft' AND exo:author = '").append(author).append("'").append("AND exo:spaceId='").append(spaceId).append("'");
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query query = qm.createQuery(sqlQuery.toString(), "sql");
            NodeIterator it = query.execute().getNodes();
            while (it.hasNext()) {
                Node iterNode = it.nextNode();
                newsDrafts.add(this.convertNodeToNews(iterNode));
            }
            ArrayList<News> arrayList = newsDrafts;
            return arrayList;
        }
        catch (ItemNotFoundException e) {
            List<News> list = null;
            return list;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteNews(String newsId) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        try {
            Node node = session.getNodeByUUID(newsId);
            node.remove();
            session.save();
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    void postNewsActivity(News news) {
        Identity poster = this.identityManager.getOrCreateIdentity("organization", news.getAuthor(), false);
        Space space = this.spaceService.getSpaceById(news.getSpaceId());
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("");
        activity.setBody("");
        activity.setType("news");
        activity.setUserId(poster.getId());
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put("newsId", news.getId());
        activity.setTemplateParams(templateParams);
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
    }

    private String getNodeRelativePath(Calendar now) {
        return now.get(1) + "/" + (now.get(2) + 1) + "/" + now.get(5);
    }

    private void attachIllustration(Node newsNode, String uploadId) throws Exception {
        UploadResource uploadedResource = this.uploadService.getUploadResource(uploadId);
        if (uploadedResource == null) {
            throw new Exception("Cannot attach uploaded file " + uploadId + ", it may not exist");
        }
        boolean illustrationExists = newsNode.hasNode("illustration");
        Node illustrationNode = illustrationExists ? newsNode.getNode("illustration") : newsNode.addNode("illustration", "nt:file");
        illustrationNode.setProperty("exo:title", uploadedResource.getFileName());
        Node resourceNode = illustrationExists ? illustrationNode.getNode("jcr:content") : illustrationNode.addNode("jcr:content", "nt:resource");
        resourceNode.setProperty("jcr:mimeType", uploadedResource.getMimeType());
        resourceNode.setProperty("jcr:lastModified", Calendar.getInstance());
        String fileDiskLocation = uploadedResource.getStoreLocation();
        try (FileInputStream inputStream = new FileInputStream(fileDiskLocation);){
            resourceNode.setProperty("jcr:data", (InputStream)inputStream);
            newsNode.save();
        }
        this.uploadService.removeUploadResource(uploadId);
    }

    private void removeIllustration(Node newsNode) throws Exception {
        if (newsNode.hasNode("illustration")) {
            newsNode.getNode("illustration").remove();
            newsNode.save();
        }
    }

    private Node getSpaceNewsRootNode(String spaceId, Session session) throws RepositoryException {
        Node spaceNewsRootNode;
        Space space = this.spaceService.getSpaceById(spaceId);
        String groupPath = this.nodeHierarchyCreator.getJcrPath("groupsPath");
        String spaceParentPath = groupPath + space.getGroupId();
        Node spaceRootNode = (Node)session.getItem(spaceParentPath);
        if (!spaceRootNode.hasNode(NEWS_NODES_FOLDER)) {
            spaceNewsRootNode = spaceRootNode.addNode(NEWS_NODES_FOLDER, "nt:unstructured");
            if (spaceNewsRootNode.canAddMixin("exo:privilegeable")) {
                spaceNewsRootNode.addMixin("exo:privilegeable");
            }
            ((ExtendedNode)spaceNewsRootNode).setPermission("*:/platform/administrators", PermissionType.ALL);
            ((ExtendedNode)spaceNewsRootNode).setPermission("*:" + space.getGroupId(), PermissionType.ALL);
            spaceRootNode.save();
        } else {
            spaceNewsRootNode = spaceRootNode.getNode(NEWS_NODES_FOLDER);
        }
        return spaceNewsRootNode;
    }

    private News convertNodeToNews(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        News news = new News();
        news.setId(node.getUUID());
        news.setTitle(node.getProperty("exo:title").getString());
        news.setSummary(node.getProperty("exo:summary").getString());
        news.setBody(node.getProperty("exo:body").getString());
        news.setAuthor(node.getProperty("exo:author").getString());
        news.setCreationDate(node.getProperty("exo:dateCreated").getDate().getTime());
        news.setUpdater(node.getProperty("exo:lastModifier").getString());
        news.setUpdateDate(node.getProperty("exo:dateModified").getDate().getTime());
        news.setPinned(node.getProperty("exo:pinned").getBoolean());
        news.setSpaceId(node.getProperty("exo:spaceId").getString());
        if (node.hasNode("illustration")) {
            Node illustrationContentNode = node.getNode("illustration").getNode("jcr:content");
            byte[] bytes = IOUtils.toByteArray((InputStream)illustrationContentNode.getProperty("jcr:data").getStream());
            news.setIllustration(bytes);
            news.setIllustrationUpdateDate(illustrationContentNode.getProperty("jcr:lastModified").getDate().getTime());
        }
        return news;
    }

    @Override
    public void unpinNews(String newsId) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        News news = this.getNews(newsId);
        if (news == null) {
            throw new Exception("Unable to find a news with an id equal to: " + newsId);
        }
        Node newsNode = session.getNodeByUUID(newsId);
        if (newsNode == null) {
            throw new Exception("Unable to find a node with an UUID equal to: " + newsId);
        }
        newsNode.setProperty("exo:pinned", false);
        newsNode.save();
        Node pinnedRootNode = this.getPinnedNewsFolder();
        if (pinnedRootNode == null) {
            throw new Exception("Unable to find the root pinned folder: /Application Data/News/pinned");
        }
        Calendar newsCreationCalendar = Calendar.getInstance();
        newsCreationCalendar.setTime(news.getCreationDate());
        Node newsFolderNode = this.dataDistributionType.getOrCreateDataNode(pinnedRootNode, this.getNodeRelativePath(newsCreationCalendar));
        if (newsFolderNode == null) {
            throw new Exception("Unable to find the parent node of the current pinned node");
        }
        Node pinnedNode = newsFolderNode.getNode(newsNode.getName());
        if (pinnedNode == null) {
            throw new Exception("Unable to find the current pinned node");
        }
        pinnedNode.remove();
        newsFolderNode.save();
    }

    @Override
    public News createNewsDraft(News news) throws Exception {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repositoryService.getCurrentRepository());
        Node spaceNewsRootNode = this.getSpaceNewsRootNode(news.getSpaceId(), session);
        Calendar creationCalendar = Calendar.getInstance();
        if (news.getCreationDate() != null) {
            creationCalendar.setTime(news.getCreationDate());
        } else {
            news.setCreationDate(creationCalendar.getTime());
        }
        String newsNodeName = !news.getTitle().equals("") ? news.getTitle() : "Untitled";
        Node newsFolderNode = this.dataDistributionType.getOrCreateDataNode(spaceNewsRootNode, this.getNodeRelativePath(creationCalendar));
        Node newsDraftNode = newsFolderNode.addNode(Utils.cleanName((String)newsNodeName).trim(), "exo:news");
        newsDraftNode.addMixin("exo:datetime");
        newsDraftNode.setProperty("exo:title", news.getTitle());
        newsDraftNode.setProperty("exo:summary", news.getSummary());
        newsDraftNode.setProperty("exo:body", news.getBody());
        newsDraftNode.setProperty("exo:author", news.getAuthor());
        newsDraftNode.setProperty("exo:dateCreated", creationCalendar);
        Calendar updateCalendar = Calendar.getInstance();
        if (news.getUpdateDate() != null) {
            updateCalendar.setTime(news.getUpdateDate());
        } else {
            news.setUpdateDate(updateCalendar.getTime());
        }
        newsDraftNode.setProperty("exo:dateModified", updateCalendar);
        newsDraftNode.setProperty("exo:pinned", false);
        newsDraftNode.setProperty("exo:spaceId", news.getSpaceId());
        LifecyclesConfig.Lifecycle lifecycle = this.publicationManager.getLifecycle("newsLifecycle");
        String lifecycleName = ((WebpagePublicationPlugin)this.wCMPublicationService.getWebpagePublicationPlugins().get(lifecycle.getPublicationPlugin())).getLifecycleName();
        if (newsDraftNode.canAddMixin("publication:authoring")) {
            newsDraftNode.addMixin("publication:authoring");
            newsDraftNode.setProperty("publication:lastUser", news.getAuthor());
            newsDraftNode.setProperty("publication:lifecycle", lifecycle.getName());
        }
        this.publicationService.enrollNodeInLifecycle(newsDraftNode, lifecycleName);
        this.publicationService.changeState(newsDraftNode, "draft", new HashMap());
        newsDraftNode.setProperty("exo:body", this.imageProcessor.processImages(news.getBody(), newsDraftNode, "images"));
        spaceNewsRootNode.save();
        if (StringUtils.isNotEmpty((CharSequence)news.getUploadId())) {
            this.attachIllustration(newsDraftNode, news.getUploadId());
        }
        news.setId(newsDraftNode.getUUID());
        return news;
    }
}

