/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.queryBuilder;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.news.filter.NewsFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;

public class NewsQueryBuilder {
    private static final Log LOG = ExoLogger.getLogger(NewsQueryBuilder.class);
    private static final String PUBLISHER_MEMBERSHIP_NAME = "publisher";
    private static final String PLATFORM_WEB_CONTRIBUTORS_GROUP = "/platform/web-contributors";

    public StringBuilder buildQuery(NewsFilter filter) throws Exception {
        StringBuilder sqlQuery = new StringBuilder("SELECT * FROM exo:news WHERE ");
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        boolean isPublisher = currentIdentity.isMemberOf(PLATFORM_WEB_CONTRIBUTORS_GROUP, PUBLISHER_MEMBERSHIP_NAME);
        String username = currentIdentity.getUserId();
        try {
            if (filter != null) {
                List<String> spaces;
                if (filter.isArchivedNews()) {
                    if (isPublisher) {
                        sqlQuery.append("exo:archived = 'true' AND ");
                    } else {
                        sqlQuery.append("( exo:archived = 'true' AND exo:author = '").append(username).append("') AND ");
                    }
                } else if (!isPublisher) {
                    sqlQuery.append("( exo:archived IS NULL OR exo:archived = 'false' OR ( exo:archived = 'true' AND  exo:author = '").append(username).append("')) AND ");
                }
                if (filter.getSearchText() != null && !filter.getSearchText().equals("")) {
                    sqlQuery.append("CONTAINS(.,'").append(filter.getSearchText()).append("') AND ");
                }
                if (filter.isPinnedNews()) {
                    sqlQuery.append("exo:pinned = 'true' AND ");
                }
                if ((spaces = filter.getSpaces()) != null && spaces.size() != 0) {
                    sqlQuery.append("( ");
                    for (int i = 0; i < spaces.size() - 1; ++i) {
                        sqlQuery.append("exo:spaceId = '").append(spaces.get(i)).append("' OR ");
                    }
                    sqlQuery.append("exo:spaceId = '").append(spaces.get(spaces.size() - 1)).append("') AND ");
                }
                if (StringUtils.isNotEmpty((CharSequence)filter.getAuthor())) {
                    sqlQuery.append("exo:author = '").append(filter.getAuthor()).append("' AND ");
                }
            } else {
                throw new Exception("Unable to build query, filter is null");
            }
            sqlQuery.append("publication:currentState = 'published' AND jcr:path LIKE '/Groups/spaces/%' ORDER BY ").append(filter.getOrder()).append(" DESC");
        }
        catch (Exception e) {
            LOG.error((Object)"Error while creating query", (Throwable)e);
        }
        return sqlQuery;
    }
}

