/*
 * Copyright (C) 2003-2021 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.news.listener;

import javax.jcr.Node;
import javax.jcr.Session;

import org.apache.commons.lang3.StringUtils;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.news.NewsService;
import org.exoplatform.news.model.News;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.authoring.AuthoringPublicationConstant;
import org.exoplatform.services.wcm.publication.PublicationDefaultStates;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.StageAndVersionPublicationConstant;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class NewsPublicationListener extends Listener<CmsService, Node> {

  private NewsService            newsService;

  private SessionProviderService sessionProviderService;

  public NewsPublicationListener() {
    newsService = WCMCoreUtils.getService(NewsService.class);
    sessionProviderService = WCMCoreUtils.getService(SessionProviderService.class);
  }

  public void onEvent(Event<CmsService, Node> event) throws Exception {
    if (AuthoringPublicationConstant.POST_CHANGE_STATE_EVENT.equals(event.getEventName())) {
      ExoContainer container = PortalContainer.getInstance();
      RepositoryService repositoryService = container.getComponentInstanceOfType(RepositoryService.class);
      SessionProvider systemProvider = sessionProviderService.getSystemSessionProvider(null);
      Session session = systemProvider.getSession(
                                                  repositoryService.getCurrentRepository()
                                                                   .getConfiguration()
                                                                   .getDefaultWorkspaceName(),
                                                  repositoryService.getCurrentRepository());
      Node targetNode = event.getData();
      if (targetNode.isNodeType("exo:news") && targetNode.getProperty(StageAndVersionPublicationConstant.CURRENT_STATE)
                                                         .getString()
                                                         .equals(PublicationDefaultStates.PUBLISHED)) {
        News news = newsService.convertNodeToNews(targetNode, false);
        if (StringUtils.isEmpty(news.getActivities())) {
          try {
            newsService.createNews(news, session);
          } finally {
            if (session != null) {
              session.logout();
            }
          }
        }
      }
    }
  }
}
