/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.notification.utils;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.news.model.News;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;

public class NotificationUtils {
    public static String getUserFullName(String userName) throws Exception {
        OrganizationService organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
        UserHandler userHandler = organizationService.getUserHandler();
        User user = userHandler.findUserByName(userName);
        if (user == null) {
            throw new Exception("An error occured when trying to retreive a user with username " + userName);
        }
        return user.getFullName();
    }

    public static String getNewsIllustration(News news, Session session) throws Exception {
        Node newsNode;
        StringBuffer illustrationURL = new StringBuffer();
        Object currentDomain = CommonsUtils.getCurrentDomain();
        if (!((String)currentDomain).endsWith("/")) {
            currentDomain = (String)currentDomain + "/";
        }
        if ((newsNode = session.getNodeByUUID(news.getId())) == null) {
            throw new ItemNotFoundException("Cannot find a node with UUID equals to " + news.getId() + ", it may not exist");
        }
        if (newsNode.hasNode("illustration")) {
            illustrationURL.append((String)currentDomain).append("portal/rest/v1/news/").append(news.getId()).append("/illustration");
        } else {
            illustrationURL.append((String)currentDomain).append("news/images/newsImageDefault.png");
        }
        return illustrationURL.toString();
    }

    public static String getNotificationActivityLink(Space space, String activityId, boolean isMember) {
        String activityLink = "";
        activityLink = isMember ? NotificationUtils.getActivityPermalink(activityId) : NotificationUtils.getNotificationActivityLinkForNotSpaceMembers(space);
        String baseUrl = PropertyManager.getProperty((String)"gatein.email.domain.url");
        return baseUrl == null ? activityLink : baseUrl.concat(activityLink);
    }

    private static String getActivityPermalink(String activityId) {
        return LinkProvider.getSingleActivityUrl((String)activityId);
    }

    public static String getNotificationActivityLinkForNotSpaceMembers(Space space) {
        return "/".concat(PortalContainer.getCurrentPortalContainerName()).concat("/g/:spaces:").concat(space.getGroupId().replaceFirst("/spaces/", "")).concat("/").concat(space.getPrettyName());
    }
}

