/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.listener;

import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.news.model.News;
import org.exoplatform.news.service.NewsService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.social.metadata.favorite.model.Favorite;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.tag.TagService;
import org.exoplatform.social.metadata.tag.model.TagObject;

public class NewsMetadataListener
extends Listener<Long, MetadataItem> {
    public static final String NEWS_METADATA_OBJECT_TYPE = "news";
    private final IndexingService indexingService;
    private final NewsService newsService;
    private final FavoriteService favoriteService;
    private final IdentityManager identityManager;
    private final ActivityManager activityManager;
    private TagService tagService;
    private static final String METADATA_CREATED = "social.metadataItem.created";
    private static final String METADATA_DELETED = "social.metadataItem.deleted";
    private static final String METADATA_TAG = "tags";
    private static final String METADATA_FAVORITE = "favorites";

    public NewsMetadataListener(IndexingService indexingService, NewsService newsService, FavoriteService favoriteService, IdentityManager identityManager, ActivityManager activityManager, TagService tagService) {
        this.indexingService = indexingService;
        this.newsService = newsService;
        this.favoriteService = favoriteService;
        this.identityManager = identityManager;
        this.activityManager = activityManager;
        this.tagService = tagService;
    }

    public void onEvent(Event<Long, MetadataItem> event) throws Exception {
        ExoSocialActivity activity;
        ConversationState conversationstate = ConversationState.getCurrent();
        Identity currentIdentity = conversationstate == null || conversationstate.getIdentity() == null ? null : conversationstate.getIdentity();
        MetadataItem metadataItem = (MetadataItem)event.getData();
        String objectType = ((MetadataItem)event.getData()).getObjectType();
        String objectId = metadataItem.getObjectId();
        if (StringUtils.equals((CharSequence)objectType, (CharSequence)NEWS_METADATA_OBJECT_TYPE)) {
            this.indexingService.reindex(NEWS_METADATA_OBJECT_TYPE, objectId);
        } else if (StringUtils.equals((CharSequence)objectType, (CharSequence)"activity") && (activity = this.activityManager.getActivity(objectId)).getType().equals(NEWS_METADATA_OBJECT_TYPE) && currentIdentity != null) {
            News news = this.newsService.getNewsByActivityId(objectId, currentIdentity);
            org.exoplatform.social.core.identity.model.Identity userIdentity = this.identityManager.getOrCreateIdentity("organization", currentIdentity.getUserId());
            Favorite favorite = new Favorite(NEWS_METADATA_OBJECT_TYPE, news.getId(), "", Long.parseLong(userIdentity.getId()));
            if (event.getEventName().equals(METADATA_CREATED)) {
                if (!metadataItem.getObjectType().equals(NEWS_METADATA_OBJECT_TYPE) && metadataItem.getMetadataTypeName().equals(METADATA_TAG)) {
                    this.updateActivityTags(activity, news);
                } else {
                    this.favoriteService.createFavorite(favorite);
                }
            } else if (event.getEventName().equals(METADATA_DELETED) && metadataItem.getMetadataTypeName().equals(METADATA_FAVORITE)) {
                this.favoriteService.deleteFavorite(favorite);
            }
            this.indexingService.reindex(NEWS_METADATA_OBJECT_TYPE, news.getId());
        }
    }

    private void updateActivityTags(ExoSocialActivity activity, News news) {
        String objectType = NEWS_METADATA_OBJECT_TYPE;
        long creatorId = this.getPosterId(activity);
        org.exoplatform.social.core.identity.model.Identity audienceIdentity = this.activityManager.getActivityStreamOwnerIdentity(activity.getId());
        long audienceId = Long.parseLong(audienceIdentity.getId());
        String content = this.getActivityBody(activity);
        Set tagNames = this.tagService.detectTagNames(content);
        this.tagService.saveTags(new TagObject(objectType, news.getId(), activity.getParentId()), tagNames, audienceId, creatorId);
    }

    private long getPosterId(ExoSocialActivity activity) {
        String userId = activity.getUserId();
        if (StringUtils.isBlank((CharSequence)userId)) {
            userId = activity.getPosterId();
        }
        return StringUtils.isBlank((CharSequence)userId) ? 0L : Long.parseLong(userId);
    }

    private String getActivityBody(ExoSocialActivity activity) {
        String body = MapUtils.getString((Map)activity.getTemplateParams(), (Object)"comment");
        if (StringUtils.isNotBlank((CharSequence)body)) {
            return body;
        }
        if (StringUtils.isNotBlank((CharSequence)activity.getTitle())) {
            return activity.getTitle();
        }
        return activity.getBody();
    }
}

