/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.listener;

import java.util.Map;
import org.exoplatform.news.listener.NewsActivityListener;
import org.exoplatform.news.model.News;
import org.exoplatform.news.service.NewsService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class NewsActivityListenerTest {
    @Mock
    private ActivityManager activityManager;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private SpaceService spaceService;
    @Mock
    private NewsService newsService;

    @Test
    public void testNotShareWhenActivityNotFound() {
        NewsActivityListener newsActivityListener = new NewsActivityListener(this.activityManager, this.identityManager, this.spaceService, this.newsService);
        ActivityLifeCycleEvent event = (ActivityLifeCycleEvent)Mockito.mock(ActivityLifeCycleEvent.class);
        newsActivityListener.shareActivity(event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.newsService});
    }

    @Test
    public void testNotShareWhenActivityNotHavingTemplates() {
        NewsActivityListener newsActivityListener = new NewsActivityListener(this.activityManager, this.identityManager, this.spaceService, this.newsService);
        ActivityLifeCycleEvent event = (ActivityLifeCycleEvent)Mockito.mock(ActivityLifeCycleEvent.class);
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)event.getActivity()).thenReturn((Object)activity);
        newsActivityListener.shareActivity(event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.newsService});
    }

    @Test
    public void testNotShareWhenActivityNotSharedOne() {
        NewsActivityListener newsActivityListener = new NewsActivityListener(this.activityManager, this.identityManager, this.spaceService, this.newsService);
        ActivityLifeCycleEvent event = (ActivityLifeCycleEvent)Mockito.mock(ActivityLifeCycleEvent.class);
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)event.getActivity()).thenReturn((Object)activity);
        Map templateParams = (Map)Mockito.mock(Map.class);
        Mockito.when((Object)activity.getTemplateParams()).thenReturn((Object)templateParams);
        newsActivityListener.shareActivity(event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.newsService});
    }

    @Test
    public void testNotShareWhenSharedActivityNotFound() {
        NewsActivityListener newsActivityListener = new NewsActivityListener(this.activityManager, this.identityManager, this.spaceService, this.newsService);
        ActivityLifeCycleEvent event = (ActivityLifeCycleEvent)Mockito.mock(ActivityLifeCycleEvent.class);
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)event.getActivity()).thenReturn((Object)activity);
        Map templateParams = (Map)Mockito.mock(Map.class);
        Mockito.when((Object)activity.getTemplateParams()).thenReturn((Object)templateParams);
        Mockito.when((Object)templateParams.containsKey("originalActivityId")).thenReturn((Object)true);
        String originalActivityId = "originalActivityId";
        Mockito.when((Object)((String)templateParams.get("originalActivityId"))).thenReturn((Object)originalActivityId);
        newsActivityListener.shareActivity(event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.newsService});
    }

    @Test
    public void testNotShareWhenSharedActivityNotNewsActivity() {
        NewsActivityListener newsActivityListener = new NewsActivityListener(this.activityManager, this.identityManager, this.spaceService, this.newsService);
        ActivityLifeCycleEvent event = (ActivityLifeCycleEvent)Mockito.mock(ActivityLifeCycleEvent.class);
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)event.getActivity()).thenReturn((Object)activity);
        Map templateParams = (Map)Mockito.mock(Map.class);
        Mockito.when((Object)activity.getTemplateParams()).thenReturn((Object)templateParams);
        Mockito.when((Object)templateParams.containsKey("originalActivityId")).thenReturn((Object)true);
        String originalActivityId = "originalActivityId";
        Mockito.when((Object)((String)templateParams.get("originalActivityId"))).thenReturn((Object)originalActivityId);
        ExoSocialActivity sharedActivity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)this.activityManager.getActivity(originalActivityId)).thenReturn((Object)sharedActivity);
        newsActivityListener.shareActivity(event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.newsService});
    }

    @Test
    public void testNotShareWhenSharedActivityWhenNewsNotFound() throws Exception {
        NewsActivityListener newsActivityListener = new NewsActivityListener(this.activityManager, this.identityManager, this.spaceService, this.newsService);
        ActivityLifeCycleEvent event = (ActivityLifeCycleEvent)Mockito.mock(ActivityLifeCycleEvent.class);
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)event.getActivity()).thenReturn((Object)activity);
        Map templateParams = (Map)Mockito.mock(Map.class);
        Mockito.when((Object)activity.getTemplateParams()).thenReturn((Object)templateParams);
        Mockito.when((Object)templateParams.containsKey("originalActivityId")).thenReturn((Object)true);
        String originalActivityId = "originalActivityId";
        Mockito.when((Object)((String)templateParams.get("originalActivityId"))).thenReturn((Object)originalActivityId);
        ExoSocialActivity sharedActivity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)this.activityManager.getActivity(originalActivityId)).thenReturn((Object)sharedActivity);
        Map sharedTemplateParams = (Map)Mockito.mock(Map.class);
        Mockito.when((Object)sharedActivity.getTemplateParams()).thenReturn((Object)sharedTemplateParams);
        Mockito.when((Object)sharedTemplateParams.containsKey("newsId")).thenReturn((Object)true);
        String newsId = "newsId";
        Mockito.when((Object)((String)sharedTemplateParams.get("newsId"))).thenReturn((Object)newsId);
        Identity currentIdentity = new Identity("john");
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        newsActivityListener.shareActivity(event);
        ((NewsService)Mockito.verify((Object)this.newsService, (VerificationMode)Mockito.times((int)1))).getNewsById(newsId, currentIdentity, false);
        ((NewsService)Mockito.verify((Object)this.newsService, (VerificationMode)Mockito.never())).shareNews((News)ArgumentMatchers.nullable(News.class), (Space)ArgumentMatchers.nullable(Space.class), (org.exoplatform.social.core.identity.model.Identity)ArgumentMatchers.nullable(org.exoplatform.social.core.identity.model.Identity.class), (String)ArgumentMatchers.nullable(String.class));
    }

    @Test
    public void testShareWhenNewsFound() throws Exception {
        NewsActivityListener newsActivityListener = new NewsActivityListener(this.activityManager, this.identityManager, this.spaceService, this.newsService);
        ActivityLifeCycleEvent event = (ActivityLifeCycleEvent)Mockito.mock(ActivityLifeCycleEvent.class);
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)event.getActivity()).thenReturn((Object)activity);
        Map templateParams = (Map)Mockito.mock(Map.class);
        Mockito.when((Object)activity.getTemplateParams()).thenReturn((Object)templateParams);
        Mockito.when((Object)templateParams.containsKey("originalActivityId")).thenReturn((Object)true);
        String originalActivityId = "originalActivityId";
        Mockito.when((Object)((String)templateParams.get("originalActivityId"))).thenReturn((Object)originalActivityId);
        ExoSocialActivity sharedActivity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)this.activityManager.getActivity(originalActivityId)).thenReturn((Object)sharedActivity);
        ActivityStream activityStream = (ActivityStream)Mockito.mock(ActivityStream.class);
        Mockito.when((Object)activity.getActivityStream()).thenReturn((Object)activityStream);
        String spacePrettyName = "space1";
        Mockito.when((Object)activityStream.getPrettyId()).thenReturn((Object)spacePrettyName);
        Map sharedTemplateParams = (Map)Mockito.mock(Map.class);
        Mockito.when((Object)sharedActivity.getTemplateParams()).thenReturn((Object)sharedTemplateParams);
        Mockito.when((Object)sharedTemplateParams.containsKey("newsId")).thenReturn((Object)true);
        String newsId = "newsId";
        Mockito.when((Object)((String)sharedTemplateParams.get("newsId"))).thenReturn((Object)newsId);
        Identity currentIdentity = new Identity("john");
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        News news = new News();
        Mockito.when((Object)this.newsService.getNewsById(newsId, currentIdentity, false)).thenReturn((Object)news);
        newsActivityListener.shareActivity(event);
        ((NewsService)Mockito.verify((Object)this.newsService, (VerificationMode)Mockito.times((int)1))).getNewsById(newsId, currentIdentity, false);
        ((NewsService)Mockito.verify((Object)this.newsService, (VerificationMode)Mockito.times((int)1))).shareNews((News)ArgumentMatchers.eq((Object)news), (Space)ArgumentMatchers.nullable(Space.class), (org.exoplatform.social.core.identity.model.Identity)ArgumentMatchers.nullable(org.exoplatform.social.core.identity.model.Identity.class), (String)ArgumentMatchers.nullable(String.class));
    }
}

