/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.notification.plugin;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.NotificationCompletionService;
import org.exoplatform.commons.api.notification.service.storage.NotificationService;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.news.notification.plugin.MentionInNewsNotificationPlugin;
import org.exoplatform.news.notification.plugin.PostNewsNotificationPlugin;
import org.exoplatform.news.notification.utils.NotificationConstants;
import org.exoplatform.services.idgenerator.IDGeneratorService;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.notification.Utils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MentionInNewsNotificationPluginTest {
    private static MockedStatic<CommonsUtils> COMMONS_UTILS;
    private static MockedStatic<WCMCoreUtils> WCM_CORE_UTILS;
    private static MockedStatic<Utils> SOCIAL_UTILS;
    private static MockedStatic<IdGenerator> ID_GENERATOR;
    private static MockedStatic<PluginKey> PLUGIN_KEY;
    private static MockedStatic<ExoContainerContext> EXO_CONTAINER_CONTEXT;
    @Mock
    private UserHandler userhandler;
    @Mock
    private SpaceService spaceService;
    @Mock
    private InitParams initParams;
    @Mock
    private OrganizationService orgService;

    @BeforeClass
    public static void beforeRunBare() throws Exception {
        COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
        WCM_CORE_UTILS = Mockito.mockStatic(WCMCoreUtils.class);
        ID_GENERATOR = Mockito.mockStatic(IdGenerator.class);
        PLUGIN_KEY = Mockito.mockStatic(PluginKey.class);
        SOCIAL_UTILS = Mockito.mockStatic(Utils.class);
        EXO_CONTAINER_CONTEXT = Mockito.mockStatic(ExoContainerContext.class);
    }

    @AfterClass
    public static void afterRunBare() throws Exception {
        COMMONS_UTILS.close();
        WCM_CORE_UTILS.close();
        SOCIAL_UTILS.close();
        ID_GENERATOR.close();
        PLUGIN_KEY.close();
        EXO_CONTAINER_CONTEXT.close();
    }

    @Test
    public void shouldMakeNotificationForMentionInNewsContext() throws Exception {
        Mockito.when((Object)this.orgService.getUserHandler()).thenReturn((Object)this.userhandler);
        MentionInNewsNotificationPlugin newsPlugin = new MentionInNewsNotificationPlugin(this.initParams);
        HashSet<String> mentionedIds = new HashSet<String>(Collections.singleton("0"));
        COMMONS_UTILS.when(() -> CommonsUtils.getService(NotificationService.class)).thenReturn(null);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(NotificationCompletionService.class)).thenReturn(null);
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(PostNewsNotificationPlugin.CONTENT_TITLE, (Object)"title").append(PostNewsNotificationPlugin.CONTENT_AUTHOR, (Object)"root").append(PostNewsNotificationPlugin.CURRENT_USER, (Object)"root").append(PostNewsNotificationPlugin.CONTENT_SPACE_ID, (Object)"1").append(PostNewsNotificationPlugin.CONTENT_SPACE, (Object)"space1").append(MentionInNewsNotificationPlugin.MENTIONED_IDS, mentionedIds).append(PostNewsNotificationPlugin.ILLUSTRATION_URL, (Object)"http://localhost:8080/rest/v1/news/id123/illustration").append(PostNewsNotificationPlugin.AUTHOR_AVATAR_URL, (Object)"http://localhost:8080/portal/rest/v1/social/users/default-image/avatar").append(PostNewsNotificationPlugin.ACTIVITY_LINK, (Object)"http://localhost:8080/portal/intranet/activity?id=38").append(MentionInNewsNotificationPlugin.CONTEXT, (Object)NotificationConstants.NOTIFICATION_CONTEXT.MENTION_IN_NEWS);
        User contentAuthorUser = (User)Mockito.mock(User.class);
        Mockito.when((Object)this.userhandler.findUserByName("root")).thenReturn((Object)contentAuthorUser);
        User currentUser = (User)Mockito.mock(User.class);
        Mockito.when((Object)this.userhandler.findUserByName("root")).thenReturn((Object)currentUser);
        Mockito.when((Object)currentUser.getFullName()).thenReturn((Object)"root root");
        User user1 = (User)Mockito.mock(User.class);
        User user2 = (User)Mockito.mock(User.class);
        User[] receivers = new User[]{user1, user2};
        ID_GENERATOR.when(() -> IdGenerator.generate()).thenReturn((Object)"123456");
        MentionInNewsNotificationPluginTest.mockIdGeneratorService();
        COMMONS_UTILS.when(() -> CommonsUtils.getService(OrganizationService.class)).thenReturn((Object)this.orgService);
        Space space = new Space();
        space.setId("1");
        space.setGroupId("space1");
        NotificationInfo notificationInfo = newsPlugin.makeNotification(ctx);
        Assert.assertEquals((Object)"root", (Object)notificationInfo.getFrom());
        Assert.assertEquals((Object)"", (Object)notificationInfo.getTitle());
        Assert.assertEquals((Object)"title", (Object)notificationInfo.getValueOwnerParameter("CONTENT_TITLE"));
        Assert.assertEquals((Object)"root", (Object)notificationInfo.getValueOwnerParameter("CONTENT_AUTHOR"));
        Assert.assertEquals((Object)"http://localhost:8080/rest/v1/news/id123/illustration", (Object)notificationInfo.getValueOwnerParameter("ILLUSTRATION_URL"));
        Assert.assertEquals((Object)"http://localhost:8080/portal/rest/v1/social/users/default-image/avatar", (Object)notificationInfo.getValueOwnerParameter("AUTHOR_AVATAR_URL"));
        Assert.assertEquals((Object)"space1", (Object)notificationInfo.getValueOwnerParameter("CONTENT_SPACE"));
        Assert.assertEquals((Object)"http://localhost:8080/portal/intranet/activity?id=38", (Object)notificationInfo.getValueOwnerParameter("ACTIVITY_LINK"));
    }

    public static void mockIdGeneratorService() {
        EXO_CONTAINER_CONTEXT.when(() -> ExoContainerContext.getService(IDGeneratorService.class)).thenReturn((Object)new IDGeneratorService(){

            public String generateStringID(Object o) {
                return "123456";
            }

            public long generateLongID(Object o) {
                return 123456L;
            }

            public Serializable generateID(Object o) {
                return Integer.valueOf(123456);
            }

            public int generatIntegerID(Object o) {
                return 123456;
            }
        });
    }
}

