/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.rest;

import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.LinkedList;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.news.rest.NewsTargetingEntity;
import org.exoplatform.news.rest.NewsTargetingRestResourcesV1;
import org.exoplatform.news.service.NewsTargetingService;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.metadata.model.Metadata;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class NewsTargetingRestResourcesV1Test {
    @Mock
    NewsTargetingService newsTargetingService;
    @Mock
    PortalContainer container;
    @Mock
    IdentityManager identityManager;

    @Before
    public void setup() {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
    }

    @Test
    public void shouldReturnOkWhenGetTargets() {
        NewsTargetingRestResourcesV1 newsTargetingRestResourcesV1 = new NewsTargetingRestResourcesV1(this.newsTargetingService, this.container);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)"john");
        Response response = newsTargetingRestResourcesV1.getAllTargets(request);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldReturnOkWhenGetAllowedTargets() {
        NewsTargetingRestResourcesV1 newsTargetingRestResourcesV1 = new NewsTargetingRestResourcesV1(this.newsTargetingService, this.container);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)"john");
        Response response = newsTargetingRestResourcesV1.getAllowedTargets(request);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)newsTargetingRestResourcesV1.getAllowedTargets(request)).thenThrow(RuntimeException.class);
        response = newsTargetingRestResourcesV1.getAllowedTargets(request);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldReturnOkWhenDeleteNewsTarget() {
        NewsTargetingRestResourcesV1 newsTargetingRestResourcesV1 = new NewsTargetingRestResourcesV1(this.newsTargetingService, this.container);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)"john");
        Identity currentIdentity = new Identity("john");
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        LinkedList<NewsTargetingEntity> targets = new LinkedList<NewsTargetingEntity>();
        NewsTargetingEntity newsTargetingEntity = new NewsTargetingEntity();
        newsTargetingEntity.setName("test1");
        targets.add(newsTargetingEntity);
        Mockito.lenient().when((Object)this.newsTargetingService.getAllTargets()).thenReturn(targets);
        Response response = newsTargetingRestResourcesV1.deleteTarget(request, ((NewsTargetingEntity)targets.get(0)).getName(), 0L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)newsTargetingRestResourcesV1.deleteTarget(request, ((NewsTargetingEntity)targets.get(0)).getName(), 0L)).thenThrow(RuntimeException.class);
        response = newsTargetingRestResourcesV1.deleteTarget(request, ((NewsTargetingEntity)targets.get(0)).getName(), 0L);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldReturnOkWhenCreateTargets() throws IllegalAccessException {
        NewsTargetingRestResourcesV1 newsTargetingRestResourcesV1 = new NewsTargetingRestResourcesV1(this.newsTargetingService, this.container);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)"john");
        Identity currentIdentity = new Identity("john");
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        Metadata sliderNews = new Metadata();
        sliderNews.setName("sliderNews");
        sliderNews.setCreatedDate(100L);
        HashMap<String, String> sliderNewsProperties = new HashMap<String, String>();
        sliderNewsProperties.put("label", "slider news");
        sliderNewsProperties.put("permissions", "space:1");
        sliderNews.setProperties(sliderNewsProperties);
        sliderNews.setId(1L);
        NewsTargetingEntity newsTargetingEntity = new NewsTargetingEntity();
        newsTargetingEntity.setName(sliderNews.getName());
        newsTargetingEntity.setProperties(sliderNewsProperties);
        Mockito.lenient().when((Object)this.newsTargetingService.createNewsTarget(newsTargetingEntity, currentIdentity)).thenReturn((Object)sliderNews);
        Response response = newsTargetingRestResourcesV1.createNewsTarget(request, newsTargetingEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)newsTargetingRestResourcesV1.createNewsTarget(request, newsTargetingEntity)).thenThrow(RuntimeException.class);
        response = newsTargetingRestResourcesV1.createNewsTarget(request, newsTargetingEntity);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldReturnOkWhenUpdateTargets() throws IllegalAccessException {
        NewsTargetingRestResourcesV1 newsTargetingRestResourcesV1 = new NewsTargetingRestResourcesV1(this.newsTargetingService, this.container);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)"john");
        Identity currentIdentity = new Identity("john");
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        Metadata sliderNews = new Metadata();
        sliderNews.setName("sliderNews");
        sliderNews.setCreatedDate(100L);
        HashMap<String, String> sliderNewsProperties = new HashMap<String, String>();
        sliderNewsProperties.put("label", "slider news");
        sliderNewsProperties.put("permissions", "space:1");
        sliderNews.setProperties(sliderNewsProperties);
        sliderNews.setId(1L);
        NewsTargetingEntity newsTargetingEntity = new NewsTargetingEntity();
        newsTargetingEntity.setName(sliderNews.getName());
        newsTargetingEntity.setProperties(sliderNewsProperties);
        String originalTargetName = "sliderNews";
        Mockito.lenient().when((Object)this.newsTargetingService.updateNewsTargets(originalTargetName, newsTargetingEntity, currentIdentity)).thenReturn((Object)sliderNews);
        Response response = newsTargetingRestResourcesV1.updateNewsTarget(newsTargetingEntity, originalTargetName);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)newsTargetingRestResourcesV1.updateNewsTarget(newsTargetingEntity, originalTargetName)).thenThrow(RuntimeException.class);
        response = newsTargetingRestResourcesV1.updateNewsTarget(newsTargetingEntity, originalTargetName);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }
}

