/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.queryBuilder;

import java.util.ArrayList;
import java.util.Arrays;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.news.filter.NewsFilter;
import org.exoplatform.news.queryBuilder.NewsQueryBuilder;
import org.exoplatform.news.utils.NewsUtils;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class NewsQueryBuilderTest {
    private static final MockedStatic<NewsUtils> NEWS_UTILS = Mockito.mockStatic(NewsUtils.class);
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);

    @AfterClass
    public static void afterRunBare() throws Exception {
        NEWS_UTILS.close();
        COMMONS_UTILS.close();
    }

    @Test
    public void shouldCreateQueryWithPinnedStateAndSearchTextAndAuthorAndOneSpaceAndCurrentUserIsNoPublisher() throws Exception {
        NewsQueryBuilder queryBuilder = new NewsQueryBuilder();
        NewsFilter filter = new NewsFilter();
        filter.setPublishedNews(true);
        filter.setSearchText("text");
        filter.setOrder("jcr:score");
        filter.setAuthor("john");
        filter.setTagNames(Arrays.asList("text", "tex"));
        ArrayList<String> spaces = new ArrayList<String>();
        spaces.add("1");
        filter.setSpaces(spaces);
        filter.setDraftNews(true);
        Space space1 = new Space();
        space1.setId("1");
        ArrayList<Space> allowedDraftNewsSpaces = new ArrayList<Space>();
        allowedDraftNewsSpaces.add(space1);
        NEWS_UTILS.when(() -> NewsUtils.getAllowedDraftNewsSpaces((org.exoplatform.services.security.Identity)((org.exoplatform.services.security.Identity)Mockito.any()))).thenReturn(allowedDraftNewsSpaces);
        Identity identity = new Identity("organization", "jean");
        identity.setRemoteId("jean");
        org.exoplatform.services.security.Identity currentIdentity = new org.exoplatform.services.security.Identity("john");
        MembershipEntry membershipentry = new MembershipEntry("/platform/web-contributors", "redactor");
        ArrayList<MembershipEntry> memberships = new ArrayList<MembershipEntry>();
        memberships.add(membershipentry);
        currentIdentity.setMemberships(memberships);
        ConversationState state = new ConversationState(currentIdentity);
        ConversationState.setCurrent((ConversationState)state);
        StringBuilder query = queryBuilder.buildQuery(filter);
        Assert.assertNotNull((Object)query);
        Assert.assertEquals((Object)"SELECT * FROM exo:news WHERE ( exo:archived IS NULL OR exo:archived = 'false' OR ( exo:archived = 'true' AND  exo:author = 'john')) AND (CONTAINS(.,'text~0.6') OR (exo:body LIKE '%text%'))AND exo:pinned = 'true' AND ( exo:spaceId = '1') AND publication:currentState = 'draft' AND (exo:author = 'john' OR (exo:spaceId = '1')) AND jcr:path LIKE '/Groups/spaces/%' ORDER BY jcr:score DESC", (Object)query.toString());
    }

    @Test
    public void shouldCreateQueryWithPinnedStateAndAuthorAndSearchTextAndSpacesListAndCurrentUserIsNoPublisher() throws Exception {
        NewsQueryBuilder queryBuilder = new NewsQueryBuilder();
        NewsFilter filter = new NewsFilter();
        filter.setPublishedNews(true);
        filter.setSearchText("text");
        filter.setOrder("jcr:score");
        filter.setAuthor("john");
        ArrayList<String> spaces = new ArrayList<String>();
        spaces.add("1");
        spaces.add("2");
        spaces.add("3");
        filter.setSpaces(spaces);
        org.exoplatform.services.security.Identity currentIdentity = new org.exoplatform.services.security.Identity("john");
        MembershipEntry membershipentry = new MembershipEntry("/platform/web-contributors", "redactor");
        ArrayList<MembershipEntry> memberships = new ArrayList<MembershipEntry>();
        memberships.add(membershipentry);
        currentIdentity.setMemberships(memberships);
        ConversationState state = new ConversationState(currentIdentity);
        ConversationState.setCurrent((ConversationState)state);
        StringBuilder query = queryBuilder.buildQuery(filter);
        Assert.assertNotNull((Object)query);
        Assert.assertEquals((Object)"SELECT * FROM exo:news WHERE ( exo:archived IS NULL OR exo:archived = 'false' OR ( exo:archived = 'true' AND  exo:author = 'john')) AND (CONTAINS(.,'text~0.6') OR (exo:body LIKE '%text%'))AND exo:pinned = 'true' AND ( exo:spaceId = '1' OR exo:spaceId = '2' OR exo:spaceId = '3') AND exo:author = 'john' AND (publication:currentState = 'published' OR (publication:currentState = 'draft' AND exo:activities <> '' )) AND jcr:path LIKE '/Groups/spaces/%' ORDER BY jcr:score DESC", (Object)query.toString());
    }

    @Test
    public void shouldCreateQueryWithNoPinnedStateAndNoArchivedStateAndNoAuthorAndCurrentUserIsPublisher() throws Exception {
        NewsQueryBuilder queryBuilder = new NewsQueryBuilder();
        NewsFilter filter = new NewsFilter();
        filter.setPublishedNews(false);
        filter.setArchivedNews(false);
        filter.setOrder("jcr:score");
        org.exoplatform.services.security.Identity currentIdentity = new org.exoplatform.services.security.Identity("john");
        MembershipEntry membershipentry = new MembershipEntry("/platform/web-contributors", "publisher");
        ArrayList<MembershipEntry> memberships = new ArrayList<MembershipEntry>();
        memberships.add(membershipentry);
        currentIdentity.setMemberships(memberships);
        ConversationState state = new ConversationState(currentIdentity);
        ConversationState.setCurrent((ConversationState)state);
        StringBuilder query = queryBuilder.buildQuery(filter);
        Assert.assertNotNull((Object)query);
        Assert.assertEquals((Object)"SELECT * FROM exo:news WHERE (publication:currentState = 'published' OR (publication:currentState = 'draft' AND exo:activities <> '' )) AND jcr:path LIKE '/Groups/spaces/%' ORDER BY jcr:score DESC", (Object)query.toString());
    }

    @Test
    public void shouldCreateQueryWithNoPinnedStateAndArchivedStateAndNoAuthorAndCurrentUserIsPublisher() throws Exception {
        NewsQueryBuilder queryBuilder = new NewsQueryBuilder();
        NewsFilter filter = new NewsFilter();
        filter.setPublishedNews(false);
        filter.setArchivedNews(true);
        filter.setOrder("jcr:score");
        org.exoplatform.services.security.Identity currentIdentity = new org.exoplatform.services.security.Identity("john");
        MembershipEntry membershipentry = new MembershipEntry("/platform/web-contributors", "publisher");
        ArrayList<MembershipEntry> memberships = new ArrayList<MembershipEntry>();
        memberships.add(membershipentry);
        currentIdentity.setMemberships(memberships);
        ConversationState state = new ConversationState(currentIdentity);
        ConversationState.setCurrent((ConversationState)state);
        StringBuilder query = queryBuilder.buildQuery(filter);
        Assert.assertNotNull((Object)query);
        Assert.assertEquals((Object)"SELECT * FROM exo:news WHERE exo:archived = 'true' AND (publication:currentState = 'published' OR (publication:currentState = 'draft' AND exo:activities <> '' )) AND jcr:path LIKE '/Groups/spaces/%' ORDER BY jcr:score DESC", (Object)query.toString());
    }

    @Test
    public void shouldCreateQueryWithNoPinnedStateAndArchivedStateAndNoAuthorAndCurrentUserIsNoPublisher() throws Exception {
        NewsQueryBuilder queryBuilder = new NewsQueryBuilder();
        NewsFilter filter = new NewsFilter();
        filter.setPublishedNews(false);
        filter.setArchivedNews(true);
        filter.setOrder("jcr:score");
        org.exoplatform.services.security.Identity currentIdentity = new org.exoplatform.services.security.Identity("john");
        MembershipEntry membershipentry = new MembershipEntry("/platform/web-contributors", "redactor");
        ArrayList<MembershipEntry> memberships = new ArrayList<MembershipEntry>();
        memberships.add(membershipentry);
        currentIdentity.setMemberships(memberships);
        ConversationState state = new ConversationState(currentIdentity);
        ConversationState.setCurrent((ConversationState)state);
        StringBuilder query = queryBuilder.buildQuery(filter);
        Assert.assertNotNull((Object)query);
        Assert.assertEquals((Object)"SELECT * FROM exo:news WHERE ( exo:archived = 'true' AND exo:author = 'john') AND (publication:currentState = 'published' OR (publication:currentState = 'draft' AND exo:activities <> '' )) AND jcr:path LIKE '/Groups/spaces/%' ORDER BY jcr:score DESC", (Object)query.toString());
    }

    @Test
    public void shouldCreateQueryWithStagedStateWhenCurrentUserIsAuthor() throws Exception {
        NewsQueryBuilder queryBuilder = new NewsQueryBuilder();
        NewsFilter filter = new NewsFilter();
        filter.setScheduledNews(true);
        filter.setAuthor("john");
        org.exoplatform.services.security.Identity currentIdentity = new org.exoplatform.services.security.Identity("john");
        MembershipEntry membershipentry = new MembershipEntry("/platform/web-contributors", "publisher");
        ArrayList<MembershipEntry> memberships = new ArrayList<MembershipEntry>();
        memberships.add(membershipentry);
        currentIdentity.setMemberships(memberships);
        ConversationState state = new ConversationState(currentIdentity);
        ConversationState.setCurrent((ConversationState)state);
        ArrayList<Space> spaces = new ArrayList<Space>();
        Space space1 = new Space();
        space1.setId("1");
        space1.setPrettyName("space1");
        Space space2 = new Space();
        space2.setId("2");
        space2.setPrettyName("space2");
        spaces.add(space1);
        spaces.add(space2);
        NEWS_UTILS.when(() -> NewsUtils.getAllowedScheduledNewsSpaces((org.exoplatform.services.security.Identity)currentIdentity)).thenReturn(spaces);
        StringBuilder query = queryBuilder.buildQuery(filter);
        Assert.assertNotNull((Object)query);
        Assert.assertEquals((Object)"SELECT * FROM exo:news WHERE publication:currentState = 'staged' AND (exo:author = 'john' OR exo:spaceId = '1' OR exo:spaceId = '2' ) AND jcr:path LIKE '/Groups/spaces/%' ORDER BY null DESC", (Object)query.toString());
    }

    @Test
    public void shouldCreateQueryWithNoFilter() throws Exception {
        NewsQueryBuilder queryBuilder = new NewsQueryBuilder();
        NewsFilter filter = new NewsFilter();
        org.exoplatform.services.security.Identity currentIdentity = new org.exoplatform.services.security.Identity("john");
        ConversationState state = new ConversationState(currentIdentity);
        ConversationState.setCurrent((ConversationState)state);
        filter = null;
        StringBuilder query = queryBuilder.buildQuery(filter);
        Assert.assertNotNull((Object)query);
        Assert.assertEquals((Object)"SELECT * FROM exo:news WHERE ", (Object)query.toString());
    }

    @Test
    public void testBuildQueryWithTagNames() throws Exception {
        NewsQueryBuilder queryBuilder = new NewsQueryBuilder();
        org.exoplatform.services.security.Identity currentIdentity = new org.exoplatform.services.security.Identity("john");
        ConversationState state = new ConversationState(currentIdentity);
        ConversationState.setCurrent((ConversationState)state);
        NewsFilter filter = new NewsFilter();
        filter.setAuthor("john");
        filter.setTagNames(Arrays.asList("text"));
        StringBuilder query = queryBuilder.buildQuery(filter);
        Assert.assertNotNull((Object)query);
        Assert.assertEquals((Object)"SELECT * FROM exo:news WHERE ( exo:archived IS NULL OR exo:archived = 'false' OR ( exo:archived = 'true' AND  exo:author = 'john')) AND  exo:body LIKE '%#text%' AND exo:author = 'john' AND (publication:currentState = 'published' OR (publication:currentState = 'draft' AND exo:activities <> '' )) AND jcr:path LIKE '/Groups/spaces/%' ORDER BY null DESC", (Object)query.toString());
    }

    @Test
    public void shouldAddFuzzySyntaxWhitQuotedWord() throws Exception {
        String text = "\"quoted\"";
        NewsQueryBuilder queryBuilder = new NewsQueryBuilder();
        String result = queryBuilder.addFuzzySyntaxAndOR(text);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"\"quoted\"~0.6", (Object)result);
    }

    @Test
    public void shouldAddFuzzySyntaxWhenTextContainsMultiWords() throws Exception {
        String text = "search text";
        NewsQueryBuilder queryBuilder = new NewsQueryBuilder();
        String result = queryBuilder.addFuzzySyntaxAndOR(text);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"search~0.6 OR text~0.6", (Object)result);
    }

    @Test
    public void shouldAddFuzzySyntaxWhenTextContainsQuotedMultiWords() throws Exception {
        String text = "\"search text\"";
        NewsQueryBuilder queryBuilder = new NewsQueryBuilder();
        String result = queryBuilder.addFuzzySyntaxAndOR(text);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"\"search text\"~0.6", (Object)result);
    }

    @Test
    public void shouldAddFuzzySyntaxWhenTextContainsMultiWordsAndQuotedOne() throws Exception {
        String text = "this is a \"search text\"";
        NewsQueryBuilder queryBuilder = new NewsQueryBuilder();
        String result = queryBuilder.addFuzzySyntaxAndOR(text);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"this~0.6 OR is~0.6 OR a~0.6 OR \"search text\"~0.6", (Object)result);
    }

    @Test
    public void testAddFuzzySyntaxAndORQuoteInsideQuote() {
        NewsQueryBuilder queryBuilder = new NewsQueryBuilder();
        String text = "This \"quoted\" text.";
        String result = queryBuilder.addFuzzySyntaxAndOR(text);
        Assert.assertEquals((Object)"This~0.6 OR \"quoted\"~0.6 OR  text.~0.6", (Object)result);
    }
}

