/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.rest;

import jakarta.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.news.filter.NewsFilter;
import org.exoplatform.news.model.News;
import org.exoplatform.news.rest.NewsEntity;
import org.exoplatform.news.rest.NewsRestResourcesV1;
import org.exoplatform.news.service.NewsService;
import org.exoplatform.services.cms.thumbnail.ThumbnailService;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.social.metadata.tag.TagService;
import org.exoplatform.social.rest.api.RestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.AdditionalAnswers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class NewsRestResourcesV1Test {
    public static final String JOHN = "john";
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
    private static final MockedStatic<RestUtils> REST_UTILS = Mockito.mockStatic(RestUtils.class);
    @Mock
    NewsService newsService;
    @Mock
    SpaceService spaceService;
    @Mock
    IdentityManager identityManager;
    @Mock
    PortalContainer container;
    @Mock
    FavoriteService favoriteService;
    @Mock
    ThumbnailService thumbnailService;
    @Mock
    TagService tagService;
    private NewsRestResourcesV1 newsRestResourcesV1;

    @Before
    public void setup() {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        this.newsRestResourcesV1 = new NewsRestResourcesV1(this.newsService, this.spaceService, this.identityManager, this.container, this.favoriteService, this.thumbnailService);
        org.exoplatform.social.core.identity.model.Identity userIdentity = new org.exoplatform.social.core.identity.model.Identity("1", JOHN, "organization", false, true, null, null, null);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(JOHN)).thenReturn((Object)userIdentity);
    }

    @AfterClass
    public static void afterRunBare() throws Exception {
        COMMONS_UTILS.close();
        REST_UTILS.close();
    }

    @Test
    public void shouldGetNewsWhenNewsExistsAndUserIsMemberOfTheSpace() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        News news = new News();
        news.setId("1");
        news.setIllustration("illustration".getBytes());
        Mockito.lenient().when((Object)this.newsService.getNewsById((String)ArgumentMatchers.nullable(String.class), (Identity)ArgumentMatchers.any(), ((Boolean)ArgumentMatchers.nullable(Boolean.class)).booleanValue(), (String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)news);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById((String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)new Space());
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.isSuperManager((String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)false);
        Response response = this.newsRestResourcesV1.getNewsById(request, "1", null, null, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        News fetchedNews = (News)response.getEntity();
        Assert.assertNotNull((Object)fetchedNews);
        Assert.assertNull((Object)fetchedNews.getIllustration());
    }

    @Test
    public void shouldGetNewsByGivenTargetName() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        LinkedList<News> newsList = new LinkedList<News>();
        News news = new News();
        news.setId("1");
        LinkedList<String> targets = new LinkedList<String>();
        targets.add("sliderNews");
        news.setTargets(targets);
        newsList.add(news);
        NewsFilter newsFilter = new NewsFilter();
        newsFilter.setLimit(10);
        Mockito.lenient().when((Object)this.newsService.getNewsByTargetName(newsFilter, "sliderNews", currentIdentity)).thenReturn(newsList);
        Response response = this.newsRestResourcesV1.getNewsByTarget(request, "sliderNews", 0, 10, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Assert.assertNotNull((Object)response.getEntity());
        NewsEntity newsEntity = (NewsEntity)response.getEntity();
        List newsEntityNews = newsEntity.getNews();
        Assert.assertEquals((long)1L, (long)newsEntityNews.size());
    }

    @Test
    public void shouldReturnBadRequestWhenNoActivityId() throws Exception {
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        Response response = this.newsRestResourcesV1.getNewsByActivityId(null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldReturnNotFoundwhenNewsNotFound() throws Exception {
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        String activityId = "activityId";
        Response response = this.newsRestResourcesV1.getNewsByActivityId(activityId);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldReturnNotFoundWhenNotAccessible() throws Exception {
        String activityId = "activityId";
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        Mockito.when((Object)this.newsService.getNewsByActivityId(activityId, currentIdentity)).thenThrow(IllegalAccessException.class);
        Response response = this.newsRestResourcesV1.getNewsByActivityId(activityId);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldReturnNotFoundWhenNewsWithActivityNotFoundException() throws Exception {
        String activityId = "activityId";
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        Mockito.when((Object)this.newsService.getNewsByActivityId(activityId, currentIdentity)).thenThrow(ObjectNotFoundException.class);
        Response response = this.newsRestResourcesV1.getNewsByActivityId(activityId);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldReturnServerErrorWhenNewsWithActivitythrowsException() throws Exception {
        String activityId = "activityId";
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        Mockito.when((Object)this.newsService.getNewsByActivityId(activityId, currentIdentity)).thenThrow(RuntimeException.class);
        Response response = this.newsRestResourcesV1.getNewsByActivityId(activityId);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldReturnNewsWhenNewsIsFound() throws Exception {
        String activityId = "activityId";
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        News news = (News)Mockito.mock(News.class);
        Mockito.when((Object)this.newsService.getNewsByActivityId(activityId, currentIdentity)).thenReturn((Object)news);
        Response response = this.newsRestResourcesV1.getNewsByActivityId(activityId);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Assert.assertEquals((Object)news, (Object)response.getEntity());
    }

    @Test
    public void shouldGetNewsWhenNewsExistsAndUserIsNotMemberOfTheSpaceButSuperManager() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        News news = new News();
        Mockito.lenient().when((Object)this.newsService.getNewsById(ArgumentMatchers.anyString(), (Identity)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)news);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)new Space());
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)false);
        Mockito.lenient().when((Object)this.spaceService.isSuperManager((String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)true);
        Response response = this.newsRestResourcesV1.getNewsById(request, "1", null, null, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetNotFoundWhenNewsNotExists() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        Mockito.lenient().when((Object)this.newsService.getNewsById(ArgumentMatchers.anyString(), (Identity)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (String)ArgumentMatchers.nullable(String.class))).thenReturn(null);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)new Space());
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.isSuperManager((String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)true);
        Response response = this.newsRestResourcesV1.getNewsById(request, "1", null, null, false);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetNewsSpacesWhenNewsExistsAndUserIsMemberOfTheSpace() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        News news = new News();
        news.setId("1");
        news.setIllustration("illustration".getBytes());
        news.setActivities("1:1;2:2");
        news.setSpaceId("1");
        Space space1 = new Space();
        space1.setId("1");
        space1.setPrettyName("space1");
        Space space2 = new Space();
        space1.setId("2");
        space1.setPrettyName("space2");
        Mockito.lenient().when((Object)this.newsService.getNewsById(ArgumentMatchers.anyString(), (Identity)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)news);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById("1")).thenReturn((Object)space1);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById("2")).thenReturn((Object)space2);
        Mockito.lenient().when((Object)this.spaceService.isMember(space1, JOHN)).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.isMember(space2, JOHN)).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.isSuperManager((String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)false);
        Response response = this.newsRestResourcesV1.getNewsById(request, "1", "spaces", null, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetOKWhenUpdatingNewsAndNewsExistsAndUserIsAuthorized() throws Exception {
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        News existingNews = new News();
        existingNews.setTitle("Title");
        existingNews.setSummary("Summary");
        existingNews.setBody("Body");
        existingNews.setPublicationState("draft");
        existingNews.setCanEdit(true);
        Mockito.lenient().when((Object)this.newsService.getNewsById(ArgumentMatchers.anyString(), (Identity)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (String)ArgumentMatchers.eq(null))).thenReturn((Object)existingNews);
        News updatedNews = new News();
        updatedNews.setTitle("Updated Title");
        updatedNews.setSummary("Updated Summary");
        updatedNews.setBody("Updated Body");
        updatedNews.setPublicationState("published");
        Mockito.lenient().when((Object)this.newsService.updateNews(existingNews, JOHN, Boolean.valueOf(false), updatedNews.isPublished(), null)).then(AdditionalAnswers.returnsFirstArg());
        Response response = this.newsRestResourcesV1.updateNews("1", false, null, updatedNews);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        News returnedNews = (News)response.getEntity();
        Assert.assertNotNull((Object)returnedNews);
        Assert.assertEquals((Object)"Updated Title", (Object)returnedNews.getTitle());
        Assert.assertEquals((Object)"Updated Summary", (Object)returnedNews.getSummary());
        Assert.assertEquals((Object)"Updated Body", (Object)returnedNews.getBody());
        Assert.assertEquals((Object)"published", (Object)returnedNews.getPublicationState());
        Mockito.when((Object)this.newsRestResourcesV1.updateNews("1", false, null, updatedNews)).thenThrow(IllegalAccessException.class);
        response = this.newsRestResourcesV1.updateNews("1", false, null, updatedNews);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetNotFoundWhenUpdatingNewsAndNewsNotExists() throws Exception {
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        Mockito.lenient().when((Object)this.newsService.getNewsById(ArgumentMatchers.anyString(), (Identity)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (String)ArgumentMatchers.nullable(String.class))).thenReturn(null);
        Response response = this.newsRestResourcesV1.updateNews("1", false, null, new News());
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetOKWhenPinNewsAndNewsExistsAndUserIsAuthorized() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        News oldnews = new News();
        oldnews.setTitle("unpinned");
        oldnews.setSummary("unpinned summary");
        oldnews.setBody("unpinned body");
        oldnews.setUploadId(null);
        String sDate1 = "22/08/2019";
        Date date1 = new SimpleDateFormat("dd/MM/yyyy").parse(sDate1);
        oldnews.setCreationDate(date1);
        oldnews.setPublished(false);
        oldnews.setId("id123");
        oldnews.setSpaceId("space");
        oldnews.setCanEdit(true);
        News updatedNews = new News();
        updatedNews.setPublished(true);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        LinkedList<MembershipEntry> memberships = new LinkedList<MembershipEntry>();
        memberships.add(new MembershipEntry("/platform/web-contributors", "publisher"));
        currentIdentity.setMemberships(memberships);
        Space space = (Space)Mockito.mock(Space.class);
        Mockito.lenient().when((Object)this.newsService.getNewsById("id123", currentIdentity, false)).thenReturn((Object)oldnews);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)space);
        Response response = this.newsRestResourcesV1.patchNews(request, "id123", updatedNews);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetOKWhenArchiveNewsAndNewsExistsAndUserIsAuthorized() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        News oldnews = new News();
        oldnews.setTitle("unarchived");
        oldnews.setSummary("unarchived summary");
        oldnews.setBody("unarchived body");
        oldnews.setUploadId(null);
        String sDate1 = "22/08/2019";
        Date date1 = new SimpleDateFormat("dd/MM/yyyy").parse(sDate1);
        oldnews.setCreationDate(date1);
        oldnews.setPublished(false);
        oldnews.setArchived(false);
        oldnews.setId("id123");
        oldnews.setSpaceId("space");
        oldnews.setCanEdit(true);
        News updatedNews = new News();
        updatedNews.setArchived(true);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        LinkedList<MembershipEntry> memberships = new LinkedList<MembershipEntry>();
        memberships.add(new MembershipEntry("/platform/web-contributors", "publisher"));
        currentIdentity.setMemberships(memberships);
        Space space = (Space)Mockito.mock(Space.class);
        Mockito.lenient().when((Object)this.newsService.getNewsById("id123", currentIdentity, false)).thenReturn((Object)oldnews);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)space);
        Response response = this.newsRestResourcesV1.patchNews(request, "id123", updatedNews);
        ((NewsService)Mockito.verify((Object)this.newsService, (VerificationMode)Mockito.times((int)1))).archiveNews("id123", JOHN);
        ((NewsService)Mockito.verify((Object)this.newsService, (VerificationMode)Mockito.times((int)0))).updateNews(oldnews, request.getRemoteUser(), null, oldnews.isPublished());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetOKWhenUnarchiveNewsAndNewsExistsAndUserIsAuthorized() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        News oldnews = new News();
        oldnews.setTitle("unarchived");
        oldnews.setSummary("unarchived summary");
        oldnews.setBody("unarchived body");
        oldnews.setUploadId(null);
        String sDate1 = "22/08/2019";
        Date date1 = new SimpleDateFormat("dd/MM/yyyy").parse(sDate1);
        oldnews.setCreationDate(date1);
        oldnews.setPublished(false);
        oldnews.setArchived(true);
        oldnews.setId("id123");
        oldnews.setSpaceId("space");
        oldnews.setAuthor(JOHN);
        oldnews.setCanEdit(true);
        News updatedNews = new News();
        updatedNews.setArchived(false);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        LinkedList<MembershipEntry> memberships = new LinkedList<MembershipEntry>();
        memberships.add(new MembershipEntry("/platform/web-contributors", "redactor"));
        currentIdentity.setMemberships(memberships);
        Space space = (Space)Mockito.mock(Space.class);
        Mockito.lenient().when((Object)this.newsService.getNewsById("id123", currentIdentity, false)).thenReturn((Object)oldnews);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)space);
        Response response = this.newsRestResourcesV1.patchNews(request, "id123", updatedNews);
        ((NewsService)Mockito.verify((Object)this.newsService, (VerificationMode)Mockito.times((int)1))).unarchiveNews("id123", JOHN);
        ((NewsService)Mockito.verify((Object)this.newsService, (VerificationMode)Mockito.times((int)0))).updateNews(oldnews, request.getRemoteUser(), null, oldnews.isPublished());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetUnauthorizedWhenArchiveNewsAndNewsExistsAndUserIsNotAuthorized() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        News oldnews = new News();
        oldnews.setTitle("unarchived");
        oldnews.setSummary("unarchived summary");
        oldnews.setBody("unarchived body");
        oldnews.setUploadId(null);
        String sDate1 = "22/08/2019";
        Date date1 = new SimpleDateFormat("dd/MM/yyyy").parse(sDate1);
        oldnews.setCreationDate(date1);
        oldnews.setPublished(false);
        oldnews.setArchived(false);
        oldnews.setId("id123");
        oldnews.setSpaceId("space");
        oldnews.setAuthor("test");
        oldnews.setCanEdit(false);
        News updatedNews = new News();
        updatedNews.setArchived(true);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        LinkedList<MembershipEntry> memberships = new LinkedList<MembershipEntry>();
        memberships.add(new MembershipEntry("/platform/web-contributors", "redactor"));
        currentIdentity.setMemberships(memberships);
        Space space = (Space)Mockito.mock(Space.class);
        Mockito.lenient().when((Object)this.newsService.getNewsById("id123", currentIdentity, false)).thenReturn((Object)oldnews);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)space);
        Response response = this.newsRestResourcesV1.patchNews(request, "id123", updatedNews);
        ((NewsService)Mockito.verify((Object)this.newsService, (VerificationMode)Mockito.times((int)0))).archiveNews("id123", JOHN);
        ((NewsService)Mockito.verify((Object)this.newsService, (VerificationMode)Mockito.times((int)0))).updateNews(oldnews, request.getRemoteUser(), null, oldnews.isPublished());
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetOKWhenUpdatingAndPinNewsAndNewsExistsAndAndUserIsAuthorized() throws Exception {
        News existingNews = new News();
        existingNews.setTitle("unpinned title");
        existingNews.setSummary("unpinned summary");
        existingNews.setBody("unpinned body");
        existingNews.setUploadId(null);
        String sDate1 = "22/08/2019";
        Date date1 = new SimpleDateFormat("dd/MM/yyyy").parse(sDate1);
        existingNews.setCreationDate(date1);
        existingNews.setPublished(false);
        existingNews.setId("id123");
        existingNews.setSpaceId("space");
        existingNews.setCanEdit(true);
        News updatedNews = new News();
        updatedNews.setPublished(true);
        updatedNews.setTitle("pinned title");
        updatedNews.setSummary("pinned summary");
        updatedNews.setBody("pinned body");
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        LinkedList<MembershipEntry> memberships = new LinkedList<MembershipEntry>();
        memberships.add(new MembershipEntry("/platform/web-contributors", "publisher"));
        currentIdentity.setMemberships(memberships);
        Mockito.lenient().when((Object)this.newsService.getNewsById("id123", currentIdentity, false, null)).thenReturn((Object)existingNews);
        Mockito.lenient().when((Object)this.newsService.updateNews(existingNews, JOHN, Boolean.valueOf(false), updatedNews.isPublished(), null)).then(AdditionalAnswers.returnsFirstArg());
        Response response = this.newsRestResourcesV1.updateNews("id123", false, null, updatedNews);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        News returnedNews = (News)response.getEntity();
        Assert.assertNotNull((Object)returnedNews);
        Assert.assertEquals((Object)"pinned title", (Object)returnedNews.getTitle());
        Assert.assertEquals((Object)"pinned summary", (Object)returnedNews.getSummary());
        Assert.assertEquals((Object)"pinned body", (Object)returnedNews.getBody());
    }

    @Test
    public void shouldGetOKWhenUpdatingAndUnpinNewsAndNewsExistsAndAndUserIsAuthorized() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        News oldnews = new News();
        oldnews.setTitle("unpinned");
        oldnews.setSummary("unpinned summary");
        oldnews.setBody("unpinned body");
        oldnews.setUploadId(null);
        String sDate1 = "22/08/2019";
        Date date1 = new SimpleDateFormat("dd/MM/yyyy").parse(sDate1);
        oldnews.setCreationDate(date1);
        oldnews.setPublished(true);
        oldnews.setId("id123");
        oldnews.setSpaceId("space");
        oldnews.setCanEdit(true);
        News updatedNews = new News();
        updatedNews.setPublished(false);
        oldnews.setTitle("pinned");
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        LinkedList<MembershipEntry> memberships = new LinkedList<MembershipEntry>();
        memberships.add(new MembershipEntry("/platform/web-contributors", "publisher"));
        currentIdentity.setMemberships(memberships);
        Mockito.lenient().when((Object)this.newsService.getNewsById("id123", currentIdentity, false, null)).thenReturn((Object)oldnews);
        Response response = this.newsRestResourcesV1.updateNews("id123", false, null, updatedNews);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetNotFoundWhenNewsIsNull() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        News updatedNews = new News();
        updatedNews.setPublished(true);
        Mockito.lenient().when((Object)this.newsService.getNewsById("id123", currentIdentity, false)).thenReturn(null);
        Response response = this.newsRestResourcesV1.patchNews(request, "id123", updatedNews);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetOKWhenPatchNewsAndUserIsAuthorized() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        News oldnews = new News();
        oldnews.setTitle("unpinned");
        oldnews.setSummary("unpinned summary");
        oldnews.setBody("unpinned body");
        oldnews.setUploadId(null);
        String sDate1 = "22/08/2019";
        Date date1 = new SimpleDateFormat("dd/MM/yyyy").parse(sDate1);
        oldnews.setCreationDate(date1);
        oldnews.setPublished(false);
        oldnews.setId("id123");
        oldnews.setSpaceId("space");
        oldnews.setCanEdit(true);
        News updatedNews = new News();
        updatedNews.setPublished(true);
        updatedNews.setTitle("title updated");
        updatedNews.setSummary("summary updated");
        updatedNews.setBody("body updated");
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        LinkedList<MembershipEntry> memberships = new LinkedList<MembershipEntry>();
        memberships.add(new MembershipEntry("/platform/web-contributors", "publisher"));
        currentIdentity.setMemberships(memberships);
        Space space = (Space)Mockito.mock(Space.class);
        Mockito.lenient().when((Object)this.newsService.getNewsById("id123", currentIdentity, false)).thenReturn((Object)oldnews);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)space);
        Response response = this.newsRestResourcesV1.patchNews(request, "id123", updatedNews);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetOKWhenUnpinNewsAndNewsExistsAndUserIsAuthorized() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        News oldnews = new News();
        oldnews.setTitle("unpinned");
        oldnews.setSummary("unpinned summary");
        oldnews.setBody("unpinned body");
        oldnews.setUploadId(null);
        String sDate1 = "22/08/2019";
        Date date1 = new SimpleDateFormat("dd/MM/yyyy").parse(sDate1);
        oldnews.setCreationDate(date1);
        oldnews.setPublished(true);
        oldnews.setId("id123");
        oldnews.setSpaceId("space");
        oldnews.setCanEdit(true);
        News updatedNews = new News();
        updatedNews.setPublished(false);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        LinkedList<MembershipEntry> memberships = new LinkedList<MembershipEntry>();
        memberships.add(new MembershipEntry("/platform/web-contributors", "publisher"));
        currentIdentity.setMemberships(memberships);
        Space space = (Space)Mockito.mock(Space.class);
        Mockito.lenient().when((Object)this.newsService.getNewsById("id123", currentIdentity, false)).thenReturn((Object)oldnews);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)space);
        Response response = this.newsRestResourcesV1.patchNews(request, "id123", updatedNews);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetBadRequestWhenUpdatingNewsAndUpdatedNewsIsNull() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        Response response = this.newsRestResourcesV1.updateNews("1", false, null, null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetBadRequestWhenPatchNewsAndUpdatedNewsIsNull() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        Response response = this.newsRestResourcesV1.patchNews(request, "1", null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetUnauthorizedWhenPatchNewsAndUSpaceIsNull() throws Exception {
        News news = new News();
        news.setId("1");
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Mockito.lenient().when((Object)this.newsService.getNewsById("1", currentIdentity, false)).thenReturn((Object)news);
        Response response = this.newsRestResourcesV1.patchNews(request, "1", new News());
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetOKWhenSavingDraftsAndUserIsMemberOfTheSpaceAndSuperManager() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        News news = new News();
        news.setId("1");
        news.setSpaceId("1");
        Mockito.lenient().when((Object)this.newsService.getNewsById(ArgumentMatchers.anyString(), (Identity)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)news);
        Space space1 = new Space();
        space1.setId("1");
        space1.setPrettyName("space1");
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)space1);
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.isSuperManager((String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)true);
        Response response = this.newsRestResourcesV1.createNews(request, news);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)this.newsRestResourcesV1.createNews(request, news)).thenThrow(IllegalAccessException.class);
        response = this.newsRestResourcesV1.createNews(request, news);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetOkWhenCreateNewsWithPublishedState() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        News news = new News();
        news.setId("1");
        news.setPublicationState("published");
        news.setSpaceId("1");
        Space space1 = new Space();
        space1.setId("1");
        space1.setPrettyName("space1");
        Mockito.lenient().when((Object)this.newsService.getNewsById(ArgumentMatchers.anyString(), (Identity)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)news);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)space1);
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.isSuperManager((String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)true);
        Response response = this.newsRestResourcesV1.createNews(request, news);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetOkWhenScheduleNews() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        News news = new News();
        news.setId("1");
        news.setPublicationState("staged");
        news.setCanEdit(true);
        news.setSpaceId("1");
        Space space1 = new Space();
        space1.setId("1");
        space1.setPrettyName("space1");
        Mockito.lenient().when((Object)this.newsService.getNewsById(ArgumentMatchers.anyString(), (Identity)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)news);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)space1);
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.isSuperManager((String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)true);
        Response response = this.newsRestResourcesV1.scheduleNews(request, news);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetBadRequestWhenCreatingNewsDraftAndNewsIsNull() throws Exception {
        News news = new News();
        news.setId("1");
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        Mockito.lenient().when((Object)this.newsService.getNewsById(ArgumentMatchers.anyString(), (Identity)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn(null);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)new Space());
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)false);
        Mockito.lenient().when((Object)this.spaceService.isSuperManager((String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)true);
        Response response = this.newsRestResourcesV1.createNews(request, new News());
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetNewsDraftWhenNewsDraftExistsAndUserIsMemberOfTheSpaceAndSuperManager() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        News news = new News();
        news.setId("1");
        news.setSpaceId("1");
        Mockito.when((Object)this.newsService.getNewsById(ArgumentMatchers.anyString(), (Identity)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (String)ArgumentMatchers.nullable(String.class))).thenReturn((Object)news);
        Response response = this.newsRestResourcesV1.getNewsById(request, "1", null, null, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetNotFoundWhenNewsDraftNotExists() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        Mockito.lenient().when((Object)this.newsService.getNewsById(ArgumentMatchers.anyString(), (Identity)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn(null);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)new Space());
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.isSuperManager((String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)true);
        Response response = this.newsRestResourcesV1.getNewsById(request, "1", null, null, false);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetBadRequestWhenNewsDraftIsNull() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        Mockito.lenient().when((Object)this.newsService.getNewsById(ArgumentMatchers.anyString(), (Identity)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn(null);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)new Space());
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.isSuperManager((String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)true);
        Response response = this.newsRestResourcesV1.getNewsById(request, null, null, null, false);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetNewsDraftListWhenNewsDraftsExistsAndUserIsMemberOfTheSpaceAndSuperManager() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        News news = new News();
        news.setId("1");
        news.setSpaceId("1");
        News news2 = new News();
        news2.setId("2");
        news2.setSpaceId("1");
        ArrayList<News> newsDrafts = new ArrayList<News>();
        newsDrafts.add(news);
        newsDrafts.add(news2);
        Mockito.lenient().when((Object)this.newsService.getNews((NewsFilter)ArgumentMatchers.any(NewsFilter.class), (Identity)ArgumentMatchers.any())).thenReturn(newsDrafts);
        Space space1 = new Space();
        space1.setId("1");
        space1.setPrettyName("space1");
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)space1);
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.isSuperManager((String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)true);
        Response response = this.newsRestResourcesV1.getNews(request, JOHN, "1", "drafts", "", 0, 10, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetNotAuthorizedWhenNewsDraftsExistsAndUserIsNotMemberOfTheSpaceNorSuperManager() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        News news = new News();
        news.setId("1");
        news.setSpaceId("1");
        News news2 = new News();
        news2.setId("2");
        news2.setSpaceId("1");
        ArrayList<News> newsDrafts = new ArrayList<News>();
        newsDrafts.add(news);
        newsDrafts.add(news2);
        Mockito.lenient().when((Object)this.newsService.getNews((NewsFilter)ArgumentMatchers.any(NewsFilter.class), (Identity)ArgumentMatchers.any())).thenReturn(newsDrafts);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)new Space());
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)false);
        Mockito.lenient().when((Object)this.spaceService.isSuperManager((String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)false);
        Response response = this.newsRestResourcesV1.getNews(request, JOHN, "1", "draft", null, 0, 10, false);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetNotAuthorizedWhenNewsDraftsExistsAndUserNotExists() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)"");
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        News news = new News();
        news.setId("1");
        news.setSpaceId("1");
        News news2 = new News();
        news2.setId("2");
        news2.setSpaceId("1");
        ArrayList<News> newsDrafts = new ArrayList<News>();
        newsDrafts.add(news);
        newsDrafts.add(news2);
        Mockito.lenient().when((Object)this.newsService.getNews((NewsFilter)ArgumentMatchers.any(NewsFilter.class), (Identity)ArgumentMatchers.any())).thenReturn(newsDrafts);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)new Space());
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.any())).thenReturn((Object)true);
        Response response = this.newsRestResourcesV1.getNews(request, "mike", "1", "draft", null, 0, 10, false);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldDeleteNewsWhenNewsExists() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        News news = new News();
        news.setId("1");
        news.setAuthor(JOHN);
        news.setSpaceId("1");
        news.setCanDelete(true);
        Mockito.lenient().when((Object)this.newsService.getNewsById(ArgumentMatchers.anyString(), (Identity)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyString())).thenReturn((Object)news);
        Space space1 = new Space();
        space1.setId("1");
        space1.setPrettyName("space1");
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)space1);
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.isSuperManager((String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)true);
        Response response = this.newsRestResourcesV1.deleteNews(request, "1", false, 0L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        ((NewsService)Mockito.verify((Object)this.newsService)).deleteNews("1", currentIdentity, false);
    }

    @Test
    public void shouldNotDeleteNewsWhenUserIsNotDraftAuthor() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        News news = new News();
        news.setId("1");
        news.setAuthor("mary");
        news.setSpaceId("1");
        news.setCanDelete(true);
        Mockito.lenient().when((Object)this.newsService.getNewsById(ArgumentMatchers.anyString(), (Identity)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyString())).thenReturn((Object)news);
        Space space1 = new Space();
        space1.setId("1");
        space1.setPrettyName("space1");
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)space1);
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.isSuperManager((String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)true);
        Response response = this.newsRestResourcesV1.deleteNews(request, "1", false, 0L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        ((NewsService)Mockito.verify((Object)this.newsService)).deleteNews("1", currentIdentity, false);
    }

    @Test
    public void shouldGetNotFoundWhenDeletingNewsDraftThatNotExists() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Mockito.lenient().when((Object)this.newsService.getNewsById(ArgumentMatchers.anyString(), (Identity)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (String)ArgumentMatchers.nullable(String.class))).thenReturn(null);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)new Space());
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.isSuperManager((String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)true);
        Response response = this.newsRestResourcesV1.deleteNews(request, "1", false, 0L);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
        ((NewsService)Mockito.verify((Object)this.newsService, (VerificationMode)Mockito.never())).deleteNews("1", currentIdentity, false);
    }

    @Test
    public void shouldGetBadRequestWhenDeletingNewsDraftWithIdNull() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Mockito.lenient().when((Object)this.newsService.getNewsById(ArgumentMatchers.anyString(), (Identity)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (String)ArgumentMatchers.nullable(String.class))).thenReturn(null);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)new Space());
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.isSuperManager((String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)true);
        Response response = this.newsRestResourcesV1.deleteNews(request, null, false, 0L);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        ((NewsService)Mockito.verify((Object)this.newsService, (VerificationMode)Mockito.never())).deleteNews("1", currentIdentity, false);
    }

    @Test
    public void shouldGetAllPublishedNewsWhenExist() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        News news1 = new News();
        News news2 = new News();
        News news3 = new News();
        ArrayList<News> allNews = new ArrayList<News>();
        allNews.add(news1);
        allNews.add(news2);
        allNews.add(news3);
        Mockito.lenient().when((Object)this.newsService.getNews((NewsFilter)ArgumentMatchers.any(), (Identity)ArgumentMatchers.any())).thenReturn(allNews);
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)new Space());
        Response response = this.newsRestResourcesV1.getNews(request, JOHN, null, "", null, 0, 10, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        NewsEntity newsEntity = (NewsEntity)response.getEntity();
        List newsList = newsEntity.getNews();
        Assert.assertEquals((long)3L, (long)newsList.size());
    }

    @Test
    public void shouldGetEmptyListWhenNoPublishedExists() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        NewsFilter newsFilter = new NewsFilter();
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)new Space());
        Mockito.lenient().when((Object)this.newsService.getNews(newsFilter, currentIdentity)).thenReturn(null);
        Response response = this.newsRestResourcesV1.getNews(request, JOHN, null, null, null, 0, 10, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        NewsEntity newsEntity = (NewsEntity)response.getEntity();
        Assert.assertNotNull((Object)newsEntity);
        Assert.assertEquals((long)0L, (long)newsEntity.getNews().size());
    }

    @Test
    public void shouldGetOKWhenViewNewsAndNewsExists() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        News news = new News();
        news.setId("1");
        news.setSpaceId("space1");
        news.setViewsCount(Long.valueOf(6L));
        Mockito.lenient().when((Object)this.newsService.getNewsById("1", currentIdentity, false, null)).thenReturn((Object)news);
        Space space1 = new Space();
        space1.setPrettyName("space1");
        Mockito.lenient().when((Object)this.spaceService.getSpaceById("space1")).thenReturn((Object)space1);
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.isSuperManager((String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)false);
        Response response = this.newsRestResourcesV1.getNewsById(request, "1", null, null, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetNotFoundWhenViewNewsAndNewsIsNull() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        News news = new News();
        news.setId("1");
        news.setViewsCount(Long.valueOf(6L));
        Mockito.lenient().when((Object)this.newsService.getNewsById("1", currentIdentity, false, null)).thenReturn((Object)news);
        Response response = this.newsRestResourcesV1.getNewsById(request, "2", null, null, false);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetAllPinnedNewsWhenExist() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        News news1 = new News();
        news1.setPublished(true);
        news1.setAuthor(JOHN);
        news1.setPublicationState("published");
        News news2 = new News();
        news2.setPublished(true);
        news2.setAuthor(JOHN);
        news2.setPublicationState("published");
        News news3 = new News();
        news3.setPublished(true);
        news3.setAuthor(JOHN);
        news3.setPublicationState("published");
        ArrayList<News> allNews = new ArrayList<News>();
        allNews.add(news1);
        allNews.add(news2);
        allNews.add(news3);
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)new Space());
        Mockito.lenient().when((Object)this.newsService.getNews((NewsFilter)ArgumentMatchers.any(), (Identity)ArgumentMatchers.any())).thenReturn(allNews);
        Mockito.lenient().when((Object)this.newsService.getNewsCount((NewsFilter)ArgumentMatchers.any())).thenReturn((Object)allNews.size());
        Response response = this.newsRestResourcesV1.getNews(request, JOHN, null, "pinned", null, 0, 10, true);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        NewsEntity newsEntity = (NewsEntity)response.getEntity();
        List newsList = newsEntity.getNews();
        Assert.assertNotNull((Object)newsList);
        Assert.assertEquals((long)3L, (long)newsList.size());
        for (int i = 0; i < newsList.size(); ++i) {
            Assert.assertEquals((Object)true, (Object)((News)newsList.get(i)).isPublished());
            Assert.assertEquals((Object)"published", (Object)((News)newsList.get(i)).getPublicationState());
            Assert.assertEquals((Object)JOHN, (Object)((News)newsList.get(i)).getAuthor());
        }
        Assert.assertEquals((long)0L, (long)newsEntity.getOffset().intValue());
        Assert.assertEquals((long)10L, (long)newsEntity.getLimit().intValue());
        Assert.assertEquals((long)3L, (long)newsEntity.getSize().intValue());
    }

    @Test
    public void shouldGetAllNewsWhenSearchingWithTextInTheGivenSpaces() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        Mockito.lenient().when((Object)request.getLocale()).thenReturn((Object)new Locale("en"));
        String text = "search";
        String spacesIds = "4,1";
        News news1 = new News();
        news1.setSpaceId("4");
        news1.setAuthor(JOHN);
        news1.setTitle(text);
        news1.setPublicationState("published");
        News news2 = new News();
        news2.setSpaceId("1");
        news2.setAuthor(JOHN);
        news2.setTitle(text);
        news2.setPublicationState("published");
        News news3 = new News();
        news3.setSpaceId("4");
        news3.setAuthor(JOHN);
        news3.setTitle(text);
        news3.setPublicationState("published");
        ArrayList<News> allNews = new ArrayList<News>();
        allNews.add(news1);
        allNews.add(news2);
        allNews.add(news3);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(TagService.class)).thenReturn((Object)this.tagService);
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId()).thenReturn((Object)1L);
        Mockito.lenient().when((Object)this.newsService.searchNews((NewsFilter)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(allNews);
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)new Space());
        Response response = this.newsRestResourcesV1.getNews(request, JOHN, spacesIds, "", text, 0, 5, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        NewsEntity newsEntity = (NewsEntity)response.getEntity();
        List newsList = newsEntity.getNews();
        Assert.assertNotNull((Object)newsList);
        Assert.assertEquals((long)3L, (long)newsList.size());
        for (int i = 0; i < newsList.size(); ++i) {
            Assert.assertEquals((Object)"published", (Object)((News)newsList.get(i)).getPublicationState());
            Assert.assertEquals((Object)JOHN, (Object)((News)newsList.get(i)).getAuthor());
            Assert.assertEquals((Object)text, (Object)((News)newsList.get(i)).getTitle());
            Assert.assertEquals((Object)true, (Object)spacesIds.contains(((News)newsList.get(i)).getSpaceId()));
        }
        Assert.assertEquals((long)0L, (long)newsEntity.getOffset().intValue());
        Assert.assertEquals((long)5L, (long)newsEntity.getLimit().intValue());
        Assert.assertNull((Object)newsEntity.getSize());
    }

    @Test
    public void shouldGetAllNewsWhenSearchingWithTextInTheGivenSpace() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        Mockito.lenient().when((Object)request.getLocale()).thenReturn((Object)new Locale("en"));
        String text = "search";
        String spaceId = "4";
        News news1 = new News();
        news1.setSpaceId(spaceId);
        news1.setAuthor(JOHN);
        news1.setTitle(text);
        news1.setPublicationState("published");
        News news2 = new News();
        news2.setSpaceId(spaceId);
        news2.setAuthor(JOHN);
        news2.setTitle(text);
        news2.setPublicationState("published");
        News news3 = new News();
        news3.setSpaceId(spaceId);
        news3.setAuthor(JOHN);
        news3.setTitle(text);
        news3.setPublicationState("published");
        ArrayList<News> allNews = new ArrayList<News>();
        allNews.add(news1);
        allNews.add(news2);
        allNews.add(news3);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(TagService.class)).thenReturn((Object)this.tagService);
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId()).thenReturn((Object)1L);
        Mockito.lenient().when((Object)this.newsService.searchNews((NewsFilter)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(allNews);
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)new Space());
        Response response = this.newsRestResourcesV1.getNews(request, JOHN, spaceId, "", text, 0, 10, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        NewsEntity newsEntity = (NewsEntity)response.getEntity();
        List newsList = newsEntity.getNews();
        Assert.assertNotNull((Object)newsList);
        Assert.assertEquals((long)3L, (long)newsList.size());
        for (int i = 0; i < newsList.size(); ++i) {
            Assert.assertEquals((Object)"published", (Object)((News)newsList.get(i)).getPublicationState());
            Assert.assertEquals((Object)JOHN, (Object)((News)newsList.get(i)).getAuthor());
            Assert.assertEquals((Object)text, (Object)((News)newsList.get(i)).getTitle());
            Assert.assertEquals((Object)"4", (Object)((News)newsList.get(i)).getSpaceId());
        }
    }

    @Test
    public void shouldGetAllNewsWhenSearchingWithTagTextInTheGivenSpace() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        Mockito.lenient().when((Object)request.getLocale()).thenReturn((Object)new Locale("en"));
        String tagText = "tagText";
        String newsBody = "body including tag text #tagText";
        String spaceId = "4";
        News news1 = new News();
        news1.setSpaceId(spaceId);
        news1.setAuthor(JOHN);
        news1.setTitle("newsTitle");
        news1.setBody(newsBody);
        news1.setPublicationState("published");
        News news2 = new News();
        news2.setSpaceId(spaceId);
        news2.setAuthor(JOHN);
        news2.setTitle("newsTitle");
        news2.setBody(newsBody);
        news2.setPublicationState("published");
        ArrayList<News> allNews = new ArrayList<News>();
        allNews.add(news1);
        allNews.add(news2);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(TagService.class)).thenReturn((Object)this.tagService);
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId()).thenReturn((Object)1L);
        Mockito.lenient().when((Object)this.newsService.searchNews((NewsFilter)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(allNews);
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)new Space());
        Response response = this.newsRestResourcesV1.getNews(request, JOHN, spaceId, "", tagText, 0, 10, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        NewsEntity newsEntity = (NewsEntity)response.getEntity();
        List newsList = newsEntity.getNews();
        Assert.assertNotNull((Object)newsList);
        Assert.assertEquals((long)2L, (long)newsList.size());
        for (News newsItem : newsList) {
            Assert.assertTrue((boolean)newsItem.getBody().contains(tagText));
        }
    }

    @Test
    public void shouldGetPinnedNewsWhenSearchingWithTextInTheGivenSpaces() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        Mockito.lenient().when((Object)request.getLocale()).thenReturn((Object)new Locale("en"));
        String text = "search";
        String spacesIds = "4,1";
        News news1 = new News();
        news1.setPublished(true);
        news1.setSpaceId("4");
        news1.setAuthor(JOHN);
        news1.setTitle(text);
        news1.setPublicationState("published");
        News news2 = new News();
        news2.setPublished(true);
        news2.setSpaceId("1");
        news2.setAuthor(JOHN);
        news2.setTitle(text);
        news2.setPublicationState("published");
        News news3 = new News();
        news3.setPublished(true);
        news3.setSpaceId("4");
        news3.setAuthor(JOHN);
        news3.setTitle(text);
        news3.setPublicationState("published");
        ArrayList<News> allNews = new ArrayList<News>();
        allNews.add(news1);
        allNews.add(news2);
        allNews.add(news3);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(TagService.class)).thenReturn((Object)this.tagService);
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId()).thenReturn((Object)1L);
        Mockito.lenient().when((Object)this.newsService.searchNews((NewsFilter)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(allNews);
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)new Space());
        Response response = this.newsRestResourcesV1.getNews(request, JOHN, spacesIds, "pinned", text, 0, 10, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        NewsEntity newsEntity = (NewsEntity)response.getEntity();
        List newsList = newsEntity.getNews();
        Assert.assertNotNull((Object)newsList);
        Assert.assertEquals((long)3L, (long)newsList.size());
        for (int i = 0; i < newsList.size(); ++i) {
            Assert.assertEquals((Object)true, (Object)((News)newsList.get(i)).isPublished());
            Assert.assertEquals((Object)"published", (Object)((News)newsList.get(i)).getPublicationState());
            Assert.assertEquals((Object)JOHN, (Object)((News)newsList.get(i)).getAuthor());
            Assert.assertEquals((Object)text, (Object)((News)newsList.get(i)).getTitle());
            Assert.assertEquals((Object)true, (Object)spacesIds.contains(((News)newsList.get(i)).getSpaceId()));
        }
    }

    @Test
    public void shouldGetUnauthorizedWhenSearchingWithTextInNonMemberSpaces() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        Mockito.lenient().when((Object)request.getLocale()).thenReturn((Object)new Locale("en"));
        String text = "search";
        String spacesIds = "4,1";
        News news1 = new News();
        news1.setPublished(true);
        News news2 = new News();
        news2.setPublished(true);
        News news3 = new News();
        news3.setPublished(true);
        ArrayList<News> allNews = new ArrayList<News>();
        allNews.add(news1);
        allNews.add(news2);
        allNews.add(news3);
        Mockito.lenient().when((Object)this.newsService.getNews((NewsFilter)ArgumentMatchers.any(), (Identity)ArgumentMatchers.any())).thenReturn(allNews);
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.any())).thenReturn((Object)false);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)new Space());
        Response response = this.newsRestResourcesV1.getNews(request, JOHN, spacesIds, "pinned", text, 0, 10, false);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetMyPostedNewsWhenExists() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        Mockito.lenient().when((Object)request.getLocale()).thenReturn((Object)new Locale("en"));
        String filter = "myPosted";
        String text = "text";
        News news1 = new News();
        news1.setSpaceId("4");
        news1.setAuthor(JOHN);
        news1.setTitle(text);
        news1.setPublicationState("published");
        News news2 = new News();
        news2.setSpaceId("1");
        news2.setAuthor(JOHN);
        news2.setTitle(text);
        news2.setPublicationState("published");
        News news3 = new News();
        news3.setSpaceId("4");
        news3.setAuthor(JOHN);
        news3.setTitle(text);
        news3.setPublicationState("published");
        ArrayList<News> allNews = new ArrayList<News>();
        allNews.add(news1);
        allNews.add(news2);
        allNews.add(news3);
        Mockito.lenient().when((Object)this.newsService.getNews((NewsFilter)ArgumentMatchers.any(), (Identity)ArgumentMatchers.any())).thenReturn(allNews);
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)new Space());
        Response response = this.newsRestResourcesV1.getNews(request, JOHN, null, filter, null, 0, 10, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        NewsEntity newsEntity = (NewsEntity)response.getEntity();
        List newsList = newsEntity.getNews();
        Assert.assertNotNull((Object)newsList);
        Assert.assertEquals((long)3L, (long)newsList.size());
        for (int i = 0; i < newsList.size(); ++i) {
            Assert.assertEquals((Object)"published", (Object)((News)newsList.get(i)).getPublicationState());
            Assert.assertEquals((Object)JOHN, (Object)((News)newsList.get(i)).getAuthor());
        }
    }

    @Test
    public void shouldGetMyPostedNewsWhenFilteringWithTheGivenSpaces() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        Mockito.lenient().when((Object)request.getLocale()).thenReturn((Object)new Locale("en"));
        String filter = "myPosted";
        String text = "text";
        String spacesIds = "4,1";
        News news1 = new News();
        news1.setSpaceId("4");
        news1.setAuthor(JOHN);
        news1.setTitle(text);
        news1.setPublicationState("published");
        News news2 = new News();
        news2.setSpaceId("1");
        news2.setAuthor(JOHN);
        news2.setTitle(text);
        news2.setPublicationState("published");
        News news3 = new News();
        news3.setSpaceId("4");
        news3.setAuthor(JOHN);
        news3.setTitle(text);
        news3.setPublicationState("published");
        ArrayList<News> allNews = new ArrayList<News>();
        allNews.add(news1);
        allNews.add(news2);
        allNews.add(news3);
        Mockito.lenient().when((Object)this.newsService.getNews((NewsFilter)ArgumentMatchers.any(), (Identity)ArgumentMatchers.any())).thenReturn(allNews);
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)new Space());
        Response response = this.newsRestResourcesV1.getNews(request, JOHN, spacesIds, filter, null, 0, 10, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        NewsEntity newsEntity = (NewsEntity)response.getEntity();
        List newsList = newsEntity.getNews();
        Assert.assertNotNull((Object)newsList);
        Assert.assertEquals((long)3L, (long)newsList.size());
        for (int i = 0; i < newsList.size(); ++i) {
            Assert.assertEquals((Object)"published", (Object)((News)newsList.get(i)).getPublicationState());
            Assert.assertEquals((Object)JOHN, (Object)((News)newsList.get(i)).getAuthor());
            Assert.assertEquals((Object)true, (Object)spacesIds.contains(((News)newsList.get(i)).getSpaceId()));
        }
    }

    @Test
    public void shouldGetMyPostedNewsWhenSearchingWithTheGivenSpaces() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        Mockito.lenient().when((Object)request.getLocale()).thenReturn((Object)new Locale("en"));
        String filter = "myPosted";
        String text = "text";
        String spacesIds = "4,1";
        News news1 = new News();
        news1.setSpaceId("4");
        news1.setAuthor(JOHN);
        news1.setTitle(text);
        news1.setPublicationState("published");
        News news2 = new News();
        news2.setSpaceId("1");
        news2.setAuthor(JOHN);
        news2.setTitle(text);
        news2.setPublicationState("published");
        News news3 = new News();
        news3.setSpaceId("4");
        news3.setAuthor(JOHN);
        news3.setTitle(text);
        news3.setPublicationState("published");
        ArrayList<News> allNews = new ArrayList<News>();
        allNews.add(news1);
        allNews.add(news2);
        allNews.add(news3);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(TagService.class)).thenReturn((Object)this.tagService);
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId()).thenReturn((Object)1L);
        Mockito.lenient().when((Object)this.newsService.searchNews((NewsFilter)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(allNews);
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)new Space());
        Response response = this.newsRestResourcesV1.getNews(request, JOHN, spacesIds, filter, text, 0, 10, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        NewsEntity newsEntity = (NewsEntity)response.getEntity();
        List newsList = newsEntity.getNews();
        Assert.assertNotNull((Object)newsList);
        Assert.assertEquals((long)3L, (long)newsList.size());
        for (int i = 0; i < newsList.size(); ++i) {
            Assert.assertEquals((Object)"published", (Object)((News)newsList.get(i)).getPublicationState());
            Assert.assertEquals((Object)JOHN, (Object)((News)newsList.get(i)).getAuthor());
            Assert.assertEquals((Object)text, (Object)((News)newsList.get(i)).getTitle());
            Assert.assertEquals((Object)true, (Object)spacesIds.contains(((News)newsList.get(i)).getSpaceId()));
        }
    }

    @Test
    public void shouldGetStagedNewsWhenCurrentUserIsAuthor() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        Mockito.lenient().when((Object)request.getLocale()).thenReturn((Object)new Locale("en"));
        News news = new News();
        news.setSpaceId("1");
        news.setAuthor(JOHN);
        news.setPublicationState("staged");
        ArrayList<News> allNews = new ArrayList<News>();
        allNews.add(news);
        Mockito.lenient().when((Object)this.newsService.getNews((NewsFilter)ArgumentMatchers.any(), (Identity)ArgumentMatchers.any())).thenReturn(allNews);
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)new Space());
        Response response = this.newsRestResourcesV1.getNews(request, JOHN, null, null, null, 0, 10, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        NewsEntity newsEntity = (NewsEntity)response.getEntity();
        List newsList = newsEntity.getNews();
        Assert.assertNotNull((Object)newsList);
        Assert.assertEquals((long)1L, (long)newsList.size());
        Assert.assertEquals((Object)"staged", (Object)((News)newsList.get(0)).getPublicationState());
        Assert.assertEquals((Object)JOHN, (Object)((News)newsList.get(0)).getAuthor());
    }

    @Test
    public void shouldDeleteNews() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        News news = new News();
        news.setId("1");
        news.setCanDelete(true);
        Mockito.lenient().when((Object)this.newsService.getNewsById(ArgumentMatchers.anyString(), (Identity)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyString())).thenReturn((Object)news);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)new Space());
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.eq((Object)JOHN))).thenReturn((Object)true);
        Response response = this.newsRestResourcesV1.deleteNews(request, news.getId(), false, 0L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void getNewsIllustrationTest() throws Exception {
        Request rsRequest = (Request)Mockito.mock(Request.class);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        News news = new News();
        news.setSpaceId("1");
        news.setAuthor(JOHN);
        news.setPublished(true);
        news.setIllustrationUpdateDate(new Date());
        news.setIllustration("illustration".getBytes());
        news.setIllustrationMimeType("image");
        News news1 = new News();
        news1.setSpaceId("2");
        news1.setAuthor(JOHN);
        news1.setPublished(true);
        news1.setIllustrationUpdateDate(new Date());
        news1.setIllustration("illustration".getBytes());
        news1.setIllustrationMimeType("image/gif");
        Mockito.lenient().when((Object)this.newsService.getNewsById("1", currentIdentity, false, null)).thenReturn((Object)news);
        Mockito.lenient().when((Object)this.newsService.getNewsById("2", currentIdentity, false, null)).thenReturn((Object)news1);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Mockito.when((Object)this.thumbnailService.createCustomThumbnail((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyString())).thenReturn((Object)"illustration".getBytes());
        Response response = this.newsRestResourcesV1.getNewsIllustration(rsRequest, request, "1", 2316465L, null, "300x300");
        Response response1 = this.newsRestResourcesV1.getNewsIllustration(rsRequest, request, "2", 2316465L, null, "300x300");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        byte[] illustration = (byte[])response.getEntity();
        Assert.assertNotNull((Object)illustration);
        Assert.assertEquals((Object)"illustration", (Object)new String(illustration));
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response1.getStatus());
        byte[] illustration1 = (byte[])response1.getEntity();
        Assert.assertNotNull((Object)illustration1);
        Assert.assertEquals((Object)"illustration", (Object)new String(illustration1));
    }

    @Test
    public void shouldGetBadRequestWhenSearchingWithoutQueryAndFavorites() throws Exception {
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        HttpServletRequest httpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        String text = "text";
        News news1 = new News();
        news1.setSpaceId("4");
        news1.setAuthor(JOHN);
        news1.setTitle(text);
        news1.setPublicationState("published");
        News news2 = new News();
        news2.setSpaceId("1");
        news2.setAuthor(JOHN);
        news2.setTitle(text);
        news2.setPublicationState("published");
        News news3 = new News();
        news3.setSpaceId("4");
        news3.setAuthor(JOHN);
        news3.setTitle(text);
        news3.setPublicationState("published");
        ArrayList<News> allNews = new ArrayList<News>();
        allNews.add(news1);
        allNews.add(news2);
        allNews.add(news3);
        Mockito.lenient().when((Object)this.newsService.searchNews((NewsFilter)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(allNews);
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)new Space());
        Response response = this.newsRestResourcesV1.search(uriInfo, httpServletRequest, "", "", 0, null, 10, false);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetBadRequestWhenSearchingWithNegativeOffset() throws Exception {
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        HttpServletRequest httpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        String text = "text";
        News news1 = new News();
        news1.setSpaceId("4");
        news1.setAuthor(JOHN);
        news1.setTitle(text);
        news1.setPublicationState("published");
        News news2 = new News();
        news2.setSpaceId("1");
        news2.setAuthor(JOHN);
        news2.setTitle(text);
        news2.setPublicationState("published");
        News news3 = new News();
        news3.setSpaceId("4");
        news3.setAuthor(JOHN);
        news3.setTitle(text);
        news3.setPublicationState("published");
        ArrayList<News> allNews = new ArrayList<News>();
        allNews.add(news1);
        allNews.add(news2);
        allNews.add(news3);
        Mockito.lenient().when((Object)this.newsService.searchNews((NewsFilter)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(allNews);
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)new Space());
        this.setCurrentUser(JOHN);
        Response response = this.newsRestResourcesV1.search(uriInfo, httpServletRequest, "query", "", -1, null, 10, false);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetBadRequestWhenSearchingWithNegativeLimit() throws Exception {
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        HttpServletRequest httpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        String text = "text";
        News news1 = new News();
        news1.setSpaceId("4");
        news1.setAuthor(JOHN);
        news1.setTitle(text);
        news1.setPublicationState("published");
        News news2 = new News();
        news2.setSpaceId("1");
        news2.setAuthor(JOHN);
        news2.setTitle(text);
        news2.setPublicationState("published");
        News news3 = new News();
        news3.setSpaceId("4");
        news3.setAuthor(JOHN);
        news3.setTitle(text);
        news3.setPublicationState("published");
        ArrayList<News> allNews = new ArrayList<News>();
        allNews.add(news1);
        allNews.add(news2);
        allNews.add(news3);
        Mockito.lenient().when((Object)this.newsService.searchNews((NewsFilter)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(allNews);
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)new Space());
        this.setCurrentUser(JOHN);
        Response response = this.newsRestResourcesV1.search(uriInfo, httpServletRequest, "query", "", 0, null, -1, false);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGetnewsListWhenSearchingWithQuery() throws Exception {
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        HttpServletRequest httpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        String text = "text";
        String spacesIds = "4,1";
        News news1 = new News();
        news1.setSpaceId("4");
        news1.setAuthor(JOHN);
        news1.setTitle(text);
        news1.setPublicationState("published");
        News news2 = new News();
        news2.setSpaceId("1");
        news2.setAuthor(JOHN);
        news2.setTitle(text);
        news2.setPublicationState("published");
        News news3 = new News();
        news3.setSpaceId("4");
        news3.setAuthor(JOHN);
        news3.setTitle(text);
        news3.setPublicationState("published");
        ArrayList<News> allNews = new ArrayList<News>();
        allNews.add(news1);
        allNews.add(news2);
        allNews.add(news3);
        Mockito.lenient().when((Object)this.newsService.searchNews((NewsFilter)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(allNews);
        Mockito.lenient().when((Object)this.spaceService.isMember((Space)ArgumentMatchers.any(Space.class), (String)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.spaceService.getSpaceById(ArgumentMatchers.anyString())).thenReturn((Object)new Space());
        this.setCurrentUser(JOHN);
        Response response = this.newsRestResourcesV1.search(uriInfo, httpServletRequest, text, "", 0, null, 10, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        List newsList = (List)response.getEntity();
        Assert.assertNotNull((Object)newsList);
        Assert.assertEquals((long)0L, (long)newsList.size());
    }

    private void setCurrentUser(String name) {
        ConversationState.setCurrent((ConversationState)new ConversationState(new Identity(name)));
    }

    @Test
    public void testMarkAsRead() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.lenient().when((Object)request.getRemoteUser()).thenReturn((Object)JOHN);
        Identity currentIdentity = new Identity(JOHN);
        ConversationState.setCurrent((ConversationState)new ConversationState(currentIdentity));
        News news = new News();
        news.setId("1");
        Mockito.when((Object)this.newsService.getNewsById("1", currentIdentity, false)).thenReturn((Object)news);
        ((NewsService)Mockito.doNothing().when((Object)this.newsService)).markAsRead(news, JOHN);
        Response response = this.newsRestResourcesV1.markNewsAsRead(request, "1");
        ((NewsService)Mockito.verify((Object)this.newsService, (VerificationMode)Mockito.times((int)1))).markAsRead(news, JOHN);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }
}

