/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui.popup;

import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.wiki.webui.UIWikiContentDisplay;
import org.exoplatform.wiki.webui.UIWikiMaskWorkspace;
import org.exoplatform.wiki.webui.UIWikiPortlet;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/templates/wiki/webui/popup/UIWikiPagePreview.gtmpl", events={@EventConfig(listeners={CloseActionListener.class})})
public class UIWikiPagePreview
extends UIContainer {
    public static final String[] ACTIONS = new String[]{"Close"};
    public static final String PREVIEW_DISPLAY = "UIPreviewContentDisplay";
    private String pageTitle;

    public UIWikiPagePreview() throws Exception {
        this.addChild(UIWikiContentDisplay.class, null, PREVIEW_DISPLAY);
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public void setContent(String contentHTML) {
        UIWikiContentDisplay contentDisplay = (UIWikiContentDisplay)this.getChildById(PREVIEW_DISPLAY);
        contentDisplay.setHtmlOutput(contentHTML);
    }

    public void renderWikiMarkup(String markup, String syntaxId) throws Exception {
        UIWikiContentDisplay contentDisplay = (UIWikiContentDisplay)this.getChildById(PREVIEW_DISPLAY);
        contentDisplay.setHtmlOutput(markup);
    }

    public void setPageTitle(String title) {
        this.pageTitle = title;
    }

    public String getPageTitle() {
        return this.pageTitle;
    }

    public static class CloseActionListener
    extends EventListener<UIWikiPagePreview> {
        public void execute(Event<UIWikiPagePreview> event) throws Exception {
            UIWikiPortlet wikiPortlet = (UIWikiPortlet)((UIWikiPagePreview)((Object)event.getSource())).getAncestorOfType(UIWikiPortlet.class);
            UIWikiMaskWorkspace uiMaskWS = (UIWikiMaskWorkspace)wikiPortlet.getChild(UIWikiMaskWorkspace.class);
            if (uiMaskWS == null || !uiMaskWS.isShow()) {
                return;
            }
            uiMaskWS.setUIComponent(null);
            uiMaskWS.setWindowSize(-1, -1);
            Util.getPortalRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
        }
    }
}

