/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.common.service.HTMLUploadImageProcessor;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.mow.api.Attachment;
import org.exoplatform.wiki.mow.api.DraftPage;
import org.exoplatform.wiki.mow.api.ExportList;
import org.exoplatform.wiki.mow.api.ImportList;
import org.exoplatform.wiki.mow.api.NoteToExport;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.PageHistory;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.api.WikiType;
import org.exoplatform.wiki.rendering.cache.AttachmentCountData;
import org.exoplatform.wiki.rendering.cache.MarkupData;
import org.exoplatform.wiki.rendering.cache.MarkupKey;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.BreadcrumbData;
import org.exoplatform.wiki.service.DataStorage;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.listener.PageWikiListener;
import org.exoplatform.wiki.utils.Utils;
import org.gatein.api.EntityNotFoundException;

public class NoteServiceImpl
implements NoteService {
    public static final String CACHE_NAME = "wiki.PageRenderingCache";
    public static final String ATT_CACHE_NAME = "wiki.PageAttachmentCache";
    private static final String UNTITLED_PREFIX = "Untitled_";
    private static final String IMAGE_URL_REPLACEMENT_PREFIX = "//-";
    private static final String IMAGE_URL_REPLACEMENT_SUFFIX = "-//";
    private static final String EXPORT_ZIP_NAME = "ziped.zip";
    private static final String TEMP_DIRECTORY_PATH = "java.io.tmpdir";
    private static final Log log = ExoLogger.getLogger(NoteServiceImpl.class);
    private final ConfigurationManager configManager;
    private final OrganizationService orgService;
    private final WikiService wikiService;
    private final UserACL userACL;
    private final HTMLUploadImageProcessor htmlUploadImageProcessor;
    private final DataStorage dataStorage;
    private final ExoCache<Integer, MarkupData> renderingCache;
    private final ExoCache<Integer, AttachmentCountData> attachmentCountCache;
    private final Map<WikiPageParams, List<WikiPageParams>> pageLinksMap = new ConcurrentHashMap<WikiPageParams, List<WikiPageParams>>();
    private final IdentityManager identityManager;
    private final SpaceService spaceService;

    public NoteServiceImpl(ConfigurationManager configManager, UserACL userACL, DataStorage dataStorage, CacheService cacheService, OrganizationService orgService, WikiService wikiService, IdentityManager identityManager, HTMLUploadImageProcessor htmlUploadImageProcessor, SpaceService spaceService) {
        this.configManager = configManager;
        this.userACL = userACL;
        this.dataStorage = dataStorage;
        this.orgService = orgService;
        this.wikiService = wikiService;
        this.identityManager = identityManager;
        this.htmlUploadImageProcessor = htmlUploadImageProcessor;
        this.renderingCache = cacheService.getCacheInstance(CACHE_NAME);
        this.attachmentCountCache = cacheService.getCacheInstance(ATT_CACHE_NAME);
        this.spaceService = spaceService;
    }

    public static File zipFiles(String zipFileName, List<File> addToZip) throws IOException {
        String zipPath = System.getProperty(TEMP_DIRECTORY_PATH) + File.separator + zipFileName;
        NoteServiceImpl.cleanUp(new File(zipPath));
        try (FileOutputStream fos = new FileOutputStream(zipPath);
             ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(fos));){
            zos.setLevel(9);
            for (File file : addToZip) {
                if (!file.exists()) continue;
                try (FileInputStream fis = new FileInputStream(file);){
                    ZipEntry entry = new ZipEntry(file.getName());
                    zos.putNextEntry(entry);
                    int c = fis.read();
                    while (c != -1) {
                        zos.write(c);
                        c = fis.read();
                    }
                    zos.flush();
                }
            }
        }
        File zip = new File(zipPath);
        if (!zip.exists()) {
            throw new FileNotFoundException("The created zip file could not be found");
        }
        return zip;
    }

    public ExoCache<Integer, MarkupData> getRenderingCache() {
        return this.renderingCache;
    }

    public Map<WikiPageParams, List<WikiPageParams>> getPageLinksMap() {
        return this.pageLinksMap;
    }

    @Override
    public Page createNote(Wiki noteBook, String parentNoteName, Page note, Identity userIdentity) throws WikiException, IllegalAccessException {
        String pageName = TitleResolver.getId(note.getTitle(), false);
        note.setName(pageName);
        if (this.isExisting(noteBook.getType(), noteBook.getOwner(), pageName)) {
            throw new WikiException("Page " + noteBook.getType() + ":" + noteBook.getOwner() + ":" + pageName + " already exists, cannot create it.");
        }
        Page parentPage = this.getNoteOfNoteBookByName(noteBook.getType(), noteBook.getOwner(), parentNoteName);
        if (parentPage != null) {
            note.setOwner(userIdentity.getUserId());
            try {
                if (StringUtils.equalsIgnoreCase((String)noteBook.getType(), (String)WikiType.GROUP.name())) {
                    note.setContent(this.htmlUploadImageProcessor.processSpaceImages(note.getContent(), noteBook.getOwner(), "Notes"));
                }
                if (StringUtils.equalsIgnoreCase((String)noteBook.getType(), (String)WikiType.USER.name())) {
                    note.setContent(this.htmlUploadImageProcessor.processUserImages(note.getContent(), noteBook.getOwner(), "Notes"));
                }
            }
            catch (Exception e) {
                log.warn((Object)"can't process note's images");
            }
            Space space = this.spaceService.getSpaceByGroupId(note.getWikiOwner());
            Page createdPage = this.createNote(noteBook, parentPage, note);
            createdPage.setCanManage(this.canManageNotes(userIdentity.getUserId(), space, note));
            createdPage.setCanImport(this.canImportNotes(userIdentity.getUserId(), space, note));
            createdPage.setCanView(this.canViewNotes(userIdentity.getUserId(), space, note));
            createdPage.setToBePublished(note.isToBePublished());
            createdPage.setAppName(note.getAppName());
            createdPage.setUrl(Utils.getPageUrl(createdPage));
            this.invalidateCache(parentPage);
            this.invalidateCache(note);
            this.postAddPage(noteBook.getType(), noteBook.getOwner(), note.getName(), createdPage);
            return createdPage;
        }
        throw new EntityNotFoundException("Parent note not foond");
    }

    @Override
    public Page createNote(Wiki noteBook, Page parentPage, Page note) throws WikiException {
        return this.dataStorage.createPage(noteBook, parentPage, note);
    }

    @Override
    public Page updateNote(Page note) throws WikiException {
        return this.dataStorage.updatePage(note);
    }

    @Override
    public Page updateNote(Page note, PageUpdateType type, Identity userIdentity) throws WikiException, IllegalAccessException, EntityNotFoundException {
        Page note_ = this.getNoteById(note.getId());
        if (note_ == null) {
            throw new EntityNotFoundException("Note to update not found");
        }
        if (note_ != null) {
            Space space = this.spaceService.getSpaceByGroupId(note.getWikiOwner());
            if (!this.canManageNotes(userIdentity.getUserId(), space, note_)) {
                throw new IllegalAccessException("User does not have edit the note.");
            }
        }
        WikiService wikiService = (WikiService)PortalContainer.getComponent(WikiService.class);
        ListenerService listenerService = (ListenerService)PortalContainer.getComponent(ListenerService.class);
        if (PageUpdateType.EDIT_PAGE_CONTENT.equals((Object)type) || PageUpdateType.EDIT_PAGE_CONTENT_AND_TITLE.equals((Object)type)) {
            note.setUpdatedDate(Calendar.getInstance().getTime());
        }
        try {
            if (note.getWikiType().toUpperCase().equals(WikiType.GROUP.name())) {
                note.setContent(this.htmlUploadImageProcessor.processSpaceImages(note.getContent(), note.getWikiOwner(), "Notes"));
            }
            if (note.getWikiType().toUpperCase().equals(WikiType.USER.name())) {
                note.setContent(this.htmlUploadImageProcessor.processUserImages(note.getContent(), note.getWikiOwner(), "Notes"));
            }
        }
        catch (Exception e) {
            log.warn((Object)"can't process note's images");
        }
        this.updateNote(note);
        this.invalidateCache(note);
        if (PageUpdateType.EDIT_PAGE_CONTENT.equals((Object)type) || PageUpdateType.EDIT_PAGE_CONTENT_AND_TITLE.equals((Object)type)) {
            try {
                listenerService.broadcast("exo.wiki.edit", (Object)wikiService, (Object)note);
            }
            catch (Exception e) {
                log.error((Object)"Error while broadcasting wiki edition event", (Throwable)e);
            }
        }
        Page updatedPage = this.getNoteById(note.getId());
        updatedPage.setUrl(Utils.getPageUrl(updatedPage));
        updatedPage.setToBePublished(note.isToBePublished());
        updatedPage.setCanManage(note.isCanManage());
        updatedPage.setCanImport(note.isCanImport());
        updatedPage.setCanView(note.isCanView());
        updatedPage.setAppName(note.getAppName());
        Map<String, List<MetadataItem>> metadata = this.retrieveMetadataItems(note.getId(), userIdentity.getUserId());
        updatedPage.setMetadatas(metadata);
        this.postUpdatePage(updatedPage.getWikiType(), updatedPage.getWikiOwner(), updatedPage.getName(), updatedPage, type);
        return updatedPage;
    }

    @Override
    public boolean deleteNote(String noteType, String noteOwner, String noteName) throws WikiException {
        if ("Home".equals(noteName) || noteName == null) {
            return false;
        }
        try {
            this.dataStorage.deletePage(noteType, noteOwner, noteName);
        }
        catch (WikiException e) {
            log.error((Object)("Can't delete note '" + noteName + "' "), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteNote(String noteType, String noteOwner, String noteName, Identity userIdentity) throws WikiException, IllegalAccessException, EntityNotFoundException {
        block9: {
            if ("Home".equals(noteName) || noteName == null) {
                return false;
            }
            try {
                Page note = this.getNoteOfNoteBookByName(noteType, noteOwner, noteName);
                if (note == null) {
                    log.error((Object)("Can't delete note '" + noteName + "'. This note does not exist."));
                    throw new EntityNotFoundException("Note to delete not found");
                }
                Space space = this.spaceService.getSpaceByGroupId(note.getWikiOwner());
                if (note != null) {
                    if (!this.canManageNotes(userIdentity.getUserId(), space, note)) {
                        log.error((Object)("Can't delete note '" + noteName + "'. does not have edit permission on it."));
                        throw new IllegalAccessException("User does not have edit permissions on the note.");
                    }
                    this.invalidateCachesOfPageTree(note, userIdentity.getUserId());
                    this.invalidateAttachmentCache(note);
                    ArrayList<Page> allChrildrenPages = new ArrayList<Page>();
                    LinkedList<Page> queue = new LinkedList<Page>();
                    queue.add(note);
                    while (!queue.isEmpty()) {
                        Page tempPage = (Page)queue.poll();
                        List<Page> childrenPages = this.getChildrenNoteOf(tempPage, userIdentity.getUserId(), false, false);
                        for (Page childPage : childrenPages) {
                            queue.add(childPage);
                            allChrildrenPages.add(childPage);
                        }
                    }
                    this.deleteNote(noteType, noteOwner, noteName);
                    this.postDeletePage(noteType, noteOwner, noteName, note);
                    for (Page childNote : allChrildrenPages) {
                        this.postDeletePage(childNote.getWikiType(), childNote.getWikiOwner(), childNote.getName(), childNote);
                    }
                    break block9;
                }
                log.error((Object)("Can't delete note '" + noteName + "'. This note does not exist."));
                return false;
            }
            catch (WikiException e) {
                log.error((Object)("Can't delete note '" + noteName + "' "), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean renameNote(String noteType, String noteOwner, String noteName, String newName, String newTitle) throws WikiException {
        if ("Home".equals(noteName) || noteName == null) {
            return false;
        }
        if (!noteName.equals(newName) && this.isExisting(noteType, noteOwner, newName)) {
            throw new WikiException("Note " + noteType + ":" + noteOwner + ":" + newName + " already exists, cannot rename it.");
        }
        this.dataStorage.renamePage(noteType, noteOwner, noteName, newName, newTitle);
        Page page = new Page(noteName);
        page.setWikiType(noteType);
        page.setWikiOwner(noteOwner);
        this.invalidateCache(page);
        return true;
    }

    @Override
    public void moveNote(WikiPageParams currentLocationParams, WikiPageParams newLocationParams) throws WikiException {
        this.dataStorage.movePage(currentLocationParams, newLocationParams);
    }

    @Override
    public boolean moveNote(WikiPageParams currentLocationParams, WikiPageParams newLocationParams, Identity userIdentity) throws WikiException, IllegalAccessException, EntityNotFoundException {
        try {
            Page moveNote = this.getNoteOfNoteBookByName(currentLocationParams.getType(), currentLocationParams.getOwner(), currentLocationParams.getPageName());
            if (moveNote == null) {
                throw new EntityNotFoundException("Note to move not found");
            }
            if (moveNote != null) {
                Space space = this.spaceService.getSpaceByGroupId(moveNote.getWikiOwner());
                if (!this.canManageNotes(userIdentity.getUserId(), space, moveNote)) {
                    throw new IllegalAccessException("User does not have edit the note.");
                }
            }
            this.moveNote(currentLocationParams, newLocationParams);
            Page note = new Page(currentLocationParams.getPageName());
            note.setWikiType(currentLocationParams.getType());
            note.setWikiOwner(currentLocationParams.getOwner());
            this.invalidateCache(note);
            this.invalidateAttachmentCache(note);
            this.postUpdatePage(newLocationParams.getType(), newLocationParams.getOwner(), moveNote.getName(), moveNote, PageUpdateType.MOVE_PAGE);
        }
        catch (WikiException e) {
            log.error((Object)("Can't move note '" + currentLocationParams.getPageName() + "' "), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public Page getNoteOfNoteBookByName(String noteType, String noteOwner, String noteName) throws WikiException {
        Page page = null;
        page = this.dataStorage.getPageOfWikiByName(noteType, noteOwner, noteName);
        this.checkToRemoveDomainInUrl(page);
        return page;
    }

    @Override
    public Page getNoteOfNoteBookByName(String noteType, String noteOwner, String noteName, Identity userIdentity, String source) throws IllegalAccessException, WikiException {
        Page page = this.getNoteOfNoteBookByName(noteType, noteOwner, noteName, userIdentity);
        if (StringUtils.isNotEmpty((String)source)) {
            if (source.equals("tree")) {
                this.postOpenByTree(noteType, noteOwner, noteName, page);
            }
            if (source.equals("breadCrumb")) {
                this.postOpenByBreadCrumb(noteType, noteOwner, noteName, page);
            }
        }
        return page;
    }

    @Override
    public Page getNoteOfNoteBookByName(String noteType, String noteOwner, String noteName, Identity userIdentity) throws IllegalAccessException, WikiException {
        Page page = null;
        page = this.getNoteOfNoteBookByName(noteType, noteOwner, noteName);
        if (page == null) {
            throw new EntityNotFoundException("page not found");
        }
        if (page != null) {
            Space space = this.spaceService.getSpaceByGroupId(page.getWikiOwner());
            if (!this.canViewNotes(userIdentity.getUserId(), space, page)) {
                throw new IllegalAccessException("User does not have view the note.");
            }
            page.setCanView(true);
            page.setCanManage(this.canManageNotes(userIdentity.getUserId(), space, page));
            page.setCanImport(this.canImportNotes(userIdentity.getUserId(), space, page));
            Map<String, List<MetadataItem>> metadata = this.retrieveMetadataItems(page.getId(), userIdentity.getUserId());
            page.setMetadatas(metadata);
        }
        return page;
    }

    @Override
    public Page getNoteById(String id) throws WikiException {
        if (id == null) {
            return null;
        }
        return this.dataStorage.getPageById(id);
    }

    @Override
    public DraftPage getDraftNoteById(String id, String userId) throws WikiException, IllegalAccessException {
        if (id == null) {
            return null;
        }
        DraftPage draftPage = this.dataStorage.getDraftPageById(id);
        if (draftPage != null) {
            Space space = this.spaceService.getSpaceByGroupId(draftPage.getWikiOwner());
            if (!this.canViewNotes(userId, space, draftPage)) {
                throw new IllegalAccessException("User does not have the right view the note.");
            }
            draftPage.setCanView(true);
            draftPage.setCanManage(this.canManageNotes(userId, space, draftPage));
            draftPage.setCanImport(this.canImportNotes(userId, space, draftPage));
            String authorFullName = this.identityManager.getOrCreateIdentity("organization", draftPage.getAuthor()).getProfile().getFullName();
            draftPage.setAuthorFullName(authorFullName);
        }
        return draftPage;
    }

    @Override
    public DraftPage getLatestDraftOfPage(Page targetPage, String username) throws WikiException {
        if (targetPage == null || StringUtils.isEmpty((String)username)) {
            return null;
        }
        return this.dataStorage.getLatestDraftOfPage(targetPage, username);
    }

    @Override
    public Page getNoteById(String id, Identity userIdentity) throws IllegalAccessException, WikiException {
        if (id == null) {
            return null;
        }
        Page page = null;
        page = this.getNoteById(id);
        if (page != null) {
            Space space = this.spaceService.getSpaceByGroupId(page.getWikiOwner());
            if (!this.canViewNotes(userIdentity.getUserId(), space, page)) {
                throw new IllegalAccessException("User does not have view the note.");
            }
            page.setCanView(true);
            page.setCanManage(this.canManageNotes(userIdentity.getUserId(), space, page));
            page.setCanImport(this.canImportNotes(userIdentity.getUserId(), space, page));
        }
        return page;
    }

    @Override
    public Page getNoteById(String id, Identity userIdentity, String source) throws IllegalAccessException, WikiException {
        if (id == null) {
            return null;
        }
        Page page = this.getNoteById(id);
        if (page != null) {
            Space space = this.spaceService.getSpaceByGroupId(page.getWikiOwner());
            if (!this.canViewNotes(userIdentity.getUserId(), space, page)) {
                throw new IllegalAccessException("User does not have view the note.");
            }
            page.setCanView(true);
            page.setCanManage(this.canManageNotes(userIdentity.getUserId(), space, page));
            page.setCanImport(this.canImportNotes(userIdentity.getUserId(), space, page));
            Map<String, List<MetadataItem>> metadata = this.retrieveMetadataItems(id, userIdentity.getUserId());
            page.setMetadatas(metadata);
            if (StringUtils.isNotEmpty((String)source)) {
                if (source.equals("tree")) {
                    this.postOpenByTree(page.getWikiType(), page.getWikiOwner(), page.getName(), page);
                }
                if (source.equals("breadCrumb")) {
                    this.postOpenByBreadCrumb(page.getWikiType(), page.getWikiOwner(), page.getName(), page);
                }
            }
        }
        return page;
    }

    @Override
    public Page getParentNoteOf(Page note) throws WikiException {
        return this.dataStorage.getParentPageOf(note);
    }

    @Override
    public NoteToExport getParentNoteOf(NoteToExport note) throws WikiException {
        Page page = new Page();
        page.setId(note.getId());
        page.setName(note.getName());
        page.setWikiId(note.getWikiId());
        page.setWikiOwner(note.getWikiOwner());
        page.setWikiType(note.getWikiType());
        Page parent = this.getParentNoteOf(page);
        if (parent == null) {
            return null;
        }
        return new NoteToExport(parent.getId(), parent.getName(), parent.getOwner(), parent.getAuthor(), parent.getContent(), parent.getSyntax(), parent.getTitle(), parent.getComment(), parent.getWikiId(), parent.getWikiType(), parent.getWikiOwner());
    }

    @Override
    public List<Page> getChildrenNoteOf(Page note, String userId, boolean withDrafts, boolean withChild) throws WikiException {
        List<Page> pages = this.dataStorage.getChildrenPageOf(note, userId, withDrafts);
        if (withChild) {
            for (Page page : pages) {
                long pageId = Long.parseLong(page.getId());
                page.setHasChild(this.dataStorage.hasChildren(pageId));
            }
        }
        return pages;
    }

    @Override
    public List<NoteToExport> getChildrenNoteOf(NoteToExport note) throws WikiException {
        Page page = new Page();
        page.setId(note.getId());
        page.setName(note.getName());
        page.setWikiId(note.getWikiId());
        page.setWikiOwner(note.getWikiOwner());
        page.setWikiType(note.getWikiType());
        List<Page> pages = this.getChildrenNoteOf(page, ConversationState.getCurrent().getIdentity().getUserId(), false, false);
        ArrayList<NoteToExport> children = new ArrayList<NoteToExport>();
        for (Page child : pages) {
            if (child == null) continue;
            children.add(new NoteToExport(child.getId(), child.getName(), child.getOwner(), child.getAuthor(), child.getContent(), child.getSyntax(), child.getTitle(), child.getComment(), child.getWikiId(), child.getWikiType(), child.getWikiOwner()));
        }
        return children;
    }

    @Override
    public List<BreadcrumbData> getBreadCrumb(String noteType, String noteOwner, String noteName, boolean isDraftNote) throws WikiException {
        return this.getBreadCrumb(null, noteType, noteOwner, noteName, isDraftNote);
    }

    @Override
    public List<Page> getDuplicateNotes(Page parentNote, Wiki targetNoteBook, List<Page> resultList, String userId) throws WikiException {
        if (resultList == null) {
            resultList = new ArrayList<Page>();
        }
        if (resultList.size() > 6) {
            return resultList;
        }
        if (this.isExisting(targetNoteBook.getType(), targetNoteBook.getOwner(), parentNote.getName())) {
            resultList.add(parentNote);
        }
        List<Page> childrenNotes = this.getChildrenNoteOf(parentNote, userId, false, false);
        for (Page note : childrenNotes) {
            this.getDuplicateNotes(note, targetNoteBook, resultList, userId);
        }
        return resultList;
    }

    @Override
    public void removeDraftOfNote(WikiPageParams param) throws WikiException {
        Page page = this.getNoteOfNoteBookByName(param.getType(), param.getOwner(), param.getPageName());
        this.dataStorage.deleteDraftOfPage(page, Utils.getCurrentUser());
    }

    @Override
    public void removeDraft(String draftName) throws WikiException {
        this.dataStorage.deleteDraftByName(draftName, Utils.getCurrentUser());
    }

    @Override
    public List<PageHistory> getVersionsHistoryOfNote(Page note, String userName) throws WikiException {
        List<PageHistory> versionsHistory = this.dataStorage.getHistoryOfPage(note);
        if (versionsHistory == null || versionsHistory.isEmpty()) {
            this.dataStorage.addPageVersion(note, userName);
            versionsHistory = this.dataStorage.getHistoryOfPage(note);
        }
        for (PageHistory version : versionsHistory) {
            if (version.getAuthor() == null) continue;
            org.exoplatform.social.core.identity.model.Identity authorIdentity = this.identityManager.getOrCreateIdentity("organization", version.getAuthor());
            version.setAuthorFullName(authorIdentity.getProfile().getFullName());
        }
        return versionsHistory;
    }

    @Override
    public void createVersionOfNote(Page note, String userName) throws WikiException {
        this.dataStorage.addPageVersion(note, userName);
    }

    @Override
    public void restoreVersionOfNote(String versionName, Page note, String userName) throws WikiException {
        this.dataStorage.restoreVersionOfPage(versionName, note);
        this.createVersionOfNote(note, userName);
        this.invalidateCache(note);
    }

    @Override
    public List<String> getPreviousNamesOfNote(Page note) throws WikiException {
        return this.dataStorage.getPreviousNamesOfPage(note);
    }

    @Override
    public List<Page> getNotesOfWiki(String noteType, String noteOwner) {
        return this.dataStorage.getPagesOfWiki(noteType, noteOwner);
    }

    @Override
    public boolean isExisting(String noteBookType, String noteBookOwner, String noteId) throws WikiException {
        return this.getNoteByRootPermission(noteBookType, noteBookOwner, noteId) != null;
    }

    @Override
    public Page getNoteByRootPermission(String noteBookType, String noteBookOwner, String noteId) throws WikiException {
        return this.dataStorage.getPageOfWikiByName(noteBookType, noteBookOwner, noteId);
    }

    @Override
    public DraftPage updateDraftForExistPage(DraftPage draftNoteToUpdate, Page targetPage, String revision, long clientTime, String username) throws WikiException {
        String draftSuffix = this.getDraftNameSuffix(clientTime);
        DraftPage newDraftPage = new DraftPage();
        newDraftPage.setId(draftNoteToUpdate.getId());
        newDraftPage.setName(targetPage.getName() + "_" + draftSuffix);
        newDraftPage.setNewPage(false);
        newDraftPage.setTitle(draftNoteToUpdate.getTitle());
        newDraftPage.setTargetPageId(draftNoteToUpdate.getTargetPageId());
        newDraftPage.setParentPageId(draftNoteToUpdate.getParentPageId());
        newDraftPage.setContent(draftNoteToUpdate.getContent());
        newDraftPage.setSyntax(draftNoteToUpdate.getSyntax());
        newDraftPage.setCreatedDate(new Date(clientTime));
        newDraftPage.setUpdatedDate(new Date(clientTime));
        if (StringUtils.isEmpty((String)revision)) {
            List<PageHistory> versions = this.getVersionsHistoryOfNote(targetPage, username);
            if (versions != null && !versions.isEmpty()) {
                newDraftPage.setTargetPageRevision(String.valueOf(versions.get(0).getVersionNumber()));
            } else {
                newDraftPage.setTargetPageRevision("1");
            }
        } else {
            newDraftPage.setTargetPageRevision(revision);
        }
        newDraftPage = this.dataStorage.updateDraftPageForUser(newDraftPage, Utils.getCurrentUser());
        return newDraftPage;
    }

    @Override
    public DraftPage updateDraftForNewPage(DraftPage draftNoteToUpdate, long clientTime) throws WikiException {
        String draftSuffix = this.getDraftNameSuffix(clientTime);
        DraftPage newDraftPage = new DraftPage();
        newDraftPage.setId(draftNoteToUpdate.getId());
        newDraftPage.setName(UNTITLED_PREFIX + draftSuffix);
        newDraftPage.setNewPage(true);
        newDraftPage.setTitle(draftNoteToUpdate.getTitle());
        newDraftPage.setTargetPageId(draftNoteToUpdate.getTargetPageId());
        newDraftPage.setParentPageId(draftNoteToUpdate.getParentPageId());
        newDraftPage.setTargetPageRevision("1");
        newDraftPage.setContent(draftNoteToUpdate.getContent());
        newDraftPage.setSyntax(draftNoteToUpdate.getSyntax());
        newDraftPage.setCreatedDate(new Date(clientTime));
        newDraftPage.setUpdatedDate(new Date(clientTime));
        newDraftPage = this.dataStorage.updateDraftPageForUser(newDraftPage, Utils.getCurrentUser());
        return newDraftPage;
    }

    @Override
    public DraftPage createDraftForExistPage(DraftPage draftPage, Page targetPage, String revision, long clientTime, String username) throws WikiException {
        String draftSuffix = this.getDraftNameSuffix(clientTime);
        DraftPage newDraftPage = new DraftPage();
        newDraftPage.setName(targetPage.getName() + "_" + draftSuffix);
        newDraftPage.setNewPage(false);
        newDraftPage.setTitle(draftPage.getTitle());
        newDraftPage.setTargetPageId(targetPage.getId());
        newDraftPage.setParentPageId(draftPage.getParentPageId());
        newDraftPage.setContent(draftPage.getContent());
        newDraftPage.setSyntax(draftPage.getSyntax());
        newDraftPage.setCreatedDate(new Date(clientTime));
        newDraftPage.setUpdatedDate(new Date(clientTime));
        if (StringUtils.isEmpty((String)revision)) {
            List<PageHistory> versions = this.getVersionsHistoryOfNote(targetPage, username);
            if (versions != null && !versions.isEmpty()) {
                newDraftPage.setTargetPageRevision(String.valueOf(versions.get(0).getVersionNumber()));
            } else {
                newDraftPage.setTargetPageRevision("1");
            }
        } else {
            newDraftPage.setTargetPageRevision(revision);
        }
        newDraftPage = this.dataStorage.createDraftPageForUser(newDraftPage, Utils.getCurrentUser());
        return newDraftPage;
    }

    @Override
    public DraftPage createDraftForNewPage(DraftPage draftPage, long clientTime) throws WikiException {
        String draftSuffix = this.getDraftNameSuffix(clientTime);
        DraftPage newDraftPage = new DraftPage();
        newDraftPage.setName(UNTITLED_PREFIX + draftSuffix);
        newDraftPage.setNewPage(true);
        newDraftPage.setTitle(draftPage.getTitle());
        newDraftPage.setTargetPageId(draftPage.getTargetPageId());
        newDraftPage.setTargetPageRevision("1");
        newDraftPage.setParentPageId(draftPage.getParentPageId());
        newDraftPage.setContent(draftPage.getContent());
        newDraftPage.setSyntax(draftPage.getSyntax());
        newDraftPage.setCreatedDate(new Date(clientTime));
        newDraftPage.setUpdatedDate(new Date(clientTime));
        newDraftPage = this.dataStorage.createDraftPageForUser(newDraftPage, Utils.getCurrentUser());
        return newDraftPage;
    }

    protected void invalidateCache(Page page) {
        WikiPageParams params = new WikiPageParams(page.getWikiType(), page.getWikiOwner(), page.getName());
        List<WikiPageParams> linkedPages = this.pageLinksMap.get(params);
        linkedPages = linkedPages == null ? new ArrayList<WikiPageParams>() : new ArrayList<WikiPageParams>(linkedPages);
        linkedPages.add(params);
        for (WikiPageParams wikiPageParams : linkedPages) {
            try {
                MarkupKey key = new MarkupKey(wikiPageParams, false);
                this.renderingCache.remove((Serializable)new Integer(key.hashCode()));
                key.setSupportSectionEdit(true);
                this.renderingCache.remove((Serializable)new Integer(key.hashCode()));
                key = new MarkupKey(wikiPageParams, false);
                this.renderingCache.remove((Serializable)new Integer(key.hashCode()));
                key.setSupportSectionEdit(true);
                this.renderingCache.remove((Serializable)new Integer(key.hashCode()));
                key = new MarkupKey(wikiPageParams, false);
                this.renderingCache.remove((Serializable)new Integer(key.hashCode()));
                key.setSupportSectionEdit(true);
                this.renderingCache.remove((Serializable)new Integer(key.hashCode()));
            }
            catch (Exception e) {
                log.warn((Object)String.format("Failed to invalidate cache of page [%s:%s:%s]", wikiPageParams.getType(), wikiPageParams.getOwner(), wikiPageParams.getPageName()));
            }
        }
    }

    protected void invalidateCachesOfPageTree(Page note, String userId) throws WikiException {
        LinkedList<Page> queue = new LinkedList<Page>();
        queue.add(note);
        while (!queue.isEmpty()) {
            Page currentPage = (Page)queue.poll();
            this.invalidateCache(currentPage);
            List<Page> childrenPages = this.getChildrenNoteOf(currentPage, userId, false, false);
            for (Page child : childrenPages) {
                queue.add(child);
            }
        }
    }

    protected void invalidateAttachmentCache(Page note) {
        WikiPageParams wikiPageParams = new WikiPageParams(note.getWikiType(), note.getWikiOwner(), note.getName());
        List<WikiPageParams> linkedPages = this.pageLinksMap.get(wikiPageParams);
        linkedPages = linkedPages == null ? new ArrayList<WikiPageParams>() : new ArrayList<WikiPageParams>(linkedPages);
        linkedPages.add(wikiPageParams);
        for (WikiPageParams linkedWikiPageParams : linkedPages) {
            try {
                MarkupKey key = new MarkupKey(linkedWikiPageParams, false);
                this.attachmentCountCache.remove((Serializable)new Integer(key.hashCode()));
                key.setSupportSectionEdit(true);
                this.attachmentCountCache.remove((Serializable)new Integer(key.hashCode()));
                key = new MarkupKey(linkedWikiPageParams, false);
                this.attachmentCountCache.remove((Serializable)new Integer(key.hashCode()));
                key.setSupportSectionEdit(true);
                this.attachmentCountCache.remove((Serializable)new Integer(key.hashCode()));
            }
            catch (Exception e) {
                log.warn((Object)String.format("Failed to invalidate cache of note [%s:%s:%s]", linkedWikiPageParams.getType(), linkedWikiPageParams.getOwner(), linkedWikiPageParams.getPageName()));
            }
        }
    }

    public void postUpdatePage(String wikiType, String wikiOwner, String pageId, Page page, PageUpdateType wikiUpdateType) throws WikiException {
        List<PageWikiListener> listeners = this.wikiService.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postUpdatePage(wikiType, wikiOwner, pageId, page, wikiUpdateType);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on [%s] failed", new Object[]{l, page.getName()}), (Throwable)e);
            }
        }
    }

    public void postAddPage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        List<PageWikiListener> listeners = this.wikiService.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postAddPage(wikiType, wikiOwner, pageId, page);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on [%s] failed", new Object[]{l, page.getName()}), (Throwable)e);
            }
        }
    }

    public void postDeletePage(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        List<PageWikiListener> listeners = this.wikiService.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postDeletePage(wikiType, wikiOwner, pageId, page);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on [%s] failed", new Object[]{l, page.getName()}), (Throwable)e);
            }
        }
    }

    public void postOpenByTree(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        List<PageWikiListener> listeners = this.wikiService.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postgetPagefromTree(wikiType, wikiOwner, pageId, page);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on [%s] failed", new Object[]{l, page.getName()}), (Throwable)e);
            }
        }
    }

    public void postOpenByBreadCrumb(String wikiType, String wikiOwner, String pageId, Page page) throws WikiException {
        List<PageWikiListener> listeners = this.wikiService.getPageListeners();
        for (PageWikiListener l : listeners) {
            try {
                l.postgetPagefromBreadCrumb(wikiType, wikiOwner, pageId, page);
            }
            catch (WikiException e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)String.format("Executing listener [%s] on [%s] failed", new Object[]{l, page.getName()}), (Throwable)e);
            }
        }
    }

    private void checkToRemoveDomainInUrl(Page note) {
        block4: {
            if (note == null) {
                return;
            }
            String url = note.getUrl();
            if (url != null && url.contains("://")) {
                try {
                    URL oldURL = new URL(url);
                    note.setUrl(oldURL.getPath());
                }
                catch (MalformedURLException ex) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn((Object)("Malformed url " + url), (Throwable)ex);
                }
            }
        }
    }

    private boolean canManageNotes(String authenticatedUser, Space space, Page page) throws WikiException {
        if (space != null) {
            return this.spaceService.isSuperManager(authenticatedUser) || this.spaceService.isManager(space, authenticatedUser) || this.spaceService.isRedactor(space, authenticatedUser) || this.spaceService.isMember(space, authenticatedUser) && ArrayUtils.isEmpty((Object[])space.getRedactors());
        }
        return page.getOwner().equals(authenticatedUser);
    }

    private boolean canImportNotes(String authenticatedUser, Space space, Page page) throws WikiException {
        if (space != null) {
            return this.spaceService.isSuperManager(authenticatedUser) || this.spaceService.isManager(space, authenticatedUser) || this.spaceService.isRedactor(space, authenticatedUser);
        }
        return page.getOwner().equals(authenticatedUser);
    }

    private boolean canViewNotes(String authenticatedUser, Space space, Page page) throws WikiException {
        if (space != null) {
            return space != null && this.spaceService.isMember(space, authenticatedUser);
        }
        return this.spaceService.isSuperManager(authenticatedUser) || page.getOwner().equals(authenticatedUser);
    }

    private List<BreadcrumbData> getBreadCrumb(List<BreadcrumbData> list, String noteType, String noteOwner, String noteName, boolean isDraftNote) throws WikiException {
        Page parentNote;
        Page note;
        if (list == null) {
            list = new ArrayList<BreadcrumbData>(5);
        }
        if (noteName == null) {
            return list;
        }
        Page page = note = isDraftNote ? this.dataStorage.getDraftPageById(noteName) : this.getNoteOfNoteBookByName(noteType, noteOwner, noteName);
        if (note == null) {
            return list;
        }
        list.add(0, new BreadcrumbData(note.getName(), note.getId(), note.getTitle(), noteType, noteOwner));
        Page page2 = parentNote = isDraftNote ? this.getNoteById(note.getParentPageId()) : this.getParentNoteOf(note);
        if (parentNote != null) {
            this.getBreadCrumb(list, noteType, noteOwner, parentNote.getName(), false);
        }
        return list;
    }

    private LinkedList<String> getNoteAncestorsIds(String noteId) throws WikiException {
        return this.getNoteAncestorsIds(null, noteId);
    }

    private LinkedList<String> getNoteAncestorsIds(LinkedList<String> ancestorsIds, String noteId) throws WikiException {
        if (ancestorsIds == null) {
            ancestorsIds = new LinkedList();
        }
        if (noteId == null) {
            return ancestorsIds;
        }
        Page note = this.getNoteById(noteId);
        String parentId = note.getParentPageId();
        if (parentId != null) {
            ancestorsIds.push(parentId);
            this.getNoteAncestorsIds(ancestorsIds, parentId);
        }
        return ancestorsIds;
    }

    private String getDraftNameSuffix(long clientTime) {
        return new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date(clientTime));
    }

    @Override
    public byte[] exportNotes(String[] notesToExportIds, boolean exportAll, Identity identity) throws IOException, WikiException {
        String json;
        File zipped = null;
        List<NoteToExport> notesToExport = this.getNotesToExport(notesToExportIds, exportAll, identity);
        ExportList notesExport = new ExportList(new Date().getTime(), notesToExport);
        ArrayList<File> files = new ArrayList<File>();
        File temp = File.createTempFile("notesExport_" + new Date().getTime(), ".json");
        ObjectMapper mapper = new ObjectMapper();
        String contentUpdated = json = mapper.writeValueAsString((Object)notesExport);
        String fileName = "";
        Object filePath = "";
        while (contentUpdated.contains(IMAGE_URL_REPLACEMENT_PREFIX)) {
            fileName = contentUpdated.split(IMAGE_URL_REPLACEMENT_PREFIX)[1].split(IMAGE_URL_REPLACEMENT_SUFFIX)[0];
            filePath = System.getProperty(TEMP_DIRECTORY_PATH) + File.separator + fileName;
            files.add(new File((String)filePath));
            contentUpdated = contentUpdated.replace(IMAGE_URL_REPLACEMENT_PREFIX + fileName + IMAGE_URL_REPLACEMENT_SUFFIX, "");
        }
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(temp));){
            bw.write(json);
        }
        files.add(temp);
        zipped = NoteServiceImpl.zipFiles(EXPORT_ZIP_NAME, files);
        for (File file : files) {
            NoteServiceImpl.cleanUp(file);
        }
        byte[] filesBytes = FileUtils.readFileToByteArray((File)zipped);
        NoteServiceImpl.cleanUp(zipped);
        return filesBytes;
    }

    @Override
    public List<NoteToExport> getNotesToExport(String[] notesToExportIds, boolean exportAll, Identity identity) {
        ArrayList<NoteToExport> noteToExportList = new ArrayList<NoteToExport>();
        if (exportAll) {
            for (String noteId : notesToExportIds) {
                try {
                    Page note = this.getNoteById(noteId, identity);
                    if (note == null) {
                        log.warn("Failed to export note {}: note not find ", new Object[]{noteId});
                        continue;
                    }
                    NoteToExport noteToExport = this.getNoteToExport(new NoteToExport(note.getId(), note.getName(), note.getOwner(), note.getAuthor(), note.getContent(), note.getSyntax(), note.getTitle(), note.getComment(), note.getWikiId(), note.getWikiType(), note.getWikiOwner()));
                    noteToExportList.add(noteToExport);
                }
                catch (IllegalAccessException e) {
                    log.error("User does not have  permissions on the note {}", new Object[]{noteId, e});
                }
                catch (Exception ex) {
                    log.warn("Failed to export note {} ", new Object[]{noteId, ex});
                }
            }
        } else {
            ArrayList<NoteToExport> allNotesToExport = new ArrayList<NoteToExport>();
            int maxAncestors = 0;
            for (String noteId : notesToExportIds) {
                try {
                    Page note = this.getNoteById(noteId, identity);
                    if (note == null) {
                        log.warn("Failed to export note {}: note not find ", new Object[]{noteId});
                        continue;
                    }
                    NoteToExport noteToExport = new NoteToExport(note.getId(), note.getName(), note.getOwner(), note.getAuthor(), note.getContent(), note.getSyntax(), note.getTitle(), note.getComment(), note.getWikiId(), note.getWikiType(), note.getWikiOwner());
                    noteToExport.setContent(this.processImagesForExport(note));
                    noteToExport.setContent(this.processNotesLinkForExport(noteToExport));
                    LinkedList<String> ancestors = this.getNoteAncestorsIds(noteToExport.getId());
                    noteToExport.setAncestors(ancestors);
                    if (ancestors.size() > maxAncestors) {
                        maxAncestors = ancestors.size();
                    }
                    allNotesToExport.add(noteToExport);
                }
                catch (IllegalAccessException e) {
                    log.error("User does not have  permissions on the note {}", new Object[]{noteId, e});
                }
                catch (Exception ex) {
                    log.warn("Failed to export note {} ", new Object[]{noteId, ex});
                }
            }
            for (NoteToExport noteToExport : allNotesToExport) {
                noteToExport.setParent(this.getParentOfNoteFromExistingNotes(noteToExport.getAncestors(), allNotesToExport, notesToExportIds));
            }
            for (int level = maxAncestors; level >= 0; --level) {
                List<NoteToExport> bottomNotes = this.getBottomNotesToExport(allNotesToExport, level);
                for (NoteToExport bottomNote : bottomNotes) {
                    NoteToExport parent = bottomNote.getParent();
                    if (parent == null) continue;
                    List<NoteToExport> children = parent.getChildren();
                    if (children != null) {
                        children.add(bottomNote);
                    } else {
                        children = new ArrayList<NoteToExport>(Collections.singletonList(bottomNote));
                    }
                    for (NoteToExport child : children) {
                        NoteToExport currentParent = new NoteToExport(parent);
                        currentParent.setChildren(null);
                        currentParent.setParent(null);
                        child.setParent(currentParent);
                    }
                    parent.setChildren(children);
                    allNotesToExport.remove(bottomNote);
                    allNotesToExport.set(allNotesToExport.indexOf(parent), parent);
                }
            }
            noteToExportList.addAll(allNotesToExport);
        }
        return noteToExportList;
    }

    private List<NoteToExport> getBottomNotesToExport(List<NoteToExport> allNotesToExport, int level) {
        return allNotesToExport.stream().filter(export -> export.getAncestors().size() == level).collect(Collectors.toList());
    }

    private NoteToExport getParentOfNoteFromExistingNotes(LinkedList<String> ancestors, List<NoteToExport> exports, String[] noteIds) {
        NoteToExport parent = null;
        Iterator<String> descendingIterator = ancestors.descendingIterator();
        String parentId = null;
        boolean parentFound = false;
        while (descendingIterator.hasNext() && !parentFound) {
            String current = descendingIterator.next();
            if (!Arrays.asList(noteIds).contains(current)) continue;
            parentId = current;
            parentFound = true;
        }
        if (parentId != null) {
            String finalParentId = parentId;
            Optional<NoteToExport> parentToExport = exports.stream().filter(export -> export.getId().equals(finalParentId)).findFirst();
            if (parentToExport.isPresent()) {
                parent = parentToExport.get();
            }
        }
        return parent;
    }

    public NoteToExport getNoteToExport(NoteToExport note) throws WikiException, IOException {
        try {
            note.setContent(this.processImagesForExport(this.getNoteById(note.getId())));
        }
        catch (Exception e) {
            log.warn("Cannot process images for note {}", new Object[]{note.getId()});
        }
        try {
            note.setContent(this.processNotesLinkForExport(note));
        }
        catch (Exception e) {
            log.warn("Cannot process notes link for note {}", new Object[]{note.getId()});
        }
        List<NoteToExport> children = this.getChildrenNoteOf(note);
        for (NoteToExport child : children) {
            child.setParent(note);
        }
        note.setChildren(children);
        note.setParent(this.getParentNoteOf(note));
        for (NoteToExport child : children) {
            this.getNoteToExport(child);
        }
        return note;
    }

    public String processNotesLinkForExport(NoteToExport note) throws WikiException {
        String content = note.getContent();
        String noteLinkprefix = "class=\"noteLink\" href=\"";
        String contentUpdated = content;
        HashMap<String, String> urlToReplaces = new HashMap<String, String>();
        while (contentUpdated.contains("noteLink")) {
            String check_content = contentUpdated;
            String noteId = contentUpdated.split(noteLinkprefix)[1].split("\"")[0];
            Page linkedNote = null;
            try {
                long id = Long.parseLong(noteId);
                linkedNote = this.getNoteById(noteId);
            }
            catch (NumberFormatException e) {
                Page note_ = this.getNoteById(note.getId());
                linkedNote = this.getNoteOfNoteBookByName(note_.getWikiType(), note_.getWikiOwner(), noteId);
            }
            if (linkedNote != null) {
                String noteParams = IMAGE_URL_REPLACEMENT_PREFIX + linkedNote.getWikiType() + "-////-" + linkedNote.getWikiOwner() + "-////-" + linkedNote.getName() + IMAGE_URL_REPLACEMENT_SUFFIX;
                urlToReplaces.put(noteLinkprefix + linkedNote.getId() + "\"", noteLinkprefix + noteParams + "\"");
            }
            if (!(contentUpdated = contentUpdated.replace(noteLinkprefix + noteId + "\"", "")).equals(check_content)) continue;
            break;
        }
        if (!urlToReplaces.isEmpty()) {
            content = this.replaceUrl(content, urlToReplaces);
        }
        return content;
    }

    public List<File> getFilesfromContent(NoteToExport note, List<File> files) throws WikiException {
        String contentUpdated = note.getContent();
        String fileName = "";
        Object filePath = "";
        while (contentUpdated.contains(IMAGE_URL_REPLACEMENT_PREFIX)) {
            fileName = contentUpdated.split(IMAGE_URL_REPLACEMENT_PREFIX)[1].split(IMAGE_URL_REPLACEMENT_SUFFIX)[0];
            filePath = System.getProperty(TEMP_DIRECTORY_PATH) + File.separator + fileName;
            files.add(new File((String)filePath));
            contentUpdated = contentUpdated.replace(IMAGE_URL_REPLACEMENT_PREFIX + fileName + IMAGE_URL_REPLACEMENT_SUFFIX, "");
        }
        List<NoteToExport> children = this.getChildrenNoteOf(note);
        for (NoteToExport child : children) {
            this.getFilesfromContent(child, files);
        }
        return files;
    }

    public String processImagesForExport(Page note) throws WikiException, IOException {
        String content = note.getContent();
        String restUploadUrl = "/portal/rest/wiki/attachments/";
        HashMap<String, String> urlToReplaces = new HashMap<String, String>();
        while (content.contains(restUploadUrl)) {
            String check_content = content;
            Object urlToReplace = content.split(restUploadUrl)[1].split("\"")[0];
            String attachmentId = StringUtils.substringAfterLast((String)(urlToReplace = restUploadUrl + (String)urlToReplace), (String)"/");
            Attachment attachment = this.wikiService.getAttachmentOfPageByName(attachmentId, note, true);
            if (attachment != null && attachment.getContent() != null) {
                ByteArrayInputStream bis = new ByteArrayInputStream(attachment.getContent());
                File tempFile = new File(System.getProperty(TEMP_DIRECTORY_PATH) + File.separator + attachmentId);
                Files.copy(bis, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                urlToReplaces.put((String)urlToReplace, IMAGE_URL_REPLACEMENT_PREFIX + tempFile.getName() + IMAGE_URL_REPLACEMENT_SUFFIX);
            }
            if (!(content = content.replace((CharSequence)urlToReplace, "")).equals(check_content)) continue;
            break;
        }
        if (!urlToReplaces.isEmpty()) {
            content = this.replaceUrl(note.getContent(), urlToReplaces);
        }
        return this.htmlUploadImageProcessor.processImagesForExport(content);
    }

    @Override
    public void importNotes(String zipLocation, Page parent, String conflict, Identity userIdentity) throws WikiException, IllegalAccessException, IOException {
        List<String> files = Utils.unzip(zipLocation, System.getProperty(TEMP_DIRECTORY_PATH));
        this.importNotes(files, parent, conflict, userIdentity);
    }

    @Override
    public void importNotes(List<String> files, Page parent, String conflict, Identity userIdentity) throws WikiException, IllegalAccessException, IOException {
        String notesFilePath = "";
        for (String file : files) {
            if (!file.contains("notesExport_")) continue;
            notesFilePath = file;
            break;
        }
        if (!notesFilePath.equals("")) {
            ObjectMapper mapper = new ObjectMapper();
            File notesFile = new File(notesFilePath);
            ImportList notes = (ImportList)mapper.readValue(notesFile, (TypeReference)new TypeReference<ImportList>(){});
            Wiki wiki = this.wikiService.getWikiByTypeAndOwner(parent.getWikiType(), parent.getWikiOwner());
            if (StringUtils.isNotEmpty((String)conflict) && conflict.equals("replaceAll")) {
                List<Page> notesTodelete = this.getAllNotes(parent, userIdentity.getUserId());
                for (Page noteTodelete : notesTodelete) {
                    if ("Home".equals(noteTodelete.getName()) || noteTodelete.getId().equals(parent.getId())) continue;
                    try {
                        this.deleteNote(wiki.getType(), wiki.getOwner(), noteTodelete.getName(), userIdentity);
                    }
                    catch (Exception e) {
                        log.warn("Note {} connot be deleted for import", new Object[]{noteTodelete.getName(), e});
                    }
                }
            }
            for (Page note : notes.getNotes()) {
                this.importNote(note, parent, this.wikiService.getWikiByTypeAndOwner(parent.getWikiType(), parent.getWikiOwner()), conflict, userIdentity);
            }
            for (Page note : notes.getNotes()) {
                this.replaceIncludedPages(note, wiki);
            }
            NoteServiceImpl.cleanUp(notesFile);
        }
    }

    public void importNote(Page note, Page parent, Wiki wiki, String conflict, Identity userIdentity) throws WikiException, IllegalAccessException {
        Page parent_ = this.getNoteOfNoteBookByName(wiki.getType(), wiki.getOwner(), parent.getName());
        if (parent_ == null) {
            parent_ = wiki.getWikiHome();
        }
        Page note_ = note;
        if (!"Home".equals(note.getName())) {
            note.setId(null);
            Page note_2 = this.getNoteOfNoteBookByName(wiki.getType(), wiki.getOwner(), note.getName());
            if (note_2 == null) {
                if (wiki.getType().toUpperCase().equals(WikiType.GROUP.name())) {
                    note.setContent(this.htmlUploadImageProcessor.processSpaceImages(note.getContent(), wiki.getOwner(), "Notes"));
                }
                if (wiki.getType().toUpperCase().equals(WikiType.USER.name())) {
                    note.setContent(this.htmlUploadImageProcessor.processUserImages(note.getContent(), wiki.getOwner(), "Notes"));
                }
                note_ = this.createNote(wiki, parent_.getName(), note, userIdentity);
            } else if (StringUtils.isNotEmpty((String)conflict)) {
                if (conflict.equals("overwrite") || conflict.equals("replaceAll")) {
                    this.deleteNote(wiki.getType(), wiki.getOwner(), note.getName());
                    if (wiki.getType().toUpperCase().equals(WikiType.GROUP.name())) {
                        note.setContent(this.htmlUploadImageProcessor.processSpaceImages(note.getContent(), wiki.getOwner(), "Notes"));
                    }
                    if (wiki.getType().toUpperCase().equals(WikiType.USER.name())) {
                        note.setContent(this.htmlUploadImageProcessor.processUserImages(note.getContent(), wiki.getOwner(), "Notes"));
                    }
                    note_ = this.createNote(wiki, parent_.getName(), note, userIdentity);
                }
                if (conflict.equals("duplicate")) {
                    int i = 1;
                    String newTitle = note.getTitle() + "_" + i;
                    while (this.getNoteOfNoteBookByName(wiki.getType(), wiki.getOwner(), newTitle) != null) {
                        newTitle = note.getTitle() + "_" + ++i;
                    }
                    note.setName(newTitle);
                    note.setTitle(newTitle);
                    if (wiki.getType().toUpperCase().equals(WikiType.GROUP.name())) {
                        note.setContent(this.htmlUploadImageProcessor.processSpaceImages(note.getContent(), wiki.getOwner(), "Notes"));
                    }
                    if (wiki.getType().toUpperCase().equals(WikiType.USER.name())) {
                        note.setContent(this.htmlUploadImageProcessor.processUserImages(note.getContent(), wiki.getOwner(), "Notes"));
                    }
                    note_ = this.createNote(wiki, parent_.getName(), note, userIdentity);
                }
                if (!(!conflict.equals("update") || note_2.getTitle().equals(note.getTitle()) && note_2.getContent().equals(note.getContent()))) {
                    note_2.setContent(note.getContent());
                    note_2.setTitle(note.getTitle());
                    if (wiki.getType().toUpperCase().equals(WikiType.GROUP.name())) {
                        note_2.setContent(this.htmlUploadImageProcessor.processSpaceImages(note.getContent(), wiki.getOwner(), "Notes"));
                    }
                    if (wiki.getType().toUpperCase().equals(WikiType.USER.name())) {
                        note_2.setContent(this.htmlUploadImageProcessor.processUserImages(note.getContent(), wiki.getOwner(), "Notes"));
                    }
                    note_2 = this.updateNote(note_2, PageUpdateType.EDIT_PAGE_CONTENT, userIdentity);
                    this.createVersionOfNote(note_2, userIdentity.getUserId());
                }
            }
        } else if (StringUtils.isNotEmpty((String)conflict) && (conflict.equals("update") || conflict.equals("overwrite") || conflict.equals("replaceAll"))) {
            Page note_1 = this.getNoteOfNoteBookByName(wiki.getType(), wiki.getOwner(), note.getName());
            if (!note.getContent().equals(note_1.getContent())) {
                if (wiki.getType().toUpperCase().equals(WikiType.GROUP.name())) {
                    note.setContent(this.htmlUploadImageProcessor.processSpaceImages(note.getContent(), wiki.getOwner(), "Notes"));
                }
                if (wiki.getType().toUpperCase().equals(WikiType.USER.name())) {
                    note.setContent(this.htmlUploadImageProcessor.processUserImages(note.getContent(), wiki.getOwner(), "Notes"));
                }
                note_1.setContent(note.getContent());
                note_1 = this.updateNote(note_1, PageUpdateType.EDIT_PAGE_CONTENT, userIdentity);
                this.createVersionOfNote(note_1, userIdentity.getUserId());
            }
        }
        if (note.getChildren() != null) {
            for (Page child : note.getChildren()) {
                this.importNote(child, note_, wiki, conflict, userIdentity);
            }
        }
    }

    private void replaceIncludedPages(Page note, Wiki wiki) throws WikiException {
        String content;
        Page note_ = this.getNoteOfNoteBookByName(wiki.getType(), wiki.getOwner(), note.getName());
        if (note_ != null && (content = note_.getContent()).contains("class=\"noteLink\" href=\"//-")) {
            while (content.contains("class=\"noteLink\" href=\"//-")) {
                String linkedParams = content.split("class=\"noteLink\" href=\"//-")[1].split("-//\"")[0];
                String noteBookType = linkedParams.split("-////-")[0];
                String noteBookOwner = linkedParams.split("-////-")[1];
                String NoteName = linkedParams.split("-////-")[2];
                Page linkedNote = null;
                linkedNote = this.getNoteOfNoteBookByName(wiki.getType(), wiki.getOwner(), NoteName);
                content = linkedNote != null ? content.replace("\"noteLink\" href=\"//-" + linkedParams + IMAGE_URL_REPLACEMENT_SUFFIX, "\"noteLink\" href=\"" + linkedNote.getId()) : content.replace("\"noteLink\" href=\"//-" + linkedParams + IMAGE_URL_REPLACEMENT_SUFFIX, "\"noteLink\" href=\"" + NoteName);
                if (!content.equals(note_.getContent())) continue;
                break;
            }
            if (!content.equals(note_.getContent())) {
                note_.setContent(content);
                this.updateNote(note_);
            }
        }
        if (note.getChildren() != null) {
            for (Page child : note.getChildren()) {
                this.replaceIncludedPages(child, wiki);
            }
        }
    }

    private String replaceUrl(String body, Map<String, String> urlToReplaces) {
        for (String url : urlToReplaces.keySet()) {
            while (body.contains(url)) {
                body = body.replace(url, urlToReplaces.get(url));
            }
        }
        return body;
    }

    public static void cleanUp(File file) throws IOException {
        if (Files.exists(file.toPath(), new LinkOption[0])) {
            Files.delete(file.toPath());
        }
    }

    public List<Page> getAllNotes(Page note, String userName) throws WikiException {
        ArrayList<Page> listOfNotes = new ArrayList<Page>();
        this.addAllNodes(note, listOfNotes, userName);
        return listOfNotes;
    }

    private void addAllNodes(Page note, List<Page> listOfNotes, String userName) throws WikiException {
        if (note != null) {
            listOfNotes.add(note);
            List<Page> children = this.getChildrenNoteOf(note, userName, true, false);
            if (children != null) {
                for (Page child : children) {
                    this.addAllNodes(child, listOfNotes, userName);
                }
            }
        }
    }

    private Map<String, List<MetadataItem>> retrieveMetadataItems(String noteId, String username) {
        org.exoplatform.social.core.identity.model.Identity currentIdentity = this.identityManager.getOrCreateIdentity("organization", username);
        long currentUserId = Long.parseLong(currentIdentity.getId());
        MetadataService metadataService = (MetadataService)CommonsUtils.getService(MetadataService.class);
        MetadataObject metadataObject = new MetadataObject("notes", noteId);
        List metadataItems = metadataService.getMetadataItemsByObject(metadataObject);
        HashMap<String, List<MetadataItem>> metadata = new HashMap<String, List<MetadataItem>>();
        metadataItems.stream().filter(metadataItem -> metadataItem.getMetadata().getAudienceId() == 0L || metadataItem.getMetadata().getAudienceId() == currentUserId).forEach(metadataItem -> {
            String type = metadataItem.getMetadata().getType().getName();
            metadata.computeIfAbsent(type, k -> new ArrayList());
            ((List)metadata.get(type)).add(metadataItem);
        });
        return metadata;
    }
}

