/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wiki.model.ImportList;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.model.WikiType;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.utils.Utils;
import org.picocontainer.Startable;

public class NotesAutoImportService
implements Startable {
    public static final String NOTES_IMPORT_SCOPE_NAME = "NOTES_IMPORT_SCOPE";
    public static final String NOTES_IMPORT_CONTEXT_NAME = "NOTES_IMPORT_CONTEXT";
    public static final Context NOTES_IMPORT_CONTEXT = Context.GLOBAL.id("NOTES_IMPORT_CONTEXT");
    public static final Scope NOTES_IMPORT_SCOPE = Scope.APPLICATION.id("NOTES_IMPORT_SCOPE");
    private static final Log log = ExoLogger.getLogger(NotesAutoImportService.class);
    private static final String EN_KNOWLEDGE_BASE_SPACE_NAME_PARAM = "enKnowledgeBaseSpaceName";
    private static final String FR_KNOWLEDGE_BASE_SPACE_NAME_PARAM = "frKnowledgeBaseSpaceName ";
    private static final String EN_KNOWLEDGE_BASE_SPACE_NAME_DISPLAY_PARAM = "enKnowledgeBaseSpaceDispalyName";
    private static final String FR_KNOWLEDGE_BASE_SPACE_DISPLAY_NAME_PARAM = "frKnowledgeBaseSpaceDispalyName";
    private static final String EN_KNOWLEDGE_BASE_SPACE_DESCRIPTION_PARAM = "enKnowledgeBaseSpaceDescription";
    private static final String FR_KNOWLEDGE_BASE_SPACE_DESCRIPTION_PARAM = "frKnowledgeBaseSpaceDescription";
    private static final String IMPORT_ENABLED_PARAM = "importEnabled";
    private static final String IMPORT_CONFLICT_MODE_PARAM = "importConflictMode";
    private static final String FR_EXPORT_ZIP_LOCATION = "/notesExports/fr/kb_export_fr.zip";
    private static final String EN_EXPORT_ZIP_LOCATION = "/notesExports/en/kb_export_en.zip";
    private static final String SPACE_TEMPLATE = "community";
    private static final String TEMP_DIRECTORY_PATH = "java.io.tmpdir";
    private final InitParams initParams;
    private final NoteService noteService;
    private final SpaceService spaceService;
    private final WikiService wikiService;
    private final SettingService settingService;
    private final UserACL userACL;
    private String enKnowledgeBaseSpaceName = "exo_knowledge_base_en";
    private String frKnowledgeBaseSpaceName = "exo_knowledge_base_fr";
    private String enKnowledgeBaseSpaceDispalyName = "eXo knowledge base";
    private String frKnowledgeBaseSpaceDispalyName = "Base de connaissance eXo";
    private String enKnowledgeBaseSpaceDescription = "eXo knowledge base space";
    private String frKnowledgeBaseSpaceDescription = "Espace pour la base de connaissance eXo";
    private boolean importEnabled = false;
    private String importConflictMode = "replaceAll";

    public NotesAutoImportService(InitParams initParams, SettingService settingService, NoteService noteService, WikiService wikiService, SpaceService spaceService, UserACL userACL) {
        this.initParams = initParams;
        this.settingService = settingService;
        this.noteService = noteService;
        this.wikiService = wikiService;
        this.spaceService = spaceService;
        this.userACL = userACL;
        if (initParams != null) {
            if (initParams.getValueParam(IMPORT_ENABLED_PARAM) != null) {
                this.importEnabled = initParams.getValueParam(IMPORT_ENABLED_PARAM).getValue().equals("true");
            }
            if (initParams.getValueParam(IMPORT_CONFLICT_MODE_PARAM) != null) {
                this.importConflictMode = initParams.getValueParam(IMPORT_CONFLICT_MODE_PARAM).getValue();
            }
            if (initParams.getValueParam(EN_KNOWLEDGE_BASE_SPACE_NAME_PARAM) != null) {
                this.enKnowledgeBaseSpaceName = initParams.getValueParam(EN_KNOWLEDGE_BASE_SPACE_NAME_PARAM).getValue();
            }
            if (initParams.getValueParam(EN_KNOWLEDGE_BASE_SPACE_NAME_DISPLAY_PARAM) != null) {
                this.enKnowledgeBaseSpaceDispalyName = initParams.getValueParam(EN_KNOWLEDGE_BASE_SPACE_NAME_DISPLAY_PARAM).getValue();
            }
            if (initParams.getValueParam(EN_KNOWLEDGE_BASE_SPACE_DESCRIPTION_PARAM) != null) {
                this.enKnowledgeBaseSpaceDescription = initParams.getValueParam(EN_KNOWLEDGE_BASE_SPACE_DESCRIPTION_PARAM).getValue();
            }
            if (initParams.getValueParam(FR_KNOWLEDGE_BASE_SPACE_NAME_PARAM) != null) {
                this.frKnowledgeBaseSpaceName = initParams.getValueParam(FR_KNOWLEDGE_BASE_SPACE_NAME_PARAM).getValue();
            }
            if (initParams.getValueParam(FR_KNOWLEDGE_BASE_SPACE_DISPLAY_NAME_PARAM) != null) {
                this.frKnowledgeBaseSpaceDispalyName = initParams.getValueParam(FR_KNOWLEDGE_BASE_SPACE_DISPLAY_NAME_PARAM).getValue();
            }
            if (initParams.getValueParam(FR_KNOWLEDGE_BASE_SPACE_DESCRIPTION_PARAM) != null) {
                this.frKnowledgeBaseSpaceDescription = initParams.getValueParam(FR_KNOWLEDGE_BASE_SPACE_DESCRIPTION_PARAM).getValue();
            }
        }
    }

    public void start() {
        if (this.importEnabled) {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                ArrayList<MembershipEntry> membershipEntries = new ArrayList<MembershipEntry>();
                membershipEntries.add(new MembershipEntry(this.userACL.getAdminGroups(), "*"));
                Identity superUserIdentity = new Identity(this.userACL.getSuperUser(), membershipEntries);
                this.importNotes(this.enKnowledgeBaseSpaceName, this.enKnowledgeBaseSpaceDispalyName, this.enKnowledgeBaseSpaceDescription, EN_EXPORT_ZIP_LOCATION, superUserIdentity);
                this.importNotes(this.frKnowledgeBaseSpaceName, this.frKnowledgeBaseSpaceDispalyName, this.frKnowledgeBaseSpaceDescription, FR_EXPORT_ZIP_LOCATION, superUserIdentity);
            }
            catch (Exception e) {
                log.error(" Error occured when trying to import notes for spaces {} and {}", new Object[]{this.enKnowledgeBaseSpaceName, this.frKnowledgeBaseSpaceName, e});
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }

    public void stop() {
    }

    private void importNotes(String spaceName, String spaceDisplayName, String spaceDescription, String zipPath, Identity superUserIdentity) {
        String groupId = "/spaces/" + spaceName;
        Space space = this.spaceService.getSpaceByGroupId(groupId);
        if (space == null) {
            space = this.createSpace(spaceName, spaceDisplayName, spaceDescription, SPACE_TEMPLATE, superUserIdentity);
        }
        try {
            SettingValue settingsValue;
            String settingsValueString;
            String folderPath = System.getProperty(TEMP_DIRECTORY_PATH);
            ArrayList<String> files = new ArrayList<String>();
            File destDir = new File(folderPath);
            if (!destDir.exists()) {
                destDir.mkdir();
            }
            Object notesFilePath = "";
            InputStream in = this.getClass().getResourceAsStream(zipPath);
            try (ZipInputStream zipIn = new ZipInputStream(in);){
                ZipEntry entry = zipIn.getNextEntry();
                while (entry != null) {
                    String filePath = folderPath + File.separator + entry.getName();
                    if (!entry.isDirectory()) {
                        Utils.extractFile(zipIn, filePath);
                        if (filePath.contains("notesExport_")) {
                            notesFilePath = filePath;
                        }
                        files.add(filePath);
                    } else {
                        File dir = new File(filePath);
                        dir.mkdirs();
                    }
                    zipIn.closeEntry();
                    entry = zipIn.getNextEntry();
                }
            }
            long exportTime = 0L;
            if (StringUtils.isNotEmpty((String)notesFilePath)) {
                ObjectMapper mapper = new ObjectMapper();
                File notesFile = new File((String)notesFilePath);
                ImportList notes = (ImportList)mapper.readValue(notesFile, (TypeReference)new TypeReference<ImportList>(){});
                try {
                    exportTime = notes.getExportDate();
                }
                catch (Exception e) {
                    exportTime = 0L;
                }
            }
            String string = settingsValueString = (settingsValue = this.settingService.get(NOTES_IMPORT_CONTEXT, NOTES_IMPORT_SCOPE, spaceName)) == null || settingsValue.getValue() == null ? null : settingsValue.getValue().toString();
            if (exportTime == 0L || settingsValue == null || exportTime != Long.valueOf(settingsValueString)) {
                log.info(" Start import notes for space {}", new Object[]{spaceName});
                if (space != null) {
                    Wiki wiki = this.wikiService.getWikiByTypeAndOwner(WikiType.GROUP.toString().toLowerCase(), space.getGroupId());
                    if (wiki == null) {
                        wiki = this.wikiService.createWiki(WikiType.GROUP.toString().toLowerCase(), space.getGroupId());
                    }
                    if (wiki != null) {
                        this.noteService.importNotes(files, wiki.getWikiHome(), this.importConflictMode, superUserIdentity);
                        this.settingService.set(NOTES_IMPORT_CONTEXT, NOTES_IMPORT_SCOPE, spaceName, SettingValue.create((String)String.valueOf(exportTime)));
                    }
                }
                log.info(" End import notes for space {}", new Object[]{spaceName});
            } else {
                log.info("No notes to import for space {}", new Object[]{spaceName});
            }
        }
        catch (Exception e) {
            log.info(" Error when trying to import notes for space {}", new Object[]{spaceName, e});
        }
    }

    private Space createSpace(String prettyName, String displayName, String description, String template, Identity superUserIdentity) {
        Space space = new Space();
        space.setPriority("2");
        space.setDisplayName(displayName);
        space.setDescription(description);
        space.setPrettyName(prettyName);
        space.setTemplate(template);
        space.setVisibility("hidden");
        space.setRegistration("closed");
        try {
            return this.spaceService.createSpace(space, superUserIdentity.getUserId());
        }
        catch (Exception e) {
            return null;
        }
    }
}

