/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.search;

import java.util.List;
import org.exoplatform.wiki.utils.Utils;

public class SearchData {
    public String title;
    public String content;
    public String wikiType;
    public String wikiOwner;
    public String userId;
    public String pageId;
    private long offset = 0L;
    private boolean isFavorites;
    protected String sort;
    protected String order;
    public int limit = Integer.MAX_VALUE;
    private List<String> tagNames;

    public SearchData(String title, String content, String wikiType, String wikiOwner, String pageId, String userId) {
        this.title = Utils.escapeIllegalCharacterInQuery(title);
        this.content = Utils.escapeIllegalCharacterInQuery(content);
        this.wikiType = wikiType;
        this.wikiOwner = Utils.validateWikiOwner(wikiType, wikiOwner);
        this.pageId = pageId;
        this.userId = userId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getContent() {
        return this.content;
    }

    public String getWikiType() {
        return this.wikiType;
    }

    public String getWikiOwner() {
        return this.wikiOwner;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPageId() {
        return this.pageId;
    }

    public long getOffset() {
        return this.offset;
    }

    public boolean isFavorites() {
        return this.isFavorites;
    }

    public String getSort() {
        return this.sort;
    }

    public String getOrder() {
        return this.order;
    }

    public int getLimit() {
        return this.limit;
    }

    public List<String> getTagNames() {
        return this.tagNames;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setWikiType(String wikiType) {
        this.wikiType = wikiType;
    }

    public void setWikiOwner(String wikiOwner) {
        this.wikiOwner = wikiOwner;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setFavorites(boolean isFavorites) {
        this.isFavorites = isFavorites;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setTagNames(List<String> tagNames) {
        this.tagNames = tagNames;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchData)) {
            return false;
        }
        SearchData other = (SearchData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (this.isFavorites() != other.isFavorites()) {
            return false;
        }
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$wikiType = this.getWikiType();
        String other$wikiType = other.getWikiType();
        if (this$wikiType == null ? other$wikiType != null : !this$wikiType.equals(other$wikiType)) {
            return false;
        }
        String this$wikiOwner = this.getWikiOwner();
        String other$wikiOwner = other.getWikiOwner();
        if (this$wikiOwner == null ? other$wikiOwner != null : !this$wikiOwner.equals(other$wikiOwner)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$pageId = this.getPageId();
        String other$pageId = other.getPageId();
        if (this$pageId == null ? other$pageId != null : !this$pageId.equals(other$pageId)) {
            return false;
        }
        String this$sort = this.getSort();
        String other$sort = other.getSort();
        if (this$sort == null ? other$sort != null : !this$sort.equals(other$sort)) {
            return false;
        }
        String this$order = this.getOrder();
        String other$order = other.getOrder();
        if (this$order == null ? other$order != null : !this$order.equals(other$order)) {
            return false;
        }
        List<String> this$tagNames = this.getTagNames();
        List<String> other$tagNames = other.getTagNames();
        return !(this$tagNames == null ? other$tagNames != null : !((Object)this$tagNames).equals(other$tagNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SearchData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $offset = this.getOffset();
        result = result * 59 + (int)($offset >>> 32 ^ $offset);
        result = result * 59 + (this.isFavorites() ? 79 : 97);
        result = result * 59 + this.getLimit();
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $wikiType = this.getWikiType();
        result = result * 59 + ($wikiType == null ? 43 : $wikiType.hashCode());
        String $wikiOwner = this.getWikiOwner();
        result = result * 59 + ($wikiOwner == null ? 43 : $wikiOwner.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $pageId = this.getPageId();
        result = result * 59 + ($pageId == null ? 43 : $pageId.hashCode());
        String $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : $sort.hashCode());
        String $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : $order.hashCode());
        List<String> $tagNames = this.getTagNames();
        result = result * 59 + ($tagNames == null ? 43 : ((Object)$tagNames).hashCode());
        return result;
    }

    public String toString() {
        return "SearchData(title=" + this.getTitle() + ", content=" + this.getContent() + ", wikiType=" + this.getWikiType() + ", wikiOwner=" + this.getWikiOwner() + ", userId=" + this.getUserId() + ", pageId=" + this.getPageId() + ", offset=" + this.getOffset() + ", isFavorites=" + this.isFavorites() + ", sort=" + this.getSort() + ", order=" + this.getOrder() + ", limit=" + this.getLimit() + ", tagNames=" + this.getTagNames() + ")";
    }
}

