/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.utils;

import java.util.StringTokenizer;

public class WikiNameValidator {
    public static final String INVALID_CHARACTERS = "% = : @ / \\ | ^ # ; [ ] { } < > * ' `\" + ? &";

    public static void validate(String s) throws IllegalArgumentException {
        if (s == null || s.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < s.length(); ++i) {
            String test;
            StringTokenizer tokens = new StringTokenizer(INVALID_CHARACTERS);
            char c = s.charAt(i);
            boolean isInvalid = false;
            while (tokens.hasMoreTokens() && !(isInvalid = (test = tokens.nextToken()).equals(String.valueOf(c)))) {
            }
            if (Character.isLetter(c) || Character.isDigit(c) || !isInvalid) continue;
            throw new IllegalArgumentException(INVALID_CHARACTERS);
        }
    }

    public static void validateFileName(String s) throws Exception {
        if (s == null || s.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c) || Character.isSpaceChar(c) || c == '_' || c == '-' || c == '(' || c == ')' || c == '.' || c == ',') continue;
            throw new IllegalArgumentException();
        }
    }
}

