/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.search.SearchServiceConnector;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.mow.api.WikiType;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.service.search.WikiSearchData;
import org.exoplatform.wiki.utils.Utils;

public class WikiSearchServiceConnector
extends SearchServiceConnector {
    private static final Log LOG = ExoLogger.getLogger((String)"org.exoplatform.wiki.service.impl.WikiSearchServiceConnector");
    public static final String WIKI_PAGE_ICON = "/eXoSkin/skin/images/system/unified-search/PageIcon.png";
    public static String DATE_TIME_FORMAT = "EEEEE, MMMMMMMM d, yyyy K:mm a";
    private WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);

    public WikiSearchServiceConnector(InitParams initParams) {
        super(initParams);
    }

    public Collection<SearchResult> search(SearchContext context, String query, Collection<String> sites, int offset, int limit, String sort, String order) {
        if (limit == 0) {
            limit = Integer.MAX_VALUE;
        }
        WikiSearchData searchData = new WikiSearchData(query, query, null, null);
        searchData.setOffset(offset);
        searchData.setLimit(limit);
        ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
        try {
            PageList<org.exoplatform.wiki.service.search.SearchResult> wikiSearchPageList = this.wikiService.search(searchData);
            if (wikiSearchPageList != null) {
                List wikiSearchResults = wikiSearchPageList.getAll();
                for (org.exoplatform.wiki.service.search.SearchResult wikiSearchResult : wikiSearchResults) {
                    SearchResult searchResult = this.buildResult(context, wikiSearchResult);
                    if (searchResult == null) continue;
                    searchResults.add(searchResult);
                }
            }
        }
        catch (Exception e) {
            LOG.info((Object)"Could not execute unified seach on wiki", (Throwable)e);
        }
        this.sortSearchResult(searchResults, sort, order);
        return searchResults;
    }

    private void sortSearchResult(List<SearchResult> searchResults, String sort, String order) {
        if (StringUtils.isEmpty((String)sort)) {
            return;
        }
        if (StringUtils.isEmpty((String)order)) {
            order = "ASC";
        }
        final String orderValue = order;
        if ("title".equalsIgnoreCase(sort)) {
            Collections.sort(searchResults, new Comparator<SearchResult>(){

                @Override
                public int compare(SearchResult o1, SearchResult o2) {
                    if ("ASC".equalsIgnoreCase(orderValue)) {
                        return o1.getTitle().compareTo(o2.getTitle());
                    }
                    return o2.getTitle().compareTo(o1.getTitle());
                }
            });
        } else if ("relevancy".equalsIgnoreCase(sort)) {
            Collections.sort(searchResults, new Comparator<SearchResult>(){

                @Override
                public int compare(SearchResult o1, SearchResult o2) {
                    if ("ASC".equalsIgnoreCase(orderValue)) {
                        return Long.valueOf(o1.getRelevancy()).compareTo(o2.getRelevancy());
                    }
                    return Long.valueOf(o2.getRelevancy()).compareTo(o1.getRelevancy());
                }
            });
        } else if ("date".equalsIgnoreCase(sort)) {
            Collections.sort(searchResults, new Comparator<SearchResult>(){

                @Override
                public int compare(SearchResult o1, SearchResult o2) {
                    if ("ASC".equalsIgnoreCase(orderValue)) {
                        return Long.valueOf(o1.getDate()).compareTo(o2.getDate());
                    }
                    return Long.valueOf(o2.getDate()).compareTo(o1.getDate());
                }
            });
        }
    }

    private String getResultIcon(org.exoplatform.wiki.service.search.SearchResult wikiSearchResult) {
        return WIKI_PAGE_ICON;
    }

    private Page getPage(org.exoplatform.wiki.service.search.SearchResult result) throws Exception {
        return this.wikiService.getPageOfWikiByName(result.getWikiType(), result.getWikiOwner(), result.getPageName());
    }

    private String getPageDetail(org.exoplatform.wiki.service.search.SearchResult wikiSearchResult) {
        StringBuffer pageDetail = new StringBuffer();
        try {
            String wikiOwner;
            Page page = this.getPage(wikiSearchResult);
            Wiki wiki = this.wikiService.getWikiByTypeAndOwner(page.getWikiType(), page.getWikiOwner());
            String spaceName = wiki.getType().equals(PortalConfig.GROUP_TYPE) ? ((wikiOwner = wiki.getOwner()).indexOf(47) == -1 ? this.wikiService.getSpaceNameByGroupId("/spaces/" + wiki.getOwner()) : this.wikiService.getSpaceNameByGroupId(wiki.getOwner())) : wiki.getOwner();
            Calendar updateDate = wikiSearchResult.getUpdatedDate();
            SimpleDateFormat format = new SimpleDateFormat(DATE_TIME_FORMAT);
            pageDetail.append(spaceName);
            pageDetail.append(" - ");
            pageDetail.append(format.format(updateDate.getTime()));
        }
        catch (Exception e) {
            LOG.info((Object)"Can not get page detail ", (Throwable)e);
        }
        return pageDetail.toString();
    }

    private String getPagePermalink(SearchContext context, org.exoplatform.wiki.service.search.SearchResult wikiSearchResult) {
        StringBuffer permalink = new StringBuffer();
        try {
            Page page = this.getPage(wikiSearchResult);
            Wiki wiki = this.wikiService.getWikiByTypeAndOwner(page.getWikiType(), page.getWikiOwner());
            if (wiki.getType().equalsIgnoreCase(WikiType.GROUP.toString())) {
                String portalContainerName = Utils.getPortalName();
                String portalOwner = context.getSiteName();
                String wikiWebappUri = this.wikiService.getWikiWebappUri();
                String spaceGroupId = wiki.getOwner();
                permalink.append("/");
                permalink.append(portalContainerName);
                permalink.append("/");
                permalink.append(portalOwner);
                permalink.append("/");
                permalink.append(wikiWebappUri);
                permalink.append("/");
                permalink.append(PortalConfig.GROUP_TYPE);
                permalink.append(spaceGroupId);
                permalink.append("/");
                permalink.append(page.getName());
            } else {
                String portalContainerName = Utils.getPortalName();
                String url = page.getUrl();
                if (url != null) {
                    url = url.substring(url.indexOf("/" + portalContainerName + "/"));
                    permalink.append(url);
                }
            }
        }
        catch (Exception ex) {
            LOG.info((Object)"Can not build the permalink for wiki page ", (Throwable)ex);
        }
        return permalink.toString();
    }

    private SearchResult buildResult(SearchContext context, org.exoplatform.wiki.service.search.SearchResult wikiSearchResult) {
        try {
            String title = wikiSearchResult.getTitle();
            String url = this.getPagePermalink(context, wikiSearchResult);
            String excerpt = wikiSearchResult.getExcerpt();
            String detail = this.getPageDetail(wikiSearchResult);
            long relevancy = wikiSearchResult.getScore();
            long date = wikiSearchResult.getUpdatedDate().getTime().getTime();
            String imageUrl = this.getResultIcon(wikiSearchResult);
            return new SearchResult(url, title, excerpt, detail, imageUrl, date, relevancy);
        }
        catch (Exception e) {
            LOG.info((Object)"Error when getting property from node ", (Throwable)e);
            return null;
        }
    }
}

