/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.listener;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.social.metadata.favorite.model.Favorite;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.service.NoteService;

public class NotesMetadataListener
extends Listener<Long, MetadataItem> {
    private final IndexingService indexingService;
    private final FavoriteService favoriteService;
    private final IdentityManager identityManager;
    private final NoteService noteService;
    private final ActivityManager activityManager;
    private static final String METADATA_CREATED = "social.metadataItem.created";
    private static final String METADATA_DELETED = "social.metadataItem.deleted";

    public NotesMetadataListener(IndexingService indexingService, FavoriteService favoriteService, IdentityManager identityManager, NoteService noteService, ActivityManager activityManager) {
        this.indexingService = indexingService;
        this.favoriteService = favoriteService;
        this.identityManager = identityManager;
        this.noteService = noteService;
        this.activityManager = activityManager;
    }

    public void onEvent(Event<Long, MetadataItem> event) throws Exception {
        ExoSocialActivity activity;
        ConversationState conversationstate = ConversationState.getCurrent();
        org.exoplatform.services.security.Identity currentIdentity = conversationstate == null || conversationstate.getIdentity() == null ? null : conversationstate.getIdentity();
        MetadataItem metadataItem = (MetadataItem)event.getData();
        String objectType = ((MetadataItem)event.getData()).getObjectType();
        String objectId = metadataItem.getObjectId();
        if (StringUtils.equals((CharSequence)objectType, (CharSequence)"notes")) {
            this.indexingService.reindex("wiki-page", objectId);
        } else if (StringUtils.equals((CharSequence)objectType, (CharSequence)"activity") && (activity = this.activityManager.getActivity(objectId)).getType().equals("ks-wiki:spaces") && currentIdentity != null) {
            Map templateParams = activity.getTemplateParams();
            String pageId = (String)templateParams.get("page_id");
            String pageOwner = (String)templateParams.get("page_owner");
            String pageType = (String)templateParams.get("page_type");
            Page note = this.noteService.getNoteOfNoteBookByName(pageType, pageOwner, pageId, currentIdentity);
            Identity userIdentity = this.identityManager.getOrCreateIdentity("organization", currentIdentity.getUserId());
            Favorite favorite = new Favorite("notes", note.getId(), "", Long.parseLong(userIdentity.getId()));
            if (note.getMetadatas().isEmpty() && event.getEventName().equals(METADATA_CREATED)) {
                this.favoriteService.createFavorite(favorite);
            } else if (!note.getMetadatas().isEmpty() && event.getEventName().equals(METADATA_DELETED)) {
                this.favoriteService.deleteFavorite(favorite);
            }
            this.indexingService.reindex("wiki-page", note.getId());
        }
    }
}

