/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.dao;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.exoplatform.social.core.jpa.test.AbstractCoreTest;
import org.exoplatform.wiki.jpa.BaseWikiJPAIntegrationTest;
import org.exoplatform.wiki.jpa.entity.DraftPageEntity;
import org.exoplatform.wiki.jpa.entity.PageEntity;
import org.exoplatform.wiki.jpa.entity.WikiEntity;
import org.junit.Test;

public class DraftPageDAOTest
extends BaseWikiJPAIntegrationTest {
    @Test
    public void testInsert() {
        WikiEntity wiki = new WikiEntity();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = (WikiEntity)this.wikiDAO.create((Object)wiki);
        PageEntity page = new PageEntity();
        page.setName("name");
        page.setWiki(wiki);
        page.setCreatedDate(new Date());
        page.setUpdatedDate(new Date());
        page = (PageEntity)this.pageDAO.create((Object)page);
        DraftPageEntity dp = new DraftPageEntity();
        dp.setName("draft1");
        dp.setTargetPage(page);
        dp.setCreatedDate(new Date());
        dp.setUpdatedDate(new Date());
        this.draftPageDAO.create((Object)dp);
        DraftPageDAOTest.assertNotNull((Object)this.draftPageDAO.find((Serializable)Long.valueOf(dp.getId())));
        DraftPageDAOTest.assertNotNull((Object)this.pageDAO.find((Serializable)Long.valueOf(page.getId())));
        DraftPageEntity got = (DraftPageEntity)this.draftPageDAO.find((Serializable)Long.valueOf(dp.getId()));
        got.getTargetPage().setName("name1");
        this.draftPageDAO.update((Object)got);
        DraftPageDAOTest.assertEquals((String)"name1", (String)page.getName());
        this.draftPageDAO.deleteAll();
        this.pageDAO.deleteAll();
        DraftPageDAOTest.assertNull((Object)this.draftPageDAO.find((Serializable)Long.valueOf(dp.getId())));
    }

    @Test
    public void testFindDraftPageByName() {
        WikiEntity wiki = new WikiEntity();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = (WikiEntity)this.wikiDAO.create((Object)wiki);
        PageEntity page = new PageEntity();
        page.setWiki(wiki);
        page.setCreatedDate(new Date());
        page.setUpdatedDate(new Date());
        page.setName("page1");
        page = (PageEntity)this.pageDAO.create((Object)page);
        DraftPageEntity dp = new DraftPageEntity();
        dp.setName("draft1");
        dp.setTargetPage(page);
        dp.setAuthor("user1");
        dp.setCreatedDate(new Date());
        dp.setUpdatedDate(new Date());
        this.draftPageDAO.create((Object)dp);
        DraftPageEntity draft1 = this.draftPageDAO.findDraftPageByName("draft1");
        DraftPageDAOTest.assertNotNull((Object)draft1);
        DraftPageDAOTest.assertEquals((String)"draft1", (String)draft1.getName());
        DraftPageDAOTest.assertEquals((String)"page1", (String)draft1.getTargetPage().getName());
        DraftPageDAOTest.assertEquals((String)"user1", (String)draft1.getAuthor());
        this.draftPageDAO.deleteAll();
        this.pageDAO.deleteAll();
    }

    @Test
    public void testFindDraftPagesByTargetPage() {
        WikiEntity wiki = new WikiEntity();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = (WikiEntity)this.wikiDAO.create((Object)wiki);
        PageEntity page = new PageEntity();
        page.setWiki(wiki);
        page.setCreatedDate(new Date());
        page.setUpdatedDate(new Date());
        page.setName("page1");
        page = (PageEntity)this.pageDAO.create((Object)page);
        DraftPageEntity dp = new DraftPageEntity();
        dp.setName("draft1");
        dp.setTargetPage(page);
        dp.setAuthor("user1");
        dp.setCreatedDate(new Date());
        dp.setUpdatedDate(new Date());
        this.draftPageDAO.create((Object)dp);
        List drafts1 = this.draftPageDAO.findDraftPagesByTargetPage(page.getId());
        List drafts2 = this.draftPageDAO.findDraftPagesByTargetPage(page.getId() + 1L);
        DraftPageDAOTest.assertNotNull((Object)this.draftPageDAO.find((Serializable)Long.valueOf(dp.getId())));
        DraftPageDAOTest.assertNotNull((Object)this.pageDAO.find((Serializable)Long.valueOf(page.getId())));
        DraftPageDAOTest.assertNotNull((Object)drafts1);
        DraftPageDAOTest.assertEquals((int)1, (int)drafts1.size());
        DraftPageDAOTest.assertNotNull((Object)drafts2);
        DraftPageDAOTest.assertEquals((int)0, (int)drafts2.size());
        this.draftPageDAO.deleteAll();
        this.pageDAO.deleteAll();
    }

    @Test
    public void testFindDraftPagesByParentPage() {
        WikiEntity wiki = new WikiEntity();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = (WikiEntity)this.wikiDAO.create((Object)wiki);
        PageEntity page = new PageEntity();
        page.setWiki(wiki);
        page.setCreatedDate(new Date());
        page.setUpdatedDate(new Date());
        page.setName("page1");
        page = (PageEntity)this.pageDAO.create((Object)page);
        PageEntity page2 = new PageEntity();
        page2.setWiki(wiki);
        page2.setCreatedDate(new Date());
        page2.setUpdatedDate(new Date());
        page2.setName("page2");
        page2.setParentPage(page);
        page2 = (PageEntity)this.pageDAO.create((Object)page2);
        DraftPageEntity dp = new DraftPageEntity();
        dp.setName("draft1");
        dp.setTargetPage(page2);
        dp.setAuthor("user1");
        dp.setCreatedDate(new Date());
        dp.setParentPage(page);
        dp.setUpdatedDate(new Date());
        this.draftPageDAO.create((Object)dp);
        List drafts1 = this.draftPageDAO.findDraftPagesByParentPage(page.getId());
        List drafts2 = this.draftPageDAO.findDraftPagesByParentPage(page2.getId());
        DraftPageDAOTest.assertNotNull((Object)drafts1);
        DraftPageDAOTest.assertEquals((int)1, (int)drafts1.size());
        DraftPageDAOTest.assertNotNull((Object)drafts2);
        DraftPageDAOTest.assertEquals((int)0, (int)drafts2.size());
        this.draftPageDAO.deleteAll();
        this.pageDAO.deleteAll();
    }

    @Test
    public void testDeleteDraftPageByTargetPage() {
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        calendar.roll(1, 1);
        Date oneYearAgo = calendar.getTime();
        WikiEntity wiki = new WikiEntity();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = (WikiEntity)this.wikiDAO.create((Object)wiki);
        PageEntity page1 = new PageEntity();
        page1.setName("page1");
        page1.setWiki(wiki);
        page1.setUpdatedDate(oneYearAgo);
        page1.setCreatedDate(oneYearAgo);
        this.pageDAO.create((Object)page1);
        PageEntity page2 = new PageEntity();
        page2.setName("page2");
        page2.setWiki(wiki);
        page2.setUpdatedDate(now);
        page2.setCreatedDate(now);
        this.pageDAO.create((Object)page2);
        DraftPageEntity dp1 = new DraftPageEntity();
        dp1.setTargetPage(page1);
        dp1.setAuthor("user1");
        dp1.setName("draft1");
        dp1.setUpdatedDate(oneYearAgo);
        dp1.setCreatedDate(oneYearAgo);
        dp1.setTargetRevision("1");
        this.draftPageDAO.create((Object)dp1);
        DraftPageEntity dp2 = new DraftPageEntity();
        dp2.setTargetPage(page2);
        dp2.setAuthor("user1");
        dp2.setName("draft2");
        dp2.setUpdatedDate(now);
        dp2.setCreatedDate(now);
        dp2.setTargetRevision("1");
        this.draftPageDAO.create((Object)dp2);
        DraftPageDAOTest.assertEquals((int)2, (int)this.draftPageDAO.findAll().size());
        DraftPageDAOTest.assertEquals((int)2, (int)this.pageDAO.findAll().size());
        this.draftPageDAO.deleteDraftPagesByTargetPage(page1.getId());
        DraftPageDAOTest.assertEquals((int)1, (int)this.draftPageDAO.findAll().size());
        DraftPageDAOTest.assertEquals((String)"draft2", (String)((DraftPageEntity)this.draftPageDAO.findAll().get(0)).getName());
        DraftPageDAOTest.assertEquals((int)2, (int)this.pageDAO.findAll().size());
        this.draftPageDAO.deleteDraftPagesByTargetPage(page2.getId());
        DraftPageDAOTest.assertEquals((int)0, (int)this.draftPageDAO.findAll().size());
        DraftPageDAOTest.assertEquals((int)2, (int)this.pageDAO.findAll().size());
        this.draftPageDAO.deleteAll();
        this.pageDAO.deleteAll();
    }

    @Test
    public void testDeleteDraftPagesByName() {
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        calendar.roll(1, 1);
        Date oneYearAgo = calendar.getTime();
        WikiEntity wiki = new WikiEntity();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = (WikiEntity)this.wikiDAO.create((Object)wiki);
        PageEntity page1 = new PageEntity();
        page1.setName("page1");
        page1.setWiki(wiki);
        page1.setUpdatedDate(oneYearAgo);
        page1.setCreatedDate(oneYearAgo);
        this.pageDAO.create((Object)page1);
        PageEntity page2 = new PageEntity();
        page2.setName("page2");
        page2.setWiki(wiki);
        page2.setUpdatedDate(now);
        page2.setCreatedDate(now);
        this.pageDAO.create((Object)page2);
        DraftPageEntity dp1 = new DraftPageEntity();
        dp1.setTargetPage(page1);
        dp1.setAuthor("user1");
        dp1.setName("draft1");
        dp1.setUpdatedDate(oneYearAgo);
        dp1.setCreatedDate(oneYearAgo);
        dp1.setTargetRevision("1");
        this.draftPageDAO.create((Object)dp1);
        DraftPageEntity dp2 = new DraftPageEntity();
        dp2.setTargetPage(page2);
        dp2.setAuthor("user1");
        dp2.setName("draft2");
        dp2.setUpdatedDate(now);
        dp2.setCreatedDate(now);
        dp2.setTargetRevision("1");
        this.draftPageDAO.create((Object)dp2);
        DraftPageDAOTest.assertEquals((int)2, (int)this.draftPageDAO.findAll().size());
        DraftPageDAOTest.assertEquals((int)2, (int)this.pageDAO.findAll().size());
        this.draftPageDAO.deleteDraftPagesByName("draft1");
        DraftPageDAOTest.assertEquals((int)1, (int)this.draftPageDAO.findAll().size());
        DraftPageDAOTest.assertEquals((String)"draft2", (String)((DraftPageEntity)this.draftPageDAO.findAll().get(0)).getName());
        DraftPageDAOTest.assertEquals((int)2, (int)this.pageDAO.findAll().size());
        this.draftPageDAO.deleteDraftPagesByName("draft2");
        DraftPageDAOTest.assertEquals((int)0, (int)this.draftPageDAO.findAll().size());
        DraftPageDAOTest.assertEquals((int)2, (int)this.pageDAO.findAll().size());
        this.draftPageDAO.deleteAll();
        this.pageDAO.deleteAll();
    }

    @Test
    public void testFindLatestDraftPageByTargetPage() throws InterruptedException {
        WikiEntity wiki = new WikiEntity();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = (WikiEntity)this.wikiDAO.create((Object)wiki);
        PageEntity page = new PageEntity();
        page.setWiki(wiki);
        page.setCreatedDate(new Date());
        page.setUpdatedDate(new Date());
        page.setName("page1");
        page = (PageEntity)this.pageDAO.create((Object)page);
        DraftPageEntity dp1 = new DraftPageEntity();
        dp1.setName("draft1");
        dp1.setTargetPage(page);
        dp1.setAuthor("user1");
        dp1.setCreatedDate(new Date());
        dp1.setUpdatedDate(new Date());
        this.draftPageDAO.create((Object)dp1);
        AbstractCoreTest.persist();
        Thread.sleep(10L);
        DraftPageEntity dp2 = new DraftPageEntity();
        dp2.setName("draft2");
        dp2.setTargetPage(page);
        dp2.setAuthor("user1");
        dp2.setCreatedDate(new Date());
        dp2.setUpdatedDate(new Date());
        this.draftPageDAO.create((Object)dp2);
        AbstractCoreTest.persist();
        DraftPageEntity latestDraft = this.draftPageDAO.findLatestDraftPageByTargetPage(Long.valueOf(page.getId()));
        DraftPageDAOTest.assertNotNull((Object)latestDraft);
        DraftPageDAOTest.assertEquals((String)dp2.getName(), (String)latestDraft.getName());
        this.draftPageDAO.deleteAll();
        this.pageDAO.deleteAll();
    }

    @Test
    public void testFindLatestDraftPageByTargetPageAndLang() {
        WikiEntity wiki = new WikiEntity();
        wiki.setType("portal");
        wiki.setOwner("wiki1");
        wiki = (WikiEntity)this.wikiDAO.create((Object)wiki);
        PageEntity page = new PageEntity();
        page.setWiki(wiki);
        page.setCreatedDate(new Date());
        page.setUpdatedDate(new Date());
        page.setName("page1");
        page = (PageEntity)this.pageDAO.create((Object)page);
        DraftPageEntity dp1 = new DraftPageEntity();
        dp1.setName("draft1");
        dp1.setTargetPage(page);
        dp1.setAuthor("user1");
        dp1.setCreatedDate(new Date());
        dp1.setUpdatedDate(new Date());
        dp1.setLang("fr");
        this.draftPageDAO.create((Object)dp1);
        DraftPageEntity dp2 = new DraftPageEntity();
        dp2.setName("draft2");
        dp2.setTargetPage(page);
        dp2.setAuthor("user1");
        dp2.setCreatedDate(new Date());
        dp2.setUpdatedDate(new Date());
        dp2.setLang("en");
        this.draftPageDAO.create((Object)dp2);
        DraftPageEntity dp3 = new DraftPageEntity();
        dp3.setName("draft3");
        dp3.setTargetPage(page);
        dp3.setAuthor("user1");
        dp3.setCreatedDate(new Date());
        dp3.setUpdatedDate(new Date());
        dp3.setLang("fr");
        this.draftPageDAO.create((Object)dp3);
        DraftPageEntity latestFrDraftPage = this.draftPageDAO.findLatestDraftPageByTargetPageAndLang(Long.valueOf(page.getId()), "fr");
        DraftPageEntity latestEnDraftPage = this.draftPageDAO.findLatestDraftPageByTargetPageAndLang(Long.valueOf(page.getId()), "en");
        DraftPageEntity latestDraftPage = this.draftPageDAO.findLatestDraftPageByTargetPageAndLang(Long.valueOf(page.getId() + 1L), null);
        DraftPageDAOTest.assertNotNull((Object)latestFrDraftPage);
        DraftPageDAOTest.assertEquals((String)dp3.getName(), (String)latestFrDraftPage.getName());
        DraftPageDAOTest.assertNotNull((Object)latestEnDraftPage);
        DraftPageDAOTest.assertEquals((String)dp2.getName(), (String)latestEnDraftPage.getName());
        DraftPageDAOTest.assertNull((Object)latestDraftPage);
        this.draftPageDAO.deleteAll();
        this.pageDAO.deleteAll();
    }
}

