/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.wiki.jpa.entity.BasePageEntity;
import org.exoplatform.wiki.jpa.entity.WikiEntity;

@Entity(name="WikiTemplateEntity")
@ExoEntity
@Table(name="WIKI_TEMPLATES")
@NamedQueries(value={@NamedQuery(name="template.getTemplatesOfWiki", query="SELECT t FROM WikiTemplateEntity t JOIN t.wiki w WHERE w.type = :type AND w.owner = :owner"), @NamedQuery(name="template.getTemplateOfWikiByName", query="SELECT t FROM WikiTemplateEntity t JOIN t.wiki w WHERE t.name = :name AND w.type = :type AND w.owner = :owner"), @NamedQuery(name="template.searchTemplatesByTitle", query="SELECT t FROM WikiTemplateEntity t JOIN t.wiki w WHERE w.type = :type AND w.owner = :owner AND t.title like :searchText"), @NamedQuery(name="template.getAllTemplatesBySyntax", query="SELECT t FROM WikiTemplateEntity t WHERE t.syntax = :syntax OR t.syntax IS NULL ORDER BY t.updatedDate DESC"), @NamedQuery(name="template.countAllTemplatesBySyntax", query="SELECT COUNT(t) FROM WikiTemplateEntity t WHERE t.syntax = :syntax OR t.syntax IS NULL")})
public class TemplateEntity
extends BasePageEntity {
    @Id
    @SequenceGenerator(name="SEQ_WIKI_TEMPLATES_TEMPLATE_ID", sequenceName="SEQ_WIKI_TEMPLATES_TEMPLATE_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_WIKI_TEMPLATES_TEMPLATE_ID")
    @Column(name="TEMPLATE_ID")
    private long id;
    @Column(name="DESCRIPTION")
    private String description;
    @ManyToOne
    @JoinColumn(name="WIKI_ID")
    private WikiEntity wiki;

    public long getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WikiEntity getWiki() {
        return this.wiki;
    }

    public void setWiki(WikiEntity wiki) {
        this.wiki = wiki;
    }
}

