/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.notes.listener.analytics;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.service.NoteService;

public class NotesMetadataListener
extends Listener<Long, MetadataItem> {
    private final NoteService noteService;
    private final SpaceService spaceService;

    public NotesMetadataListener(NoteService noteService, SpaceService spaceService) {
        this.noteService = noteService;
        this.spaceService = spaceService;
    }

    public void onEvent(Event<Long, MetadataItem> event) throws Exception {
        Page note;
        ConversationState conversationstate = ConversationState.getCurrent();
        Identity currentIdentity = conversationstate == null || conversationstate.getIdentity() == null ? null : conversationstate.getIdentity();
        MetadataItem metadataItem = (MetadataItem)event.getData();
        String objectType = ((MetadataItem)event.getData()).getObjectType();
        String objectId = metadataItem.getObjectId();
        if (StringUtils.equals((CharSequence)objectType, (CharSequence)"notes") && currentIdentity != null && (note = this.noteService.getNoteById(objectId)) != null) {
            StatisticData statisticData = new StatisticData();
            statisticData.setModule("portal");
            statisticData.setSubModule("ui");
            statisticData.setOperation("Bookmark");
            statisticData.addParameter("type", (Object)"Notes");
            if (StringUtils.isNotBlank((CharSequence)note.getWikiOwner())) {
                Space space = this.spaceService.getSpaceByGroupId(note.getWikiOwner());
                statisticData.setSpaceId(Long.parseLong(space.getId()));
            }
            statisticData.addParameter("wikiPageId", (Object)note.getId());
            statisticData.setUserId(AnalyticsUtils.getUserIdentityId((String)currentIdentity.getUserId()));
            AnalyticsUtils.addStatisticData((StatisticData)statisticData);
        }
    }
}

