/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.nps.services;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.nps.dto.NPSDetailsDTO;
import org.exoplatform.nps.dto.ScoreEntryDTO;
import org.exoplatform.nps.dto.ScoreTypeDTO;
import org.exoplatform.nps.services.NpsService;
import org.exoplatform.nps.services.NpsTypeService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class Utils {
    private static Log log = ExoLogger.getLogger(Utils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Calendar getFirstLoginDate(String userId) throws Exception {
        RepositoryService repositoryService = (RepositoryService)CommonsUtils.getService(RepositoryService.class);
        try (SessionProvider sessionProvider = SessionProvider.createSystemProvider();){
            Session session = sessionProvider.getSession("collaboration", repositoryService.getCurrentRepository());
            String path = "exo:LoginHistoryHome/" + userId;
            Node rootNode = session.getRootNode();
            if (rootNode.hasNode(path)) {
                Node att = rootNode.getNode(path);
                Calendar calendar = att.getProperty("exo:dateCreated").getDate();
                return calendar;
            }
            Calendar calendar = null;
            return calendar;
        }
        return null;
    }

    public static int getDiffinDays(Calendar startCal, Calendar stopCal) throws Exception {
        long startMillis = startCal.getTimeInMillis();
        DateTime startDateTime = new DateTime(startMillis);
        long stopMillis = stopCal.getTimeInMillis();
        DateTime stopDateTime = new DateTime(stopMillis);
        LocalDate start = startDateTime.toLocalDate();
        LocalDate stop = stopDateTime.toLocalDate();
        return Days.daysBetween((ReadablePartial)start, (ReadablePartial)stop).getDays();
    }

    public static void createActivity(ScoreEntryDTO score) {
        NpsTypeService npsTypeService = (NpsTypeService)CommonsUtils.getService(NpsTypeService.class);
        ScoreTypeDTO scoreType = npsTypeService.getScoreType(score.getTypeId());
        if (scoreType != null && scoreType.getLinkedToSpace() != null && scoreType.getLinkedToSpace().booleanValue()) {
            SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
            IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
            ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
            Space space = spaceService.getSpaceByPrettyName(scoreType.getSpaceId());
            Identity spaceIdentity = identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
            Identity posterIdentity = identityManager.getOrCreateIdentity("organization", scoreType.getUserId(), false);
            String userName = "Anonymous";
            if (score.getUserId() != null && !"".equals(score.getUserId())) {
                Identity userIdentity = identityManager.getOrCreateIdentity("organization", score.getUserId(), false);
                userName = userIdentity != null ? userIdentity.getProfile().getFullName() : score.getUserId();
            }
            if (posterIdentity != null && spaceIdentity != null) {
                ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
                activity.setType("DEFAULT_ACTIVITY");
                activity.setTitle("<span id='npsActivity'>\nA new response has been added to the " + scoreType.getTypeName() + " survey: <br/>\n <b>User Name : </b>" + userName + "<br/>\n <b>Score : </b>" + score.getScore() + "<br/>\n <b>Comment: </b>" + score.getComment() + "<br/>");
                activity.setUserId(posterIdentity.getId());
                activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
            } else {
                log.warn((Object)"Not able to create the activity, the Poster or Space Identity is missing");
            }
        }
    }

    public static NPSDetailsDTO calculateNpsByDate(long typeId, long date) {
        NpsService npsService = (NpsService)CommonsUtils.getService(NpsService.class);
        long scorsnbr = npsService.getScoreCountByDate(typeId, date);
        long detractorsNbr = npsService.getDetractorsCountByDate(typeId, date);
        long promotersNbr = npsService.getPromotersCountByDate(typeId, date);
        long passivesNbr = scorsnbr - (promotersNbr + detractorsNbr);
        return new NPSDetailsDTO(typeId, date, scorsnbr, detractorsNbr, promotersNbr, passivesNbr);
    }

    public static List<NPSDetailsDTO> getWeeklyNPSbyDates(long typeId, long fromDate, long toDate) {
        NpsService npsService = (NpsService)CommonsUtils.getService(NpsService.class);
        ArrayList<NPSDetailsDTO> NPSScors = new ArrayList<NPSDetailsDTO>();
        ScoreEntryDTO score = npsService.getFirstScoreEntries(typeId);
        if (score != null) {
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(fromDate);
            Calendar c_ = Calendar.getInstance();
            c_.setTimeInMillis(score.getPostedTime());
            if (c.before(c_)) {
                c.setTime(c_.getTime());
            }
            int diff = 7 - c.get(7);
            c.add(5, diff);
            while (c.getTimeInMillis() < toDate) {
                NPSScors.add(Utils.calculateNpsByDate(typeId, c.getTimeInMillis()));
                c.add(5, 7);
            }
            if (c.getTimeInMillis() != toDate) {
                NPSScors.add(Utils.calculateNpsByDate(typeId, toDate));
            }
        }
        return NPSScors;
    }

    public static List<NPSDetailsDTO> getWeeklyNPS(long typeId) {
        NpsService npsService = (NpsService)CommonsUtils.getService(NpsService.class);
        ArrayList<NPSDetailsDTO> NPSScors = new ArrayList<NPSDetailsDTO>();
        ScoreEntryDTO score = npsService.getFirstScoreEntries(typeId);
        if (score != null) {
            Calendar fromDate = Calendar.getInstance();
            fromDate.setTimeInMillis(score.getPostedTime());
            int diff = 7 - fromDate.get(7);
            fromDate.add(5, diff);
            Calendar toDate = Calendar.getInstance();
            while (fromDate.before(toDate)) {
                NPSScors.add(Utils.calculateNpsByDate(typeId, fromDate.getTimeInMillis()));
                fromDate.add(5, 7);
            }
            if (fromDate.after(toDate)) {
                NPSScors.add(Utils.calculateNpsByDate(typeId, fromDate.getTimeInMillis()));
            }
        }
        return NPSScors;
    }
}

