/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.nps.dao;

import java.util.List;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.nps.entity.ScoreTypeEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScoreTypeDAO
extends GenericDAOJPAImpl<ScoreTypeEntity, String> {
    private static final Logger LOG = LoggerFactory.getLogger(ScoreTypeDAO.class);

    public List<ScoreTypeEntity> getScoreTypes(int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("scoreTypeEntity.findAllOrderBy", ScoreTypeEntity.class).setFirstResult(offset).setMaxResults(limit).getResultList();
            }
            return this.findAll();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get score Types with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public long getScoreTypesCount() {
        try {
            return (Long)this.getEntityManager().createNamedQuery("scoreTypeEntity.count", Long.class).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scoreTypes count.", (Throwable)e);
            throw e;
        }
    }

    public List<ScoreTypeEntity> getScoreTypebyId(long id) {
        try {
            return this.getEntityManager().createNamedQuery("scoreTypeEntity.findById", ScoreTypeEntity.class).setParameter("id", (Object)id).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }
}

