/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.nps.dao;

import java.util.List;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.nps.entity.ScoreEntryEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScoreEntryDAO
extends GenericDAOJPAImpl<ScoreEntryEntity, String> {
    private static final Logger LOG = LoggerFactory.getLogger(ScoreEntryDAO.class);

    public List<ScoreEntryEntity> getAllScoreEntries(long typeId, int offset, int limit, long startDate, long endDate) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("scoreEntryEntity.findAllOrderByDesc", ScoreEntryEntity.class).setFirstResult(offset).setMaxResults(limit).setParameter("typeId", (Object)typeId).setParameter("startDate", (Object)startDate).setParameter("endDate", (Object)endDate).getResultList();
            }
            return this.getEntityManager().createNamedQuery("scoreEntryEntity.findAllOrderByDesc", ScoreEntryEntity.class).setParameter("typeId", (Object)typeId).setParameter("startDate", (Object)startDate).setParameter("endDate", (Object)endDate).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scores with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<ScoreEntryEntity> getAllPassiveScoreEntries(long typeId, int offset, int limit, long startDate, long endDate) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("scoreEntryEntity.findAllPassives", ScoreEntryEntity.class).setFirstResult(offset).setMaxResults(limit).setParameter("typeId", (Object)typeId).setParameter("startDate", (Object)startDate).setParameter("endDate", (Object)endDate).getResultList();
            }
            return this.getEntityManager().createNamedQuery("scoreEntryEntity.findAllPassives", ScoreEntryEntity.class).setParameter("typeId", (Object)typeId).setParameter("startDate", (Object)startDate).setParameter("endDate", (Object)endDate).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scores with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<ScoreEntryEntity> getAllPromoterScoreEntries(long typeId, int offset, int limit, long startDate, long endDate) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("scoreEntryEntity.findAllPromoters", ScoreEntryEntity.class).setFirstResult(offset).setMaxResults(limit).setParameter("typeId", (Object)typeId).setParameter("startDate", (Object)startDate).setParameter("endDate", (Object)endDate).getResultList();
            }
            return this.getEntityManager().createNamedQuery("scoreEntryEntity.findAllPromoters", ScoreEntryEntity.class).setParameter("typeId", (Object)typeId).setParameter("startDate", (Object)startDate).setParameter("endDate", (Object)endDate).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scores with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<ScoreEntryEntity> getAllDetractorScoreEntries(long typeId, int offset, int limit, long startDate, long endDate) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("scoreEntryEntity.findAllDetractors", ScoreEntryEntity.class).setFirstResult(offset).setMaxResults(limit).setParameter("typeId", (Object)typeId).setParameter("startDate", (Object)startDate).setParameter("endDate", (Object)endDate).getResultList();
            }
            return this.getEntityManager().createNamedQuery("scoreEntryEntity.findAllDetractors", ScoreEntryEntity.class).setParameter("typeId", (Object)typeId).setParameter("startDate", (Object)startDate).setParameter("endDate", (Object)endDate).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scores with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<ScoreEntryEntity> getFirstScoreEntries(long typeId) {
        try {
            return this.getEntityManager().createNamedQuery("scoreEntryEntity.findAllOrderByAsc", ScoreEntryEntity.class).setParameter("typeId", (Object)typeId).setFirstResult(0).setMaxResults(1).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get first scores", (Throwable)e);
            throw e;
        }
    }

    public long getScoreEntriesCount(long typeId, boolean enabled, long startDate, long endDate) {
        try {
            if (enabled) {
                return (Long)this.getEntityManager().createNamedQuery("scoreEntryEntity.countEnabled", Long.class).setParameter("typeId", (Object)typeId).setParameter("startDate", (Object)startDate).setParameter("endDate", (Object)endDate).getSingleResult();
            }
            return (Long)this.getEntityManager().createNamedQuery("scoreEntryEntity.countAllresponded", Long.class).setParameter("typeId", (Object)typeId).setParameter("startDate", (Object)startDate).setParameter("endDate", (Object)endDate).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scores count.", (Throwable)e);
            throw e;
        }
    }

    public long getPromotersCount(long typeId, boolean enabled, long startDate, long endDate) {
        try {
            if (enabled) {
                return (Long)this.getEntityManager().createNamedQuery("scoreEntryEntity.countEnabledPromoters", Long.class).setParameter("typeId", (Object)typeId).setParameter("startDate", (Object)startDate).setParameter("endDate", (Object)endDate).getSingleResult();
            }
            return (Long)this.getEntityManager().createNamedQuery("scoreEntryEntity.countAllPromoters", Long.class).setParameter("typeId", (Object)typeId).setParameter("startDate", (Object)startDate).setParameter("endDate", (Object)endDate).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scores count.", (Throwable)e);
            throw e;
        }
    }

    public long getDetractorsCount(long typeId, boolean enabled, long startDate, long endDate) {
        try {
            if (enabled) {
                return (Long)this.getEntityManager().createNamedQuery("scoreEntryEntity.countEnabledDetractors", Long.class).setParameter("typeId", (Object)typeId).setParameter("startDate", (Object)startDate).setParameter("endDate", (Object)endDate).getSingleResult();
            }
            return (Long)this.getEntityManager().createNamedQuery("scoreEntryEntity.countAllDetractors", Long.class).setParameter("typeId", (Object)typeId).setParameter("startDate", (Object)startDate).setParameter("endDate", (Object)endDate).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scores count.", (Throwable)e);
            throw e;
        }
    }

    public long getEnabledScoreEntriesCountByDate(long typeId, long toDate) {
        try {
            return (Long)this.getEntityManager().createNamedQuery("scoreEntryEntity.countEnabledByDate", Long.class).setParameter("typeId", (Object)typeId).setParameter("toDate", (Object)toDate).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scores count.", (Throwable)e);
            throw e;
        }
    }

    public long getEnabledPromotersCountByDate(long typeId, long toDate) {
        try {
            return (Long)this.getEntityManager().createNamedQuery("scoreEntryEntity.countEnabledPromotersByDate", Long.class).setParameter("typeId", (Object)typeId).setParameter("toDate", (Object)toDate).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scores count.", (Throwable)e);
            throw e;
        }
    }

    public long getEnabledDetractorsCountByDate(long typeId, long toDate) {
        try {
            return (Long)this.getEntityManager().createNamedQuery("scoreEntryEntity.countEnabledDetractorsByDate", Long.class).setParameter("typeId", (Object)typeId).setParameter("toDate", (Object)toDate).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scores count.", (Throwable)e);
            throw e;
        }
    }

    public long getEnabledScoreEntriesCountByPeriod(long typeId, long fromDate, long toDate) {
        try {
            return (Long)this.getEntityManager().createNamedQuery("scoreEntryEntity.countEnabledByPeriod", Long.class).setParameter("typeId", (Object)typeId).setParameter("fromDate", (Object)fromDate).setParameter("toDate", (Object)toDate).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scores count.", (Throwable)e);
            throw e;
        }
    }

    public long getEnabledPromotersCountByPeriod(long typeId, long fromDate, long toDate) {
        try {
            return (Long)this.getEntityManager().createNamedQuery("scoreEntryEntity.countEnabledPromotersByPeriod", Long.class).setParameter("typeId", (Object)typeId).setParameter("fromDate", (Object)fromDate).setParameter("toDate", (Object)toDate).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scores count.", (Throwable)e);
            throw e;
        }
    }

    public long getEnabledDetractorsCountByPeriod(long typeId, long fromDate, long toDate) {
        try {
            return (Long)this.getEntityManager().createNamedQuery("scoreEntryEntity.countEnabledDetractorsByPeriod", Long.class).setParameter("typeId", (Object)typeId).setParameter("fromDate", (Object)fromDate).setParameter("toDate", (Object)toDate).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scores count.", (Throwable)e);
            throw e;
        }
    }

    public List<ScoreEntryEntity> getScoreEntriesByUserId(long typeId, String userId, int offset, int limit, long startDate, long endDate) {
        try {
            if (offset >= 0 && limit > 0) {
                return this.getEntityManager().createNamedQuery("scoreEntryEntity.findByUserId", ScoreEntryEntity.class).setFirstResult(offset).setMaxResults(limit).setParameter("userId", (Object)userId).setParameter("typeId", (Object)typeId).setParameter("startDate", (Object)startDate).setParameter("endDate", (Object)endDate).getResultList();
            }
            return this.getEntityManager().createNamedQuery("scoreEntryEntity.findByUserId", ScoreEntryEntity.class).setParameter("userId", (Object)userId).setParameter("typeId", (Object)typeId).setParameter("startDate", (Object)startDate).setParameter("endDate", (Object)endDate).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scores with offset = '" + offset + "' and limit = '" + limit + "'.", (Throwable)e);
            throw e;
        }
    }

    public List<ScoreEntryEntity> getScoreEntrybyId(long id) {
        try {
            return this.getEntityManager().createNamedQuery("scoreEntryEntity.findById", ScoreEntryEntity.class).setParameter("id", (Object)id).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public List<Object[]> countEnabledGroupdByScores(long typeId, Long startDate, Long endDate) {
        try {
            return this.getEntityManager().createNamedQuery("scoreEntryEntity.countEnabledGroupdByScores", Object[].class).setParameter("typeId", (Object)typeId).setParameter("startDate", (Object)startDate).setParameter("endDate", (Object)endDate).getResultList();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public double getEnabledScoresAvg(long typeId, long startDate, long endDate) {
        try {
            return (Double)this.getEntityManager().createNamedQuery("scoreEntryEntity.avgEnabled", Double.class).setParameter("typeId", (Object)typeId).setParameter("startDate", (Object)startDate).setParameter("endDate", (Object)endDate).getSingleResult();
        }
        catch (NullPointerException e) {
            return 0.0;
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get request", (Throwable)e);
            throw e;
        }
    }

    public long getAllCount(long typeId, long startDate, long endDate) {
        try {
            return (Long)this.getEntityManager().createNamedQuery("scoreEntryEntity.countAll", Long.class).setParameter("typeId", (Object)typeId).setParameter("startDate", (Object)startDate).setParameter("endDate", (Object)endDate).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn("Exception while attempting to get scores count.", (Throwable)e);
            throw e;
        }
    }
}

