/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.nps.services.rest;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.nps.dto.NPSDetailsDTO;
import org.exoplatform.nps.dto.ScoreEntryDTO;
import org.exoplatform.nps.services.NpsService;
import org.exoplatform.nps.services.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.RestChecker;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="/nps")
@Produces(value={"application/json"})
public class NpsRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(NpsRestService.class);
    private static final String[] SUPPORTED_FORMATS = new String[]{"json"};
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private OrganizationService organizationService;

    public NpsRestService(IdentityManager identityManager, SpaceService spaceService, OrganizationService organizationService) {
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.organizationService = organizationService;
    }

    @GET
    @Path(value="users/find")
    @RolesAllowed(value={"users"})
    @Consumes(value={"application/json"})
    public Response find(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="nameToSearch") String nameToSearch, @QueryParam(value="spaceURL") String spaceURL, @QueryParam(value="currentUser") String currentUser) throws Exception {
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            List profiles;
            JSONArray users = new JSONArray();
            Space space = this.spaceService.getSpaceByUrl(spaceURL);
            if (space != null && (profiles = this.getSpaceMembersProfiles(space).stream().filter(a -> a.getFullName().toLowerCase().contains(nameToSearch.toLowerCase())).collect(Collectors.toList())) != null && profiles.size() > 0) {
                for (Profile profile : profiles) {
                    JSONObject user = new JSONObject();
                    user.put("value", (Object)profile.getIdentity().getRemoteId());
                    user.put("type", (Object)"user");
                    user.put("invalid", false);
                    user.put("order", (Object)"1");
                    if (profile.getAvatarUrl() != null) {
                        user.put("avatarUrl", (Object)profile.getAvatarUrl());
                    } else {
                        user.put("avatarUrl", (Object)"/eXoSkin/skin/images/system/UserAvtDefault.png");
                    }
                    user.put("text", (Object)(profile.getFullName() + " (" + profile.getIdentity().getRemoteId() + ")"));
                    users.put((Object)user);
                }
            }
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("options", (Object)users);
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="spaces/find")
    @RolesAllowed(value={"users"})
    @Consumes(value={"application/json"})
    public Response findspace(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="nameToSearch") String nameToSearch, @QueryParam(value="currentUser") String currentUser) throws Exception {
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            List<Object> spacesList;
            List spaces_;
            JSONArray spaces = new JSONArray();
            ListAccess spacesListAcc = this.spaceService.getMemberSpaces(currentUser);
            if (spacesListAcc.getSize() > 0 && (spaces_ = (spacesList = Arrays.asList(spacesListAcc.load(0, spacesListAcc.getSize()))).stream().filter(a -> a.getDisplayName().toLowerCase().contains(nameToSearch.toLowerCase())).collect(Collectors.toList())) != null && spaces_.size() > 0) {
                for (Space space_ : spaces_) {
                    JSONObject space = new JSONObject();
                    space.put("value", (Object)space_.getPrettyName());
                    space.put("type", (Object)"space");
                    space.put("invalid", false);
                    space.put("order", (Object)"1");
                    if (space_.getAvatarUrl() != null) {
                        space.put("avatarUrl", (Object)space_.getAvatarUrl());
                    } else {
                        space.put("avatarUrl", (Object)"/eXoSkin/skin/images/system/SpaceAvtDefault.png");
                    }
                    space.put("text", (Object)(space_.getDisplayName() + " (" + space_.getPrettyName() + ")"));
                    spaces.put((Object)space);
                }
            }
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("options", (Object)spaces);
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    private List<Profile> getSpaceMembersProfiles(Space space) {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        for (String userId : space.getMembers()) {
            Profile userProfile = this.identityManager.getOrCreateIdentity("organization", userId, false).getProfile();
            profiles.add(userProfile);
        }
        return profiles;
    }

    @GET
    @Path(value="scores/weekly")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response findspace(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="npsTypeId") long npsTypeId, @QueryParam(value="fromDate") long fromDate, @QueryParam(value="toDate") long toDate) throws Exception {
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        SimpleDateFormat dt1 = new SimpleDateFormat("yyyy-MM-dd");
        try {
            JSONArray npsList = new JSONArray();
            List<NPSDetailsDTO> npsDetails = Utils.getWeeklyNPSbyDates(npsTypeId, fromDate, toDate);
            for (NPSDetailsDTO nps : npsDetails) {
                JSONObject nps_ = new JSONObject();
                nps_.put("npsDate", (Object)dt1.format(nps.getNpsToDate()));
                nps_.put("score", (Object)String.format("%.2f", Float.valueOf(nps.getNpScore())));
                npsList.put((Object)nps_);
            }
            return Response.ok((Object)npsList.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="scores/all/{npsTypeId}")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response getAllScores(@Context HttpServletRequest request, @Context UriInfo uriInfo, @PathParam(value="npsTypeId") long npsTypeId, @QueryParam(value="fromDate") long fromDate, @QueryParam(value="toDate") long toDate) throws Exception {
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        SimpleDateFormat dt1 = new SimpleDateFormat("yyyy-mm-dd hh:mm:ss");
        NpsService npsService = (NpsService)CommonsUtils.getService(NpsService.class);
        try {
            JSONArray npsList = new JSONArray();
            if (fromDate == 0L) {
                ScoreEntryDTO score = npsService.getFirstScoreEntries(npsTypeId);
                fromDate = score.getPostedTime();
            }
            if (toDate == 0L) {
                toDate = Calendar.getInstance().getTimeInMillis();
            }
            List<ScoreEntryDTO> npsDetails = npsService.getScores(npsTypeId, 0, 0, fromDate, toDate);
            for (ScoreEntryDTO nps : npsDetails) {
                try {
                    JSONObject nps_ = new JSONObject();
                    nps_.put("npsDate", (Object)dt1.format(nps.getPostedTime()));
                    nps_.put("score", nps.getScore());
                    nps_.put("userId", (Object)nps.getUserId());
                    Profile profile = this.identityManager.getOrCreateIdentity("organization", nps.getUserId(), false).getProfile();
                    nps_.put("userFullName", (Object)profile.getFullName());
                    nps_.put("userEmail", (Object)profile.getEmail());
                    npsList.put((Object)nps_);
                }
                catch (Exception e) {
                    LOG.error((Object)e.getMessage());
                }
            }
            return Response.ok((Object)npsList.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }
}

