/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.nps.portlet.npsAdministration;

import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.inject.Inject;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.impl.common.JSON;
import juzu.plugin.jackson.Jackson;
import juzu.template.Template;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.nps.dto.ScoreEntryDTO;
import org.exoplatform.nps.services.NpsService;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;

public class NPSAdministrationController {
    private static Log LOG = ExoLogger.getLogger(NPSAdministrationController.class);
    private String bundleString;
    ResourceBundle bundle;
    @Inject
    NpsService npsService;
    @Inject
    IdentityManager identityManager;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;
    private final String currentUser = ConversationState.getCurrent().getIdentity().getUserId();

    @View
    public Response.Content index() {
        return this.indexTmpl.ok();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<ScoreEntryDTO> getScores(int offset, int limit) {
        try {
            List scores = this.npsService.getScores(offset, limit);
            for (ScoreEntryDTO score : scores) {
                Profile profile = this.identityManager.getOrCreateIdentity("organization", score.getUserId(), false).getProfile();
                score.setUserFullName(profile.getFullName());
            }
            return scores;
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getBundle() {
        try {
            if (!PropertyManager.isDevelopping() && this.bundleString != null && this.getResourceBundle().getLocale().equals(PortalRequestContext.getCurrentInstance().getLocale())) {
                return Response.ok((CharSequence)this.bundleString);
            }
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
            JSON data = new JSON();
            Enumeration<String> enumeration = this.getResourceBundle().getKeys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                try {
                    data.set(key.replaceAll("(.*)\\.", ""), this.getResourceBundle().getObject(key));
                }
                catch (MissingResourceException missingResourceException) {}
            }
            data.set("currentUser", (Object)this.currentUser);
            this.bundleString = data.toString();
            return Response.ok((CharSequence)this.bundleString);
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting categories", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getData() {
        try {
            JSON data = new JSON();
            data.set("currentUser", (Object)this.currentUser);
            Profile profile = this.identityManager.getOrCreateIdentity("organization", this.currentUser, false).getProfile();
            if (profile.getAvatarUrl() != null) {
                data.set("currentUserAvatar", (Object)profile.getAvatarUrl());
            } else {
                data.set("currentUserAvatar", (Object)"/eXoSkin/skin/images/system/UserAvtDefault.png");
            }
            data.set("currentUserName", (Object)profile.getFullName());
            long scorsnbr = this.npsService.getScoreCount();
            long detractorsNbr = this.npsService.getDetractorsCount();
            long promotersNbr = this.npsService.getPromotersCount();
            long passivesNbr = scorsnbr - (promotersNbr + detractorsNbr);
            float detractorsPrc = (float)detractorsNbr / (float)scorsnbr * 100.0f;
            float promotersPrc = (float)promotersNbr / (float)scorsnbr * 100.0f;
            float passivesPrc = (float)passivesNbr / (float)scorsnbr * 100.0f;
            float npScore = promotersPrc - detractorsPrc;
            data.set("scorsnbr", (Object)scorsnbr);
            data.set("detractorsNbr", (Object)detractorsNbr);
            data.set("promotersNbr", (Object)promotersNbr);
            data.set("passivesNbr", (Object)passivesNbr);
            data.set("detractorsPrc", (Object)String.format("%.2f", Float.valueOf(detractorsPrc)));
            data.set("promotersPrc", (Object)String.format("%.2f", Float.valueOf(promotersPrc)));
            data.set("passivesPrc", (Object)String.format("%.2f", Float.valueOf(passivesPrc)));
            data.set("npScore", (Object)String.format("%.2f", Float.valueOf(npScore)));
            return Response.ok((CharSequence)data.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        this.bundle = ResourceBundle.getBundle("locale.portlet.nps-addon", locale, this.getClass().getClassLoader());
        return this.bundle;
    }

    private ResourceBundle getResourceBundle() {
        if (this.bundle == null) {
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
        }
        return this.bundle;
    }
}

