/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.nps.portlet.npsAdministration;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.inject.Inject;
import juzu.HttpMethod;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.impl.common.JSON;
import juzu.plugin.jackson.Jackson;
import juzu.template.Template;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.nps.dto.NPSDetailsDTO;
import org.exoplatform.nps.dto.ScoreEntryDTO;
import org.exoplatform.nps.dto.ScoreTypeDTO;
import org.exoplatform.nps.services.NpsService;
import org.exoplatform.nps.services.NpsTypeService;
import org.exoplatform.nps.services.Utils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.json.JSONArray;
import org.json.JSONObject;

public class NPSAdministrationController {
    private static Log LOG = ExoLogger.getLogger(NPSAdministrationController.class);
    private String bundleString;
    ResourceBundle bundle;
    @Inject
    NpsService npsService;
    @Inject
    NpsTypeService npsTypeService;
    @Inject
    IdentityManager identityManager;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;
    private final String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
    SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");

    @View
    public Response.Content index() {
        return this.indexTmpl.ok();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<ScoreEntryDTO> getScores(Long typeId, int offset, int limit) {
        try {
            List scores = this.npsService.getScores(typeId.longValue(), offset, limit);
            for (ScoreEntryDTO score : scores) {
                if (score.getUserId() == null || score.getUserId().equals("")) continue;
                Profile profile = this.identityManager.getOrCreateIdentity("organization", score.getUserId(), false).getProfile();
                score.setUserFullName(profile.getFullName());
            }
            return scores;
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getBundle() {
        try {
            if (!PropertyManager.isDevelopping() && this.bundleString != null && this.getResourceBundle().getLocale().equals(PortalRequestContext.getCurrentInstance().getLocale())) {
                return Response.ok((CharSequence)this.bundleString);
            }
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
            JSON data = new JSON();
            Enumeration<String> enumeration = this.getResourceBundle().getKeys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                try {
                    data.set(key.replaceAll("(.*)\\.", ""), this.getResourceBundle().getObject(key));
                }
                catch (MissingResourceException missingResourceException) {}
            }
            data.set("currentUser", (Object)this.currentUser);
            this.bundleString = data.toString();
            return Response.ok((CharSequence)this.bundleString);
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting categories", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getData(Long typeId) {
        try {
            JSON data = new JSON();
            long scorsnbr = this.npsService.getScoreCount(typeId.longValue(), true);
            long detractorsNbr = this.npsService.getDetractorsCount(typeId.longValue());
            long promotersNbr = this.npsService.getPromotersCount(typeId.longValue());
            long passivesNbr = scorsnbr - (promotersNbr + detractorsNbr);
            float detractorsPrc = (float)detractorsNbr / (float)scorsnbr * 100.0f;
            float promotersPrc = (float)promotersNbr / (float)scorsnbr * 100.0f;
            float passivesPrc = (float)passivesNbr / (float)scorsnbr * 100.0f;
            float npScore = promotersPrc - detractorsPrc;
            data.set("scorsnbr", (Object)this.npsService.getScoreCount(typeId.longValue(), false));
            data.set("detractorsNbr", (Object)detractorsNbr);
            data.set("promotersNbr", (Object)promotersNbr);
            data.set("passivesNbr", (Object)passivesNbr);
            data.set("detractorsPrc", (Object)String.format("%.2f", Float.valueOf(detractorsPrc)));
            data.set("promotersPrc", (Object)String.format("%.2f", Float.valueOf(promotersPrc)));
            data.set("passivesPrc", (Object)String.format("%.2f", Float.valueOf(passivesPrc)));
            data.set("npScore", (Object)String.format("%.2f", Float.valueOf(npScore)));
            return Response.ok((CharSequence)data.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getNPSLineChart(Long typeId, String chartType) {
        if (chartType.equals("global")) {
            return this.getWeeklyNPS(typeId);
        }
        if (chartType.equals("weeklyOver")) {
            return this.getNPSByWeek(typeId);
        }
        if (chartType.equals("monthlyOver")) {
            return this.getNPSByMonth(typeId);
        }
        if (chartType.equals("rolling30")) {
            return this.getRollingAvg(typeId, 30);
        }
        if (chartType.equals("rolling7")) {
            return this.getRollingAvg(typeId, 7);
        }
        return Response.notFound();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getWeeklyNPS(Long typeId) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
            JSONArray npsList = new JSONArray();
            List npsDetails = Utils.getWeeklyNPS((long)typeId);
            for (NPSDetailsDTO nps : npsDetails) {
                JSONObject nps_ = new JSONObject();
                Calendar c = Calendar.getInstance();
                c.setTimeInMillis(nps.getNpsToDate());
                nps_.put("npsDate", (Object)("W: " + c.get(3) + "-" + c.get(1)));
                nps_.put("npsDetails", (Object)(String.format("%.2f", Float.valueOf(nps.getNpScore())) + " ( Week: " + c.get(3) + "-" + c.get(1) + "Detractors: " + nps.getDetractorsNbr() + ", Passives: " + nps.getPassivesNb() + ", Promoters: " + nps.getPromotersNbr() + ")"));
                nps_.put("score", (Object)String.format("%.2f", Float.valueOf(nps.getNpScore())));
                npsList.put((Object)nps_);
            }
            return Response.ok((CharSequence)npsList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getNPSByWeek(Long typeId) {
        try {
            JSONArray npsList = new JSONArray();
            List npsDetails = Utils.getNPSByWeek((long)typeId);
            for (NPSDetailsDTO nps : npsDetails) {
                JSONObject nps_ = new JSONObject();
                nps_.put("npsDate", (Object)this.sdf.format(nps.getNpsToDate()));
                nps_.put("npsDetails", (Object)Utils.npsToString((NPSDetailsDTO)nps));
                nps_.put("score", (Object)String.format("%.2f", Float.valueOf(nps.getNpScore())));
                npsList.put((Object)nps_);
            }
            return Response.ok((CharSequence)npsList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getNPSByMonth(Long typeId) {
        try {
            JSONArray npsList = new JSONArray();
            List npsDetails = Utils.getNPSByMonth((long)typeId);
            for (NPSDetailsDTO nps : npsDetails) {
                JSONObject nps_ = new JSONObject();
                nps_.put("npsDate", (Object)this.sdf.format(nps.getNpsToDate()));
                nps_.put("npsDetails", (Object)Utils.npsToString((NPSDetailsDTO)nps));
                nps_.put("score", (Object)String.format("%.2f", Float.valueOf(nps.getNpScore())));
                npsList.put((Object)nps_);
            }
            return Response.ok((CharSequence)npsList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getRollingAvg(Long typeId, int period) {
        try {
            JSONArray npsList = new JSONArray();
            List npsDetails = Utils.getRollingAvg((long)typeId, (int)period);
            for (NPSDetailsDTO nps : npsDetails) {
                JSONObject nps_ = new JSONObject();
                nps_.put("npsDate", (Object)this.sdf.format(nps.getNpsToDate()));
                nps_.put("npsDetails", (Object)Utils.npsToString((NPSDetailsDTO)nps));
                nps_.put("score", (Object)String.format("%.2f", Float.valueOf(nps.getNpScore())));
                npsList.put((Object)nps_);
            }
            return Response.ok((CharSequence)npsList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<ScoreTypeDTO> getScoreTypes() {
        try {
            return this.npsTypeService.getScoreTypes(0, 0);
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public ScoreTypeDTO getScoreTypeById(Long id) {
        return this.npsTypeService.getScoreType(id.longValue());
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void saveType(@Jackson ScoreTypeDTO obj) {
        if (obj.getAnonymous() == null) {
            obj.setAnonymous(Boolean.valueOf(false));
        }
        this.npsTypeService.save(obj, true);
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void updateType(@Jackson ScoreTypeDTO obj) {
        this.npsTypeService.save(obj, false);
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void deleteScore(@Jackson ScoreEntryDTO obj) {
        this.npsService.remove(obj);
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void disableScore(@Jackson ScoreEntryDTO obj) {
        obj.setEnabled(Boolean.valueOf(false));
        this.npsService.save(obj, false);
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void enableScore(@Jackson ScoreEntryDTO obj) {
        obj.setEnabled(Boolean.valueOf(true));
        this.npsService.save(obj, false);
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        this.bundle = ResourceBundle.getBundle("locale.portlet.nps-addon", locale, this.getClass().getClassLoader());
        return this.bundle;
    }

    private ResourceBundle getResourceBundle() {
        if (this.bundle == null) {
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
        }
        return this.bundle;
    }
}

