/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.nps.portlet.npsAdministration;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.inject.Inject;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import juzu.Action;
import juzu.HttpMethod;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.Route;
import juzu.View;
import juzu.bridge.portlet.JuzuPortlet;
import juzu.impl.bridge.spi.portlet.PortletRequestBridge;
import juzu.impl.common.JSON;
import juzu.impl.request.Request;
import juzu.plugin.jackson.Jackson;
import juzu.request.RequestContext;
import juzu.template.Template;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.nps.dto.NPSDetailsDTO;
import org.exoplatform.nps.dto.NoteDTO;
import org.exoplatform.nps.dto.ScoreEntryDTO;
import org.exoplatform.nps.dto.ScoreEntryWithNotesDTO;
import org.exoplatform.nps.dto.ScoreTypeDTO;
import org.exoplatform.nps.services.NpsService;
import org.exoplatform.nps.services.NpsTypeService;
import org.exoplatform.nps.services.Utils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.json.JSONArray;
import org.json.JSONObject;

public class NPSAdministrationController {
    private static Log LOG = ExoLogger.getLogger(NPSAdministrationController.class);
    private String bundleString;
    ResourceBundle bundle;
    private static String SCORE_TYPE = "exo.nps.addon.selectedType";
    @Inject
    NpsService npsService;
    @Inject
    NpsTypeService npsTypeService;
    @Inject
    IdentityManager identityManager;
    @Inject
    ActivityManager activityManager;
    @Inject
    @Path(value="index.gtmpl")
    Template indexTmpl;
    @Inject
    @Path(value="edit.gtmpl")
    Template editTmpl;
    private final String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
    SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");

    @View
    public Response.Content index(RequestContext requestContext) {
        PortletMode mode = (PortletMode)requestContext.getProperty(JuzuPortlet.PORTLET_MODE);
        if (PortletMode.EDIT.equals((Object)mode)) {
            Request request = Request.getCurrent();
            PortletRequestBridge bridge = (PortletRequestBridge)request.getBridge();
            PortletPreferences prefs = bridge.getPortletRequest().getPreferences();
            String selectedType = prefs.getValue(SCORE_TYPE, "");
            List scoreTypes = this.npsTypeService.getScoreTypes(0, 0);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("scoreTypes", scoreTypes);
            parameters.put("selectedType", selectedType);
            return this.editTmpl.with(parameters).ok();
        }
        return this.indexTmpl.ok();
    }

    @Action
    @Route(value="updateSettings")
    public Response.Content updateSettings(String typeId) throws Exception {
        Request request = Request.getCurrent();
        PortletRequestBridge bridge = (PortletRequestBridge)request.getBridge();
        PortletPreferences prefs = bridge.getPortletRequest().getPreferences();
        prefs.setValue(SCORE_TYPE, typeId);
        prefs.store();
        return this.indexTmpl.ok();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<ScoreEntryWithNotesDTO> getScores(Long typeId, String respCat, int offset, int limit, Long startDate, Long endDate) {
        try {
            List scores = new ArrayList();
            ArrayList<ScoreEntryWithNotesDTO> scoresWithNotes = new ArrayList<ScoreEntryWithNotesDTO>();
            scores = respCat.equals("detractors") ? this.npsService.getDetractorScores(typeId.longValue(), offset, limit, startDate.longValue(), endDate.longValue()) : (respCat.equals("passives") ? this.npsService.getPassiveScores(typeId.longValue(), offset, limit, startDate.longValue(), endDate.longValue()) : (respCat.equals("promoters") ? this.npsService.getPromotesScores(typeId.longValue(), offset, limit, startDate.longValue(), endDate.longValue()) : this.npsService.getScores(typeId.longValue(), offset, limit, startDate.longValue(), endDate.longValue())));
            for (ScoreEntryDTO score : scores) {
                RealtimeListAccess comments;
                ExoSocialActivity activity;
                score.setUserFullName("Anonymous");
                score.setUserProfile("#");
                if (score.getUserId() != null && !score.getUserId().equals("")) {
                    Profile profile = this.identityManager.getOrCreateIdentity("organization", score.getUserId(), false).getProfile();
                    score.setUserFullName(profile.getFullName());
                    score.setUserProfile("/portal/intranet/profile/" + score.getUserId());
                    if (profile.getAvatarUrl() != null) {
                        score.setPosterAvatar(profile.getAvatarUrl());
                    } else {
                        score.setPosterAvatar("/eXoSkin/skin/images/system/UserAvtDefault.png");
                    }
                } else {
                    score.setPosterAvatar("/eXoSkin/skin/images/system/UserAvtDefault.png");
                }
                if (score.getScore() > 8) {
                    score.setCategory("promoter");
                } else if (score.getScore() < 6) {
                    score.setCategory("detractor");
                } else {
                    score.setCategory("passive");
                }
                if (!score.getEnabled().booleanValue()) {
                    score.setCategory("disabled");
                }
                ArrayList<NoteDTO> notes = new ArrayList<NoteDTO>();
                if (null != score.getActivityId() && (activity = this.activityManager.getActivity(score.getActivityId())) != null && (comments = this.activityManager.getCommentsWithListAccess(activity)).getSize() > 0) {
                    for (ExoSocialActivity comment : (ExoSocialActivity[])comments.load(0, 10)) {
                        Identity identity = this.identityManager.getIdentity(comment.getPosterId(), false);
                        NoteDTO note = new NoteDTO(comment.getId(), identity.getRemoteId(), comment.getPostedTime().longValue(), score.getActivityId(), comment.getTitle(), "", "", null);
                        Profile profile = identity.getProfile();
                        note.setPosterName(profile.getFullName());
                        if (profile.getAvatarUrl() != null) {
                            note.setPosterAvatar(profile.getAvatarUrl());
                        } else {
                            note.setPosterAvatar("/eXoSkin/skin/images/system/UserAvtDefault.png");
                        }
                        List subComments = this.activityManager.getSubComments(comment);
                        if (subComments.size() > 0) {
                            ArrayList<NoteDTO> subNotes = new ArrayList<NoteDTO>();
                            for (ExoSocialActivity subComment : subComments) {
                                identity = this.identityManager.getIdentity(subComment.getPosterId(), false);
                                NoteDTO subNote = new NoteDTO(subComment.getId(), identity.getRemoteId(), subComment.getPostedTime().longValue(), comment.getId(), subComment.getTitle(), "", "", null);
                                profile = identity.getProfile();
                                subNote.setPosterName(profile.getFullName());
                                if (profile.getAvatarUrl() != null) {
                                    subNote.setPosterAvatar(profile.getAvatarUrl());
                                } else {
                                    subNote.setPosterAvatar("/eXoSkin/skin/images/system/UserAvtDefault.png");
                                }
                                subNotes.add(subNote);
                            }
                            note.setNotes(subNotes);
                        }
                        notes.add(note);
                    }
                }
                scoresWithNotes.add(new ScoreEntryWithNotesDTO(score, notes));
            }
            return scoresWithNotes;
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getBundle() {
        try {
            if (!PropertyManager.isDevelopping() && this.bundleString != null && this.getResourceBundle().getLocale().equals(PortalRequestContext.getCurrentInstance().getLocale())) {
                return Response.ok((CharSequence)this.bundleString);
            }
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
            JSON data = new JSON();
            Enumeration<String> enumeration = this.getResourceBundle().getKeys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                try {
                    data.set(key.replaceAll("(.*)\\.", ""), this.getResourceBundle().getObject(key));
                }
                catch (MissingResourceException missingResourceException) {}
            }
            data.set("currentUser", (Object)this.currentUser);
            Profile profile = this.identityManager.getOrCreateIdentity("organization", this.currentUser, false).getProfile();
            if (profile.getAvatarUrl() != null) {
                data.set("currentUserAvatar", (Object)profile.getAvatarUrl());
            } else {
                data.set("currentUserAvatar", (Object)"/eXoSkin/skin/images/system/UserAvtDefault.png");
            }
            data.set("currentUserName", (Object)profile.getFullName());
            Request request = Request.getCurrent();
            PortletRequestBridge bridge = (PortletRequestBridge)request.getBridge();
            PortletPreferences prefs = bridge.getPortletRequest().getPreferences();
            String scoreTypeId = prefs.getValue(SCORE_TYPE, "");
            if (scoreTypeId != null && !scoreTypeId.equals("")) {
                ScoreTypeDTO sType = this.npsTypeService.getScoreType(Long.parseLong(scoreTypeId));
                data.set("scoreTypeId", (Object)scoreTypeId);
                data.set("typeName", (Object)sType.getTypeName());
                data.set("canManage", (Object)ConversationState.getCurrent().getIdentity().isMemberOf("/platform/administrators"));
            }
            TimeZone userTimeZone = Utils.getUserTimezone((String)this.currentUser);
            data.set("userTimeZone", (Object)userTimeZone.toString());
            data.set("offset", (Object)userTimeZone.getOffset(new Date().getTime()));
            int offset = userTimeZone.getOffset(new Date().getTime()) / 3600000;
            String timeZone = (offset < 0 ? "-" : "") + String.format("%02d", Math.abs(offset)) + "00";
            data.set("timeZone", (Object)timeZone);
            this.bundleString = data.toString();
            return Response.ok((CharSequence)this.bundleString);
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting categories", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getData(Long typeId, Long startDate, Long endDate) {
        try {
            JSON data = new JSON();
            if (startDate == 0L) {
                startDate = this.npsService.getFirstScoreEntries(typeId.longValue()).getPostedTime();
            }
            long scorsnbr = this.npsService.getScoreCount(typeId.longValue(), true, startDate.longValue(), endDate.longValue());
            long detractorsNbr = this.npsService.getDetractorsCount(typeId.longValue(), true, startDate.longValue(), endDate.longValue());
            long promotersNbr = this.npsService.getPromotersCount(typeId.longValue(), true, startDate.longValue(), endDate.longValue());
            long passivesNbr = scorsnbr - (promotersNbr + detractorsNbr);
            float detractorsPrc = (float)detractorsNbr / (float)scorsnbr * 100.0f;
            float promotersPrc = (float)promotersNbr / (float)scorsnbr * 100.0f;
            float passivesPrc = (float)passivesNbr / (float)scorsnbr * 100.0f;
            float npScore = promotersPrc - detractorsPrc;
            data.set("enabledScorsNbr", (Object)scorsnbr);
            data.set("startDate", (Object)startDate);
            data.set("detractorsNbr", (Object)detractorsNbr);
            data.set("promotersNbr", (Object)promotersNbr);
            data.set("passivesNbr", (Object)passivesNbr);
            data.set("detractorsPrc", (Object)String.format("%.2f", Float.valueOf(detractorsPrc)));
            data.set("promotersPrc", (Object)String.format("%.2f", Float.valueOf(promotersPrc)));
            data.set("passivesPrc", (Object)String.format("%.2f", Float.valueOf(passivesPrc)));
            data.set("npScore", (Object)String.format("%.2f", Float.valueOf(npScore)));
            long allScorsnbr = this.npsService.getScoreCount(typeId.longValue(), false, startDate.longValue(), endDate.longValue());
            long allDetractorsNbr = this.npsService.getDetractorsCount(typeId.longValue(), false, startDate.longValue(), endDate.longValue());
            long allPromotersNbr = this.npsService.getPromotersCount(typeId.longValue(), false, startDate.longValue(), endDate.longValue());
            long allPassivesNbr = allScorsnbr - (allDetractorsNbr + allPromotersNbr);
            long allCount = this.npsService.getAllCount(typeId.longValue(), startDate.longValue(), endDate.longValue());
            double responseRate = 0.0;
            if (allCount > 0L) {
                responseRate = allScorsnbr * 100L / allCount;
            }
            data.set("scorsnbr", (Object)allScorsnbr);
            data.set("allDetractorsNbr", (Object)allDetractorsNbr);
            data.set("allPromotersNbr", (Object)allPromotersNbr);
            data.set("allPassivesNbr", (Object)allPassivesNbr);
            data.set("disablesScoresNbr", (Object)(allScorsnbr - scorsnbr));
            float dashoffset = 300.0f - 3.0f * npScore;
            data.set("dashoffset", (Object)String.format("%.2f", Float.valueOf(dashoffset)));
            data.set("meanScore", (Object)String.format("%.2f", this.npsService.getMeanScore(typeId.longValue(), startDate.longValue(), endDate.longValue())));
            data.set("responseRate", (Object)responseRate);
            return Response.ok((CharSequence)data.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getNPSLineChart(Long typeId, String chartType, Long startDate, Long endDate) {
        if (startDate == 0L) {
            ScoreEntryDTO score_ = this.npsService.getFirstScoreEntries(typeId.longValue());
            if (score_ != null) {
                startDate = score_.getPostedTime();
            } else {
                return Response.notFound();
            }
        }
        if (chartType.equals("global")) {
            return this.getWeeklyNPS(typeId, startDate, endDate);
        }
        if (chartType.equals("weeklyOver")) {
            return this.getNPSByWeek(typeId, startDate, endDate);
        }
        if (chartType.equals("monthlyOver")) {
            return this.getNPSByMonth(typeId, startDate, endDate);
        }
        if (chartType.equals("rolling30")) {
            return this.getRollingAvg(typeId, 30, startDate, endDate);
        }
        if (chartType.equals("rolling7")) {
            return this.getRollingAvg(typeId, 7, startDate, endDate);
        }
        return Response.notFound();
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getWeeklyNPS(Long typeId, Long startDate, Long endDate) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
            JSONArray npsList = new JSONArray();
            List npsDetails = Utils.getWeeklyNPS((long)typeId, (Long)startDate, (Long)endDate);
            for (NPSDetailsDTO nps : npsDetails) {
                JSONObject nps_ = new JSONObject();
                Calendar c = Calendar.getInstance();
                c.setTimeInMillis(nps.getNpsToDate());
                nps_.put("npsDate", (Object)("W: " + c.get(3) + "-" + c.get(1)));
                nps_.put("npsDetails", (Object)(String.format("%.2f", Float.valueOf(nps.getNpScore())) + " ( Week: " + c.get(3) + "-" + c.get(1) + "Detractors: " + nps.getDetractorsNbr() + ", Passives: " + nps.getPassivesNb() + ", Promoters: " + nps.getPromotersNbr() + ")"));
                nps_.put("score", (Object)String.format("%.2f", Float.valueOf(nps.getNpScore())));
                npsList.put((Object)nps_);
            }
            return Response.ok((CharSequence)npsList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getNPSByWeek(Long typeId, Long startDate, Long endDate) {
        try {
            JSONArray npsList = new JSONArray();
            List npsDetails = Utils.getNPSByWeek((long)typeId, (Long)startDate, (Long)endDate);
            for (NPSDetailsDTO nps : npsDetails) {
                JSONObject nps_ = new JSONObject();
                nps_.put("npsDate", (Object)this.sdf.format(nps.getNpsToDate()));
                nps_.put("npsDetails", (Object)Utils.npsToString((NPSDetailsDTO)nps));
                nps_.put("score", (Object)String.format("%.2f", Float.valueOf(nps.getNpScore())));
                npsList.put((Object)nps_);
            }
            return Response.ok((CharSequence)npsList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getNPSByMonth(Long typeId, Long startDate, Long endDate) {
        try {
            JSONArray npsList = new JSONArray();
            List npsDetails = Utils.getNPSByMonth((long)typeId, (Long)startDate, (Long)endDate);
            for (NPSDetailsDTO nps : npsDetails) {
                JSONObject nps_ = new JSONObject();
                nps_.put("npsDate", (Object)this.sdf.format(nps.getNpsToDate()));
                nps_.put("npsDetails", (Object)Utils.npsToString((NPSDetailsDTO)nps));
                nps_.put("score", (Object)String.format("%.2f", Float.valueOf(nps.getNpScore())));
                npsList.put((Object)nps_);
            }
            return Response.ok((CharSequence)npsList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getRollingAvg(Long typeId, int period, Long startDate, Long endDate) {
        try {
            JSONArray npsList = new JSONArray();
            List npsDetails = Utils.getRollingAvg((long)typeId, (int)period, (Long)startDate, (Long)endDate);
            for (NPSDetailsDTO nps : npsDetails) {
                JSONObject nps_ = new JSONObject();
                nps_.put("npsDate", (Object)this.sdf.format(nps.getNpsToDate()));
                nps_.put("npsDetails", (Object)Utils.npsToString((NPSDetailsDTO)nps));
                nps_.put("score", (Object)String.format("%.2f", Float.valueOf(nps.getNpScore())));
                npsList.put((Object)nps_);
            }
            return Response.ok((CharSequence)npsList.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public Response getRespCountByScore(Long typeId, Long startDate, Long endDate) {
        try {
            HashMap<String, Long> scores = new HashMap<String, Long>();
            scores.put("0", 0L);
            scores.put("1", 0L);
            scores.put("2", 0L);
            scores.put("3", 0L);
            scores.put("4", 0L);
            scores.put("5", 0L);
            scores.put("6", 0L);
            scores.put("7", 0L);
            scores.put("8", 0L);
            scores.put("9", 0L);
            scores.put("10", 0L);
            JSONArray resposesByScores = new JSONArray();
            List results = this.npsService.countGroupdByScores(typeId.longValue(), startDate.longValue(), endDate.longValue());
            long total = this.npsService.getScoreCount(typeId.longValue(), true, startDate.longValue(), endDate.longValue());
            for (int i = 0; i < results.size(); ++i) {
                Object[] arr = (Object[])results.get(i);
                scores.put(((Integer)arr[0]).toString(), (Long)arr[1]);
            }
            for (String key : scores.keySet()) {
                JSONObject data = new JSONObject();
                data.put("score", (Object)key);
                data.put("count", scores.get(key));
                if (total != 0L) {
                    data.put("percent", (Long)scores.get(key) * 100L / total);
                } else {
                    data.put("percent", 0);
                }
                if (Integer.parseInt(key) > 8) {
                    data.put("category", (Object)"promoter");
                } else if (Integer.parseInt(key) < 7) {
                    data.put("category", (Object)"detractor");
                } else {
                    data.put("category", (Object)"passive");
                }
                resposesByScores.put((Object)data);
            }
            return Response.ok((CharSequence)resposesByScores.toString());
        }
        catch (Throwable e) {
            LOG.error((Object)"error while getting context", e);
            return Response.status((int)500);
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public List<ScoreTypeDTO> getScoreTypes() {
        try {
            return this.npsTypeService.getScoreTypes(0, 0);
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            return null;
        }
    }

    @Ajax
    @Resource
    @MimeType.JSON
    @Jackson
    public ScoreTypeDTO getScoreTypeById(Long id) {
        return this.npsTypeService.getScoreType(id.longValue());
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void saveType(@Jackson ScoreTypeDTO obj) {
        if (obj.getAnonymous() == null) {
            obj.setAnonymous(Boolean.valueOf(false));
        }
        this.npsTypeService.save(obj, true);
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void updateType(@Jackson ScoreTypeDTO obj) {
        this.npsTypeService.save(obj, false);
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void deleteScore(@Jackson ScoreEntryDTO obj) {
        this.npsService.remove(obj);
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void disableScore(@Jackson ScoreEntryDTO obj) {
        obj.setEnabled(Boolean.valueOf(false));
        this.npsService.save(obj, false);
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void enableScore(@Jackson ScoreEntryDTO obj) {
        obj.setEnabled(Boolean.valueOf(true));
        this.npsService.save(obj, false);
    }

    @Ajax
    @Resource(method={HttpMethod.POST})
    @MimeType.JSON
    @Jackson
    public void saveNote(@Jackson NoteDTO obj) {
        ExoSocialActivity activity = this.activityManager.getActivity(obj.getActivityId());
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle(obj.getNoteText());
        comment.setUserId(this.identityManager.getOrCreateIdentity("organization", obj.getPosterId(), false).getId());
        if (obj.getCommentId() != null) {
            comment.setParentCommentId(obj.getCommentId());
        }
        this.activityManager.saveComment(activity, (ExoSocialActivity)comment);
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        this.bundle = ResourceBundle.getBundle("locale.portlet.nps-addon", locale, this.getClass().getClassLoader());
        return this.bundle;
    }

    private ResourceBundle getResourceBundle() {
        if (this.bundle == null) {
            this.bundle = this.getResourceBundle(PortalRequestContext.getCurrentInstance().getLocale());
        }
        return this.bundle;
    }
}

