/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.officeonline;

import com.sun.star.uno.RuntimeException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class WOPIAvailabilityCheckerPlugin
extends BaseComponentPlugin {
    protected static final Log LOG = ExoLogger.getLogger(WOPIAvailabilityCheckerPlugin.class);
    private static final String HTTP_GET = "GET";
    protected String wopiCheckUrl;
    protected static final String WOPI_CHECK_URL_PARAM = "check-url";
    protected boolean available = false;
    protected ScheduledExecutorService refreshExecutor = Executors.newScheduledThreadPool(1);

    public WOPIAvailabilityCheckerPlugin(InitParams params) {
        String val;
        ValueParam wopiCheckUrlParam = params.getValueParam(WOPI_CHECK_URL_PARAM);
        String string = val = wopiCheckUrlParam != null ? wopiCheckUrlParam.getValue() : null;
        if (val == null || (val = val.trim()).isEmpty()) {
            throw new RuntimeException("check-url parameter is required.");
        }
        this.wopiCheckUrl = val;
    }

    public void start() {
        this.refreshExecutor.scheduleAtFixedRate(() -> {
            this.available = this.checkWOPIAvailability();
        }, 1L, 10L, TimeUnit.MINUTES);
    }

    public void stop() {
        this.refreshExecutor.shutdown();
    }

    public boolean isWOPIAvailable() {
        return this.available;
    }

    protected boolean checkWOPIAvailability() {
        try {
            URL url = new URL(this.wopiCheckUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(HTTP_GET);
            connection.connect();
            if (connection.getResponseCode() == 200) {
                return true;
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot check WOPI host availability: ", new Object[]{e.getMessage()});
        }
        return false;
    }
}

