/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.officeonline.documents;

import java.net.URI;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.officeonline.EditorConfig;
import org.exoplatform.officeonline.OfficeOnlineDocumentUpdateActivityHandler;
import org.exoplatform.officeonline.WOPIService;
import org.exoplatform.officeonline.cometd.CometdConfig;
import org.exoplatform.officeonline.cometd.CometdOfficeOnlineService;
import org.exoplatform.officeonline.exception.EditorLinkNotFoundException;
import org.exoplatform.officeonline.exception.FileNotFoundException;
import org.exoplatform.officeonline.exception.LockMismatchException;
import org.exoplatform.officeonline.exception.OfficeOnlineException;
import org.exoplatform.officeonline.webui.OfficeOnlineContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.documents.DocumentEditor;
import org.exoplatform.services.cms.documents.DocumentUpdateActivityHandler;
import org.exoplatform.services.cms.documents.NewDocumentTemplate;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.webui.application.WebuiRequestContext;

public class OfficeOnlineDocumentEditorPlugin
extends BaseComponentPlugin
implements DocumentEditor {
    protected static final Log LOG = ExoLogger.getLogger(OfficeOnlineDocumentEditorPlugin.class);
    protected static final String PROVIDER_NAME = "officeonline";
    protected static final long EDITING_FINISHED_DELAY = 60000L;
    protected static final String PROVIDER_CONFIGURATION_PARAM = "provider-configuration";
    protected static final String CLIENT_RESOURCE_PREFIX = "OfficeOnlineEditorClient.";
    protected static final String EDITOR_LINK_NOT_FOUND_ERROR = "EditorLinkNotFoundError";
    protected static final String EDITOR_LINK_NOT_FOUND_ERROR_MESSAGE = "EditorLinkNotFoundErrorMessage";
    protected static final String STORAGE_ERROR = "StorageError";
    protected static final String STORAGE_ERROR_MESSAGE = "StorageErrorMessage";
    protected static final String INTERNAL_EDITOR_ERROR = "InternalEditorError";
    protected static final String INTERNAL_EDITOR_ERROR_MESSAGE = "InternalEditorErrorMessage";
    protected static final String EXO_SYMLINK = "exo:symlink";
    protected final WOPIService wopiService;
    protected final ResourceBundleService i18nService;
    protected final CometdOfficeOnlineService cometdService;
    protected final Map<Node, String> editorLinks = new ConcurrentHashMap<Node, String>();
    protected final DocumentUpdateActivityHandler updateHandler;

    public OfficeOnlineDocumentEditorPlugin(WOPIService wopiService, ResourceBundleService i18nService, CometdOfficeOnlineService cometdService) {
        this.wopiService = wopiService;
        this.i18nService = i18nService;
        this.cometdService = cometdService;
        this.updateHandler = new OfficeOnlineDocumentUpdateActivityHandler(wopiService);
    }

    public void onDocumentCreated(String workspace, String path) throws Exception {
        Node node = this.wopiService.getNode(workspace, path);
        String link = null;
        try {
            link = "'" + this.getEditorLink(node, null) + "'";
        }
        catch (OfficeOnlineException e) {
            LOG.error("Cannot get editor link: {}", new Object[]{e.getMessage()});
            link = "null";
        }
        OfficeOnlineContext.callModule("officeonline.initEditorPage(" + link + ");");
    }

    public void beforeDocumentCreate(NewDocumentTemplate template, String parentPath, String title) throws Exception {
        OfficeOnlineContext.callModule("officeonline.initNewDocument();");
    }

    public String getProviderName() {
        return PROVIDER_NAME;
    }

    public void initActivity(String uuid, String workspace, String activityId) throws Exception {
        Node symlink = this.wopiService.nodeByUUID(uuid, workspace);
        Node node = this.wopiService.getNode(symlink.getSession().getWorkspace().getName(), symlink.getPath());
        if (node != null && this.wopiService.isDocumentSupported(node)) {
            String link = null;
            try {
                link = "'" + this.getEditorLink(node, null) + "'";
            }
            catch (EditorLinkNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Cannot get editor link: {}", new Object[]{e.getMessage()});
                }
                link = "null";
            }
            OfficeOnlineContext.callModule("officeonline.initActivity('" + node.getUUID() + "', " + link + ", '" + activityId + "');");
        }
    }

    public EditorSetting initPreview(String fileId, String workspace, URI requestURI, Locale locale) {
        block9: {
            try {
                Node symlink = this.wopiService.nodeByUUID(fileId, workspace);
                Node node = this.wopiService.getNode(symlink.getSession().getWorkspace().getName(), symlink.getPath());
                if (node == null || !this.wopiService.isDocumentSupported(node)) break block9;
                String userId = ConversationState.getCurrent().getIdentity().getUserId();
                if (symlink.isNodeType(EXO_SYMLINK)) {
                    this.wopiService.addFilePreferences(node, userId, symlink.getPath());
                }
                String link = null;
                EditorError error = null;
                try {
                    link = this.getEditorLink(node, requestURI);
                }
                catch (EditorLinkNotFoundException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Cannot get editor link for preview: {}", new Object[]{e.getMessage()});
                    }
                    error = new EditorError(EDITOR_LINK_NOT_FOUND_ERROR, EDITOR_LINK_NOT_FOUND_ERROR_MESSAGE);
                }
                catch (OfficeOnlineException e) {
                    LOG.error((Object)"Cannot get editor link for preview: ", (Throwable)e);
                    error = new EditorError(INTERNAL_EDITOR_ERROR, INTERNAL_EDITOR_ERROR_MESSAGE);
                }
                catch (RepositoryException e) {
                    LOG.error((Object)"Cannot get editor link for preview: ", (Throwable)e);
                    error = new EditorError(STORAGE_ERROR, STORAGE_ERROR_MESSAGE);
                }
                Map<String, String> messages = this.initMessages(locale);
                CometdConfig cometdConf = new CometdConfig(this.cometdService.getCometdServerPath(), this.cometdService.getUserToken(userId), PortalContainer.getCurrentPortalContainerName());
                return new EditorSetting(fileId, link, userId, cometdConf, messages, error);
            }
            catch (FileNotFoundException e) {
                LOG.error("Cannot initialize preview for fileId: {}, workspace: {}. {}", new Object[]{fileId, workspace, e.getMessage()});
            }
            catch (RepositoryException e) {
                LOG.error((Object)"Cannot initialize preview", (Throwable)e);
            }
        }
        return null;
    }

    public EditorSetting initExplorer(String fileId, String workspace, WebuiRequestContext context) {
        block11: {
            try {
                UIJCRExplorer uiExplorer;
                Node node = this.wopiService.nodeByUUID(fileId, workspace);
                node = this.wopiService.getNode(node.getSession().getWorkspace().getName(), node.getPath());
                if (!this.wopiService.isDocumentSupported(node)) break block11;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Init documents explorer for node: {}:{}", new Object[]{workspace, fileId});
                }
                if ((uiExplorer = (UIJCRExplorer)context.getUIApplication().findFirstComponentOfType(UIJCRExplorer.class)) != null) {
                    Node symlink = (Node)uiExplorer.getSession().getItem(uiExplorer.getCurrentPath());
                    if (symlink.isNodeType(EXO_SYMLINK)) {
                        this.wopiService.addFilePreferences(node, WebuiRequestContext.getCurrentInstance().getRemoteUser(), symlink.getPath());
                    }
                } else {
                    LOG.warn("Cannot check for symlink node {}:{} - UIJCRExplorer is null", new Object[]{fileId, workspace});
                }
                String userId = context.getRemoteUser();
                String link = null;
                EditorError error = null;
                try {
                    link = this.getEditorLink(node, null);
                }
                catch (EditorLinkNotFoundException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Cannot get editor link for preview: {}", new Object[]{e.getMessage()});
                    }
                    error = new EditorError(EDITOR_LINK_NOT_FOUND_ERROR, EDITOR_LINK_NOT_FOUND_ERROR_MESSAGE);
                }
                catch (OfficeOnlineException e) {
                    LOG.error((Object)"Cannot get editor link for preview: ", (Throwable)e);
                    error = new EditorError(INTERNAL_EDITOR_ERROR, INTERNAL_EDITOR_ERROR_MESSAGE);
                }
                catch (RepositoryException e) {
                    LOG.error((Object)"Cannot get editor link for preview: ", (Throwable)e);
                    error = new EditorError(STORAGE_ERROR, STORAGE_ERROR_MESSAGE);
                }
                Map<String, String> messages = this.initMessages(WebuiRequestContext.getCurrentInstance().getLocale());
                CometdConfig cometdConf = new CometdConfig(this.cometdService.getCometdServerPath(), this.cometdService.getUserToken(userId), PortalContainer.getCurrentPortalContainerName());
                return new EditorSetting(fileId, link, userId, cometdConf, messages, error);
            }
            catch (Exception e) {
                LOG.error("Cannot initialize exlporer for fileId: {}, workspace: {}. {}", new Object[]{fileId, workspace, e.getMessage()});
            }
        }
        return null;
    }

    public boolean isDocumentSupported(String fileId, String workspace) {
        try {
            Node node = this.wopiService.nodeByUUID(fileId, workspace);
            return this.wopiService.canEdit(node) || this.wopiService.canView(node);
        }
        catch (FileNotFoundException e) {
            LOG.error("Cannot check if file is suported, document not found. {}", new Object[]{e.getMessage()});
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Cannot check if file is suported", (Throwable)e);
        }
        return false;
    }

    public DocumentUpdateActivityHandler getDocumentUpdateHandler() {
        return this.updateHandler;
    }

    public void onLastEditorClosed(String fileId, String workspace) {
        try {
            Node node = this.wopiService.nodeByUUID(fileId, workspace);
            if (node.isLocked()) {
                EditorConfig config = new EditorConfig.Builder().fileId(fileId).workspace(workspace).build();
                String lockId = this.wopiService.getLockId(config);
                this.wopiService.unlock(config, lockId);
            }
        }
        catch (FileNotFoundException e) {
            LOG.error("Cannot find node with fileId {} and workspace {} : {}", new Object[]{fileId, workspace, e.getMessage()});
        }
        catch (LockMismatchException e) {
            LOG.error("Cannot unlock node with fileId {} and workspace {} : {}", new Object[]{fileId, workspace, e.getMessage()});
        }
        catch (Exception e) {
            LOG.error("Cannot execute last editor closed handler for fileId {} and workspace {} : {}", new Object[]{fileId, workspace, e.getMessage()});
        }
    }

    public long getEditingFinishedDelay() {
        return 60000L;
    }

    protected String getEditorLink(Node node, URI requestURI) throws RepositoryException, OfficeOnlineException {
        int port;
        String host;
        String scheme;
        if (requestURI != null) {
            scheme = requestURI.getScheme();
            host = requestURI.getHost();
            port = requestURI.getPort();
        } else {
            PortalRequestContext pcontext = Util.getPortalRequestContext();
            if (pcontext != null) {
                scheme = pcontext.getRequest().getScheme();
                host = pcontext.getRequest().getServerName();
                port = pcontext.getRequest().getServerPort();
            } else {
                throw new OfficeOnlineException("Cannot get editor link - request URI and PortalRequestContext are null");
            }
        }
        String link = null;
        if (this.wopiService.canEdit(node)) {
            link = this.wopiService.getEditorLink(node, scheme, host, port, "edit");
        } else if (this.wopiService.canView(node)) {
            link = this.wopiService.getEditorLink(node, scheme, host, port, "view");
        } else {
            throw new EditorLinkNotFoundException("Editor link not found - permission denied");
        }
        this.editorLinks.putIfAbsent(node, link);
        return link;
    }

    private Map<String, String> initMessages(Locale locale) {
        ResourceBundle res = this.i18nService.getResourceBundle("locale.officeonline.OfficeOnlineClient", locale);
        HashMap<String, String> messages = new HashMap<String, String>();
        Enumeration<String> keys = res.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String bundleKey = key.startsWith(CLIENT_RESOURCE_PREFIX) ? key.substring(CLIENT_RESOURCE_PREFIX.length()) : key;
            messages.put(bundleKey, res.getString(key));
        }
        return messages;
    }

    public static class EditorError {
        private final String type;
        private final String message;

        public EditorError(String type, String message) {
            this.type = type;
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public String getType() {
            return this.type;
        }
    }

    protected static class EditorSetting {
        private final String fileId;
        private final String link;
        private final String userId;
        private final CometdConfig cometdConf;
        private final Map<String, String> messages;
        private final EditorError error;

        public EditorSetting(String fileId, String link, String userId, CometdConfig cometdConf, Map<String, String> messages, EditorError error) {
            this.fileId = fileId;
            this.link = link;
            this.userId = userId;
            this.cometdConf = cometdConf;
            this.messages = messages;
            this.error = error;
        }

        public String getFileId() {
            return this.fileId;
        }

        public String getLink() {
            return this.link;
        }

        public String getUserId() {
            return this.userId;
        }

        public CometdConfig getCometdConf() {
            return this.cometdConf;
        }

        public Map<String, String> getMessages() {
            return this.messages;
        }

        public EditorError getError() {
            return this.error;
        }
    }
}

