/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.officeonline.rest;

import javax.annotation.security.RolesAllowed;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.officeonline.DocumentContent;
import org.exoplatform.officeonline.EditorConfig;
import org.exoplatform.officeonline.EditorService;
import org.exoplatform.officeonline.WOPIService;
import org.exoplatform.officeonline.exception.OfficeOnlineException;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/officeonline/editor")
public class EditorResource
implements ResourceContainer {
    protected EditorService editorService;
    protected WOPIService wopiService;

    public EditorResource(EditorService editorService, WOPIService wopiService) {
        this.editorService = editorService;
        this.wopiService = wopiService;
    }

    @GET
    @Path(value="/content/{fileId}")
    public Response content(@Context UriInfo uriInfo, @Context HttpServletRequest request, @Context ServletContext context, @PathParam(value="fileId") String fileId) {
        EditorConfig config = (EditorConfig)context.getAttribute("editorConfig");
        if (config == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{\"error\": \"Couldn't obtain editor config from access token\"}").type("application/json").build();
        }
        if (!fileId.equals(config.getFileId())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{\"error\": \"Provided fileId doesn't match fileId from access token\"}").type("application/json").build();
        }
        try {
            DocumentContent content = this.editorService.getContent(config);
            return Response.ok().header("Content-Type", (Object)content.getType()).header("Content-disposition", (Object)("attachment; filename=" + content.getFilename())).entity((Object)content.getData()).type(content.getType()).build();
        }
        catch (OfficeOnlineException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
        }
    }

    @GET
    @Path(value="/configuration/version/accumulation")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response isVersionAccumulationEnabled() {
        return Response.ok().entity((Object)("{\"enabled\": " + this.wopiService.isVersionAccumulationEnabled() + "}")).type("application/json").build();
    }

    @PUT
    @Path(value="/configuration/version/accumulation")
    @RolesAllowed(value={"administrators"})
    public Response setVersionAccumulation(@FormParam(value="enabled") Boolean enabled) {
        this.wopiService.setVersionAccumulation(enabled);
        return Response.ok().build();
    }
}

