/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.officeonline.rest;

import com.beetstra.jutf7.CharsetProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.io.IOUtils;
import org.exoplatform.officeonline.DocumentContent;
import org.exoplatform.officeonline.EditorConfig;
import org.exoplatform.officeonline.RequestInfo;
import org.exoplatform.officeonline.WOPIService;
import org.exoplatform.officeonline.exception.AuthenticationFailedException;
import org.exoplatform.officeonline.exception.EditorConfigNotFoundException;
import org.exoplatform.officeonline.exception.EditorLinkNotFoundException;
import org.exoplatform.officeonline.exception.FileExtensionNotFoundException;
import org.exoplatform.officeonline.exception.FileLockedException;
import org.exoplatform.officeonline.exception.FileNotFoundException;
import org.exoplatform.officeonline.exception.IllegalFileNameException;
import org.exoplatform.officeonline.exception.InvalidFileNameException;
import org.exoplatform.officeonline.exception.LockMismatchException;
import org.exoplatform.officeonline.exception.OfficeOnlineException;
import org.exoplatform.officeonline.exception.PermissionDeniedException;
import org.exoplatform.officeonline.exception.ProofKeyValidationException;
import org.exoplatform.officeonline.exception.SizeMismatchException;
import org.exoplatform.officeonline.exception.UpdateConflictException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/wopi")
public class WOPIResource
implements ResourceContainer {
    private static final String WOPI_ENDPOINT = "wopi/";
    public static final String ACCESS_TOKEN = "access_token";
    public static final String WRONG_TOKEN_ATTRIBUTE = "wrong_token";
    public static final String EDITOR_CONFIG_ATTRIBUTE = "editorConfig";
    protected static final String FILE_CONVERSION = "X-WOPI-FileConversion";
    protected static final String ITEM_VERSION = "X-WOPI-ItemVersion";
    protected static final String LOCK = "X-WOPI-Lock";
    protected static final String MAX_EXPECTED_SIZE = "X-WOPI-MaxExpectedSize";
    protected static final String OLD_LOCK = "X-WOPI-OldLock";
    protected static final String OVERRIDE = "X-WOPI-Override";
    protected static final String PROOF = "X-WOPI-Proof";
    protected static final String PROOF_OLD = "X-WOPI-ProofOld";
    protected static final String RELATIVE_TARGET = "X-WOPI-RelativeTarget";
    protected static final String OVERWRITE_RELATIVE_TARGET = "X-WOPI-OverwriteRelativeTarget";
    protected static final String REQUESTED_NAME = "X-WOPI-RequestedName";
    protected static final String SUGGESTED_TARGET = "X-WOPI-SuggestedTarget";
    protected static final String INVALID_FILE_NAME_ERROR = "X-WOPI-InvalidFileNameError";
    protected static final String URL_TYPE = "X-WOPI-UrlType";
    protected static final String TIMESTAMP = "X-WOPI-TimeStamp";
    protected static final String API_VERSION = "1.1";
    protected static final Log LOG = ExoLogger.getLogger(WOPIService.class);
    private static final Charset UTF_7 = new CharsetProvider().charsetForName("UTF-7");
    private static final Charset UTF_8 = new CharsetProvider().charsetForName("UTF-8");
    protected final WOPIService wopiService;

    public WOPIResource(WOPIService wopiService) {
        this.wopiService = wopiService;
    }

    @POST
    @Path(value="/files/{fileId}/contents")
    @Produces(value={"application/json"})
    public Response putFile(@Context UriInfo uriInfo, @Context HttpServletRequest request, @Context ServletContext context, @HeaderParam(value="X-WOPI-Override") Operation operation, @PathParam(value="fileId") String fileId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"WOPI Request handled: putFile");
        }
        try {
            this.verifyProofKey(request);
        }
        catch (ProofKeyValidationException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Proof key validation failed for putFile");
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
        }
        if (operation == Operation.PUT) {
            try {
                EditorConfig config = this.getEditorConfig(context);
                String lockId = request.getHeader(LOCK);
                this.wopiService.putFile(config, lockId, (InputStream)request.getInputStream());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("PutFile response OK. LockId: " + lockId));
                }
                Response.ResponseBuilder response = Response.ok().header(LOCK, (Object)lockId);
                this.addItemVersionHeader(response, config);
                return response.type("application/json").build();
            }
            catch (FileNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"File not found for putFile", (Throwable)e);
                }
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
            }
            catch (LockMismatchException | SizeMismatchException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Lock mismatch/size mismatch for putFile. Provided lock: " + request.getHeader(LOCK) + " Actual lock + " + e.getLockId()));
                }
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).header(LOCK, (Object)e.getLockId()).type("application/json").build();
            }
            catch (PermissionDeniedException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Permission denied for putFile", (Throwable)e);
                }
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"{\"error\": \"Permission denied\"}").type("application/json").build();
            }
            catch (AuthenticationFailedException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Authentication failed for putFile");
                }
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
            }
            catch (OfficeOnlineException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Office Online exception occured while handling putFile", (Throwable)e);
                }
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Cannot get request body for putFile", (Throwable)e);
                }
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"{\"error\": \"Cannot get request body\"}").type("application/json").build();
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Exception occured while handling putFile", (Throwable)e);
                }
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"{\"error\": \"Internal error while saving content\"}").type("application/json").build();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Wrong operation for putFile");
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{\"error\": \"Wrong operation\"}").type("application/json").build();
    }

    @GET
    @Path(value="/files/{fileId}/contents")
    @Produces(value={"application/json"})
    public Response getFile(@Context UriInfo uriInfo, @Context HttpServletRequest request, @Context ServletContext context, @PathParam(value="fileId") String fileId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"WOPI Request handled: getFile");
        }
        try {
            this.verifyProofKey(request);
        }
        catch (ProofKeyValidationException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Proof key validation failed for getFile");
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
        }
        try {
            EditorConfig config = this.getEditorConfig(context);
            if (!fileId.equals(config.getFileId())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Provided fileId doesn't match fileId from access token");
                }
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{\"error\": \"Provided fileId doesn't match fileId from access token\"}").type("application/json").build();
            }
            DocumentContent content = this.wopiService.getContent(config);
            String version = null;
            try {
                version = content.getVersion();
            }
            catch (RepositoryException e) {
                LOG.error((Object)"Cannot get node version", (Throwable)e);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Get file response: OK");
            }
            return Response.ok().header(ITEM_VERSION, (Object)(version != null ? version : "")).entity((Object)content.getData()).type(content.getType()).build();
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"File not found for getFile ", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
        }
        catch (AuthenticationFailedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Authentication Failed for getFile");
            }
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
        }
        catch (OfficeOnlineException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Error occured while getFile ", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
        }
    }

    @GET
    @Path(value="/available")
    public Response available() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"WOPI Availability check request handled");
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="/files/{fileId}")
    @Produces(value={"application/json"})
    public Response files(@Context UriInfo uriInfo, @Context HttpServletRequest request, @Context ServletContext context, @HeaderParam(value="X-WOPI-Override") Operation operation, @PathParam(value="fileId") String fileId) {
        EditorConfig config;
        try {
            this.verifyProofKey(request);
        }
        catch (ProofKeyValidationException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Proof key validation failed for /files/");
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
        }
        try {
            config = this.getEditorConfig(context);
        }
        catch (AuthenticationFailedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Authentication failed for /files/");
            }
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
        }
        catch (EditorConfigNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Editor Config not found failed for /files/", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
        }
        if (!fileId.equals(config.getFileId())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Provided fileId doesn't match fileId from access token for /files/");
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{\"error\": \"Provided fileId doesn't match fileId from access token\"}").type("application/json").build();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("WOPI Request: " + (Object)((Object)operation)));
        }
        switch (operation) {
            case GET_LOCK: {
                return this.getLock(config);
            }
            case LOCK: {
                String providedLock = request.getHeader(LOCK);
                String oldLock = request.getHeader(OLD_LOCK);
                return this.lockOrUnlockAndRelock(config, providedLock, oldLock);
            }
            case PUT_RELATIVE: {
                if (request.getHeader(RELATIVE_TARGET) != null && request.getHeader(SUGGESTED_TARGET) != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Headers RELATIVE_TARGET and SUGGESTED_TARGET are mutually exclusive for putRelative");
                    }
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{\"error\": \"Headers RELATIVE_TARGET and SUGGESTED_TARGET are mutually exclusive.\"}").type("application/json").build();
                }
                try {
                    RequestInfo requestInfo = new RequestInfo(request.getScheme(), request.getServerName(), request.getServerPort(), request.getRemoteUser());
                    if (request.getHeader(RELATIVE_TARGET) != null) {
                        boolean overwrite = Boolean.parseBoolean(request.getHeader(OVERWRITE_RELATIVE_TARGET));
                        return this.putRelativeFile(config, request.getHeader(RELATIVE_TARGET), overwrite, (InputStream)request.getInputStream(), requestInfo);
                    }
                    if (request.getHeader(SUGGESTED_TARGET) != null) {
                        return this.putSuggestedFile(config, request.getHeader(SUGGESTED_TARGET), (InputStream)request.getInputStream(), requestInfo);
                    }
                }
                catch (IOException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Cannot get request body for putRelative", (Throwable)e);
                    }
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"{\"error\": \"Cannot get request body\"}").type("application/json").build();
                }
            }
            case REFRESH_LOCK: {
                String providedLock = request.getHeader(LOCK);
                return this.refreshLock(config, providedLock);
            }
            case RENAME_FILE: {
                String name = request.getHeader(REQUESTED_NAME);
                String lock = request.getHeader(LOCK);
                return this.renameFile(fileId, config, name, lock);
            }
            case UNLOCK: {
                String providedLock = request.getHeader(LOCK);
                return this.unlock(config, providedLock);
            }
            case DELETE: {
                String lock = request.getHeader(LOCK);
                return this.delete(config, lock);
            }
            case PUT_USER_INFO: {
                try {
                    String userInfo = this.convertStreamToString((InputStream)request.getInputStream());
                    return this.putUserInfo(config, userInfo);
                }
                catch (IOException e) {
                    LOG.error((Object)("Cannot put userinfo. UserId: " + config.getUserId()), (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"{\"error\": \"Failed to fetch userinfo from request body\"}").type("application/json").build();
                }
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    protected Response putUserInfo(EditorConfig config, String userInfo) {
        this.wopiService.putUserInfo(config.getUserId(), userInfo);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PutUserInfo response: OK. UserId: " + config.getUserId() + ". UserInfo: " + userInfo));
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/files/{fileId}")
    @Produces(value={"application/json"})
    public Response checkFileInfo(@Context UriInfo uriInfo, @Context HttpServletRequest request, @Context ServletContext context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"WOPI Request handled: checkFileInfo");
        }
        try {
            this.verifyProofKey(request);
        }
        catch (ProofKeyValidationException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Proof key validation failed for checkFileInfo");
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
        }
        try {
            EditorConfig config = this.getEditorConfig(context);
            Map<String, Serializable> fileInfo = this.wopiService.checkFileInfo(config);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Check file info response: OK");
            }
            return Response.ok(fileInfo).type("application/json").build();
        }
        catch (AuthenticationFailedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Authentication failed for checkFileInfo");
            }
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
        }
        catch (OfficeOnlineException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Error while checkFileInfo", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
        }
        catch (RepositoryException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Cannot check file info", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"{\"error\": \"Failed to check file info\"}").type("application/json").build();
        }
    }

    private Response renameFile(String fileId, EditorConfig config, String name, String lock) {
        if (!fileId.equals(config.getFileId())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Provided fileId doesn't match fileId from access token for renameFile");
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{\"error\": \"Provided fileId doesn't match fileId from access token\"}").type("application/json").build();
        }
        try {
            name = new String(name.getBytes(), UTF_7);
            String title = this.wopiService.renameFile(config, name, lock);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Rename file response: OK");
            }
            return Response.ok().entity((Object)("{\"Name\": \"" + title + "\"}")).type("application/json").build();
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"File not found for renameFile", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
        }
        catch (PermissionDeniedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Permission denied for rename file.", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
        }
        catch (LockMismatchException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Lock mismatch for renameFile. Provided lock: " + lock + " Actual lock: " + e.getLockId()));
            }
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).header(LOCK, (Object)e.getLockId()).type("application/json").build();
        }
        catch (InvalidFileNameException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Invalid filename for renameFile", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).header(INVALID_FILE_NAME_ERROR, (Object)e.getMessage()).type("application/json").build();
        }
        catch (RepositoryException | OfficeOnlineException e) {
            LOG.error((Object)"Cannot rename file", e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"{\"error\": \"Cannot rename file\"}").type("application/json").build();
        }
    }

    private Response lockOrUnlockAndRelock(EditorConfig config, String providedLock, String oldLock) {
        try {
            if (oldLock != null) {
                this.wopiService.relock(config, providedLock, oldLock);
            } else {
                this.wopiService.lock(config, providedLock);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Lock or relock response: OK");
            }
            Response.ResponseBuilder response = Response.ok();
            this.addItemVersionHeader(response, config);
            return response.build();
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"File not found for lock or relock", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
        }
        catch (LockMismatchException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Lock mismatch for lock or relock. Provided lock: " + providedLock + " Old LockL " + oldLock + " Actual Lock: " + e.getLockId()));
            }
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).header(LOCK, (Object)e.getLockId()).type("application/json").build();
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Cannot lock or relock file.", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"{\"error\": \"Cannot lock or relock file.\"}").type("application/json").build();
        }
    }

    private Response unlock(EditorConfig config, String providedLock) {
        try {
            this.wopiService.unlock(config, providedLock);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Unlock response: OK");
            }
            Response.ResponseBuilder response = Response.ok();
            this.addItemVersionHeader(response, config);
            return response.build();
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"File not found for unlock", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
        }
        catch (LockMismatchException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Lock mismatch for unlock. Given lock: " + providedLock + ", Actual: " + e.getLockId()));
            }
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).header(LOCK, (Object)e.getLockId()).type("application/json").build();
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Cannot unlock file.", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"{\"error\": \"Cannot unlock file.\"}").type("application/json").build();
        }
    }

    private Response getLock(EditorConfig config) {
        try {
            String lock = this.wopiService.getLockId(config);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("GetLock response: OK. Lock: " + lock));
            }
            return Response.ok().header(LOCK, (Object)(lock != null ? lock : "")).build();
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"File not found for getLock", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Cannot get lock of file.", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"{\"error\": \"Cannot get lock of file\"}").type("application/json").build();
        }
    }

    private Response refreshLock(EditorConfig config, String lockId) {
        try {
            this.wopiService.refreshLock(config, lockId);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Refresh lock response: OK");
            }
            return Response.ok().build();
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"File not found for refresh lock", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
        }
        catch (LockMismatchException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Lock mismatch for getlock. Given lock: " + lockId + ", Actual: " + e.getLockId()));
            }
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).header(LOCK, (Object)e.getLockId()).type("application/json").build();
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Cannot refresh lock.", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"{\"error\": \"Cannot refresh lock.\"}").type("application/json").build();
        }
    }

    private Response delete(EditorConfig config, String lockId) {
        try {
            this.wopiService.delete(config, lockId);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Delete response: OK");
            }
            return Response.ok().build();
        }
        catch (LockMismatchException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Lock mismatch for delete. Given lock: " + lockId + ", Actual: " + e.getLockId()));
            }
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).header(LOCK, (Object)e.getLockId()).type("application/json").build();
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"File not found for refresh lock", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
        }
        catch (RepositoryException | OfficeOnlineException e) {
            LOG.error((Object)("Cannot delete file. FileId: " + config.getFileId() + ", lockId: " + lockId), e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"{\"error\": \"Cannot delete file.\"}").type("application/json").build();
        }
    }

    private Response putRelativeFile(EditorConfig config, String target, boolean overwrite, InputStream data, RequestInfo requestInfo) {
        String currentFileName;
        block17: {
            currentFileName = "";
            try {
                currentFileName = this.wopiService.getFileName(config.getFileId(), config.getWorkspace());
            }
            catch (RepositoryException | FileNotFoundException e) {
                if (!LOG.isDebugEnabled()) break block17;
                LOG.debug((Object)"Cannot get filename for putFile operation", e);
            }
        }
        String currentUrl = this.wopiService.getWOPISrc(requestInfo, config.getFileId()) + "?access_token=" + config.getAccessToken().getToken();
        try {
            target = new String(target.getBytes(), UTF_7);
            String fileId = this.wopiService.putRelativeFile(config, target, overwrite, data);
            String fileName = this.wopiService.getFileName(fileId, config.getWorkspace());
            EditorConfig newConfig = this.wopiService.createEditorConfig(config.getUserId(), fileId, config.getWorkspace(), requestInfo);
            String url = this.wopiService.getWOPISrc(requestInfo, fileId) + "?access_token=" + newConfig.getAccessToken().getToken();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"PutRelativeFile response: OK");
            }
            return Response.ok().type(MediaType.APPLICATION_JSON_TYPE).entity((Object)("{\"Name\": \"" + fileName + "\", \"Url\": \"" + url + "\"}")).build();
        }
        catch (IllegalFileNameException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Illegal file name for PutRelativeFile", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"Name\": \"" + e.getFilename() + "\", \"Url\": \"no-url\", \"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
        }
        catch (FileLockedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"File locked error for PutRelativeFile", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)("{\"Name\": \"" + e.getFileName() + "\", \"Url\": \"" + currentUrl + "\", \"error\": \"" + e.getMessage() + "\"}")).header(LOCK, (Object)(e.getLockId() != null ? e.getLockId() : "")).type("application/json").build();
        }
        catch (UpdateConflictException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Update conflict for PutRelativeFile", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)("{\"Name\": \"" + e.getFileName() + "\", \"Url\": \"" + currentUrl + "\", \"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"File not found for PutRelativeFile", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"Name\": \"" + currentFileName + "\", \"Url\": \"" + currentUrl + "\", \"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
        }
        catch (FileExtensionNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"File extension not found for PutRelativeFile", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"Name\": \"" + currentFileName + "\", \"Url\": \"" + currentUrl + "\", \"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
        }
        catch (PermissionDeniedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Cannot create new file based on existing one in specific mode.", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"Name\": \"" + currentFileName + "\", \"Url\": \"" + currentUrl + "\", \"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
        }
        catch (RepositoryException | OfficeOnlineException e) {
            LOG.error((Object)"Cannot create new file based on existing one in specific mode.", e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"Name\": \"" + currentFileName + "\", \"Url\": \"" + currentUrl + "\", \"error\": \"Failed to put relative file in specific mode\"}")).type("application/json").build();
        }
    }

    private Response putSuggestedFile(EditorConfig config, String target, InputStream data, RequestInfo requestInfo) {
        String currentFileName;
        block13: {
            currentFileName = "";
            try {
                currentFileName = this.wopiService.getFileName(config.getFileId(), config.getWorkspace());
            }
            catch (RepositoryException | FileNotFoundException e) {
                if (!LOG.isDebugEnabled()) break block13;
                LOG.debug((Object)"Cannot get filename for putFile operation", e);
            }
        }
        String currentUrl = this.wopiService.getWOPISrc(requestInfo, config.getFileId()) + "?access_token=" + config.getAccessToken().getToken();
        try {
            target = new String(target.getBytes(), UTF_7);
            String fileId = this.wopiService.putSuggestedFile(config, target, data);
            String fileName = this.wopiService.getFileName(fileId, config.getWorkspace());
            EditorConfig newConfig = this.wopiService.createEditorConfig(config.getUserId(), fileId, config.getWorkspace(), requestInfo);
            String url = this.wopiService.getWOPISrc(requestInfo, fileId) + "?access_token=" + newConfig.getAccessToken().getToken();
            String editUrl = null;
            String viewUrl = null;
            try {
                editUrl = this.wopiService.getEditorLink(fileId, config.getWorkspace(), config.getBaseUrl(), "edit");
                viewUrl = this.wopiService.getEditorLink(fileId, config.getWorkspace(), config.getBaseUrl(), "view");
            }
            catch (EditorLinkNotFoundException e) {
                LOG.error((Object)"Cannot get editor link: ", (Throwable)e);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"PutRelativeFile [Suggested] response: OK");
            }
            return Response.ok().entity((Object)("{\"Name\": \"" + fileName + "\", \"Url\": \"" + url + "\", \"HostEditUrl\": \"" + editUrl + "\", \"HostViewUrl\":\"" + viewUrl + "\"}")).type("application/json").build();
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"File not found for PutRelativeFile [Suggested]");
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"Name\": \"" + currentFileName + "\", \"Url\": \"" + currentUrl + "\", \"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
        }
        catch (FileExtensionNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"File extension not found for PutRelativeFile [Suggested]");
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"Name\": \"" + currentFileName + "\", \"Url\": \"" + currentUrl + "\", \"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
        }
        catch (PermissionDeniedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Permission denied for PutRelativeFile [Suggested]", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"Name\": \"" + currentFileName + "\", \"Url\": \"" + currentUrl + "\", \"error\": \"" + e.getMessage() + "\"}")).type("application/json").build();
        }
        catch (RepositoryException | OfficeOnlineException e) {
            LOG.error((Object)"Cannot create new file based on existing one in suggested mode.", e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"Name\": \"" + currentFileName + "\", \"Url\": \"" + currentUrl + "\", \"error\": \"Failed to put relative file in suggested mode\"}")).type("application/json").build();
        }
    }

    protected void verifyProofKey(HttpServletRequest request) throws ProofKeyValidationException {
        String proofKeyHeader = request.getHeader(PROOF);
        String oldProofKeyHeader = request.getHeader(PROOF_OLD);
        String timestampHeader = request.getHeader(TIMESTAMP);
        String accessToken = request.getParameter(ACCESS_TOKEN);
        String currentUrl = request.getRequestURL().append('?').append(request.getQueryString()).toString();
        String contextPath = currentUrl.substring(currentUrl.indexOf(WOPI_ENDPOINT) + 4);
        if (!this.wopiService.verifyProofKey(proofKeyHeader, oldProofKeyHeader, contextPath, accessToken, timestampHeader)) {
            throw new ProofKeyValidationException("Proof key verification failed");
        }
    }

    protected EditorConfig getEditorConfig(ServletContext context) throws AuthenticationFailedException, EditorConfigNotFoundException {
        EditorConfig config = (EditorConfig)context.getAttribute(EDITOR_CONFIG_ATTRIBUTE);
        if (config != null) {
            return config;
        }
        Boolean authFailed = (Boolean)context.getAttribute(WRONG_TOKEN_ATTRIBUTE);
        if (authFailed != null && authFailed.booleanValue()) {
            throw new AuthenticationFailedException("Access token authentication failed");
        }
        throw new EditorConfigNotFoundException("Cannot get editor config from context");
    }

    @GET
    @Path(value="/api/version")
    @Produces(value={"application/json"})
    public Response versionGet(@Context UriInfo uriInfo, @Context HttpServletRequest request) {
        String title = this.getClass().getPackage().getImplementationTitle();
        String version = this.getClass().getPackage().getImplementationVersion();
        String clientHost = this.getClientHost(request);
        String clientIp = this.getClientIpAddr(request);
        return Response.ok().entity((Object)("{\"user\": \"" + request.getRemoteUser() + "\",\n\"requestIP\": \"" + clientIp + "\",\n\"requestHost\": \"" + clientHost + "\",\n\"product\":{ \"name\": \"" + title + "\",\n\"version\": \"" + version + "\"},\n\"version\": \"" + API_VERSION + "\"}")).type("application/json").build();
    }

    protected String getClientIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (this.isValidHost(ip)) {
            int commaIdx = ip.indexOf(44);
            if (commaIdx > 0 && commaIdx < ip.length() - 1) {
                ip = ip.substring(0, commaIdx);
            }
            return ip;
        }
        ip = request.getHeader("X-Real-IP");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getHeader("Proxy-Client-IP");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getHeader("WL-Proxy-Client-IP");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_CLIENT_IP");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_X_FORWARDED");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_X_CLUSTER_CLIENT_IP");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_FORWARDED_FOR");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_FORWARDED");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getHeader("REMOTE_ADDR");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getRemoteAddr();
        if (this.isValidHost(ip)) {
            return ip;
        }
        return null;
    }

    protected String getClientHost(HttpServletRequest request) {
        String host = request.getHeader("X-Forwarded-Host");
        if (this.isValidHost(host)) {
            return host;
        }
        String clientIp = request.getHeader("X-Forwarded-For");
        if (this.notEmpty(clientIp)) {
            int commaIdx = clientIp.indexOf(44);
            if (commaIdx > 0 && commaIdx < clientIp.length() - 1) {
                clientIp = clientIp.substring(0, commaIdx);
            }
        } else {
            clientIp = request.getHeader("X-Real-IP");
        }
        if (this.notEmpty(clientIp)) {
            try {
                host = InetAddress.getByName(clientIp).getHostName();
                if (this.notEmpty(host)) {
                    return host;
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("Cannot obtain client hostname by its IP " + clientIp + ": " + e.getMessage()));
            }
        }
        if (this.isValidHost(host = request.getRemoteHost())) {
            return host;
        }
        return clientIp;
    }

    protected void addItemVersionHeader(Response.ResponseBuilder response, EditorConfig config) {
        String version = null;
        try {
            version = this.wopiService.getFileVersion(config.getFileId(), config.getWorkspace());
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"File not found for getting version");
            }
        }
        catch (RepositoryException e) {
            LOG.debug((Object)"Error occured while getting file version", (Throwable)e);
        }
        if (version != null) {
            response.header(ITEM_VERSION, (Object)version);
        }
    }

    protected boolean notEmpty(String str) {
        return str != null && str.length() > 0;
    }

    protected boolean isValidHost(String host) {
        return this.notEmpty(host) && !"unknown".equalsIgnoreCase(host);
    }

    protected String convertStreamToString(InputStream inputStream) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)inputStream, (Writer)writer, (Charset)UTF_8);
        return writer.toString();
    }

    public static enum Operation {
        GET_LOCK,
        GET_SHARE_URL,
        LOCK,
        PUT,
        PUT_RELATIVE,
        REFRESH_LOCK,
        RENAME_FILE,
        UNLOCK,
        DELETE,
        PUT_USER_INFO;

    }
}

