/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.officeonline.webui;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.officeonline.cometd.CometdConfig;
import org.exoplatform.officeonline.cometd.CometdOfficeOnlineService;
import org.exoplatform.officeonline.exception.OfficeOnlineException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.RequireJS;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;

public class OfficeOnlineContext {
    public static final String USERID_ATTRIBUTE = "OfficeOnlineContext.userId";
    public static final String DOCUMENT_WORKSPACE_ATTRIBUTE = "OfficeOnlineContext.document.workspace";
    public static final String DOCUMENT_PATH_ATTRIBUTE = "OfficeOnlineContext.document.path";
    protected static final String JAVASCRIPT = "OfficeOnlineContext_Javascript".intern();
    protected static final String CLIENT_RESOURCE_PREFIX = "OfficeOnlineEditorClient.";
    protected static final Log LOG = ExoLogger.getLogger(OfficeOnlineContext.class);
    private final RequireJS require;

    private OfficeOnlineContext(WebuiRequestContext requestContext) throws OfficeOnlineException {
        String messagesJson;
        JavascriptManager js = requestContext.getJavascriptManager();
        this.require = js.require("SHARED/officeonline", "officeonline");
        try {
            ResourceBundleService i18nService = (ResourceBundleService)requestContext.getApplication().getApplicationServiceContainer().getComponentInstanceOfType(ResourceBundleService.class);
            ResourceBundle res = i18nService.getResourceBundle("locale.officeonline.OfficeOnlineClient", requestContext.getLocale());
            HashMap<String, String> resMap = new HashMap<String, String>();
            Enumeration<String> keys = res.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String bundleKey = key.startsWith(CLIENT_RESOURCE_PREFIX) ? key.substring(CLIENT_RESOURCE_PREFIX.length()) : key;
                resMap.put(bundleKey, res.getString(key));
            }
            messagesJson = new JsonGeneratorImpl().createJsonObjectFromMap(resMap).toString();
        }
        catch (JsonException e) {
            LOG.warn((Object)"Cannot serialize messages bundle JSON", (Throwable)e);
            messagesJson = "{}";
        }
        catch (Exception e) {
            LOG.warn((Object)"Cannot build messages bundle", (Throwable)e);
            messagesJson = "{}";
        }
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null && convo.getIdentity() != null) {
            ExoContainer container = requestContext.getApplication().getApplicationServiceContainer();
            CometdOfficeOnlineService cometdService = (CometdOfficeOnlineService)container.getComponentInstanceOfType(CometdOfficeOnlineService.class);
            String userId = convo.getIdentity().getUserId();
            CometdConfig cometdConf = new CometdConfig(cometdService.getCometdServerPath(), cometdService.getUserToken(userId), PortalContainer.getCurrentPortalContainerName());
            try {
                this.require.addScripts("officeonline.init('" + userId + "', " + cometdConf.toJSON() + ", " + messagesJson + ");");
            }
            catch (JsonException e) {
                LOG.warn("Cannot create JSON from cometd config: {}", new Object[]{e.getMessage()});
                throw new OfficeOnlineException("Failed to convert cometd config to JSON", e);
            }
        } else {
            throw new OfficeOnlineException("Authenticated user required");
        }
    }

    private RequireJS appRequireJS() {
        return this.require;
    }

    private void showClientError(String title, String message) {
        this.require.addScripts("officeonline.showError('" + title + ("', '" + message + "');"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OfficeOnlineContext context() throws OfficeOnlineException {
        OfficeOnlineContext context;
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Object obj = requestContext.getAttribute(JAVASCRIPT);
        if (obj == null || !OfficeOnlineContext.class.isAssignableFrom(obj.getClass())) {
            WebuiRequestContext webuiRequestContext = requestContext;
            synchronized (webuiRequestContext) {
                obj = requestContext.getAttribute(JAVASCRIPT);
                if (obj == null || !OfficeOnlineContext.class.isAssignableFrom(obj.getClass())) {
                    context = new OfficeOnlineContext(requestContext);
                    requestContext.setAttribute(JAVASCRIPT, (Object)context);
                } else {
                    context = (OfficeOnlineContext)OfficeOnlineContext.class.cast(obj);
                }
            }
        } else {
            context = (OfficeOnlineContext)OfficeOnlineContext.class.cast(obj);
        }
        return context;
    }

    public static void init() throws Exception {
        OfficeOnlineContext.context();
    }

    public static void callModule(String code) throws OfficeOnlineException {
        OfficeOnlineContext.context().appRequireJS().addScripts(code);
    }

    public static RequireJS requireJS() throws OfficeOnlineException {
        return OfficeOnlineContext.context().appRequireJS();
    }

    public static void showError(String title, String message) {
        try {
            OfficeOnlineContext.context().showClientError(title, message);
        }
        catch (Exception e) {
            LOG.error((Object)"Error initializing context", (Throwable)e);
        }
    }
}

