/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.officeonline;

import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import javax.crypto.Cipher;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecm.utils.permission.PermissionUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.officeonline.AccessToken;
import org.exoplatform.officeonline.DocumentContent;
import org.exoplatform.officeonline.EditorConfig;
import org.exoplatform.officeonline.Permissions;
import org.exoplatform.officeonline.RequestInfo;
import org.exoplatform.officeonline.exception.FileNotFoundException;
import org.exoplatform.officeonline.exception.OfficeOnlineException;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.picocontainer.Startable;

public abstract class AbstractOfficeOnlineService
implements Startable {
    protected static final Log LOG = ExoLogger.getLogger(AbstractOfficeOnlineService.class);
    protected static final String UTF_8 = "utf-8";
    public static final String KEY_CACHE_NAME = "officeonline.key.Cache".intern();
    protected static final String SECRET_KEY = "secret-key";
    protected static final String ALGORITHM = "AES";
    protected static final String TOKEN_DELIMITER = "+";
    protected static final String TOKEN_DELIMITER_PATTERN = "\\+";
    protected static final long TOKEN_EXPIRES = 1800000L;
    protected static final String JCR_CONTENT = "jcr:content";
    protected static final String WOPITESTX = "wopitestx";
    protected static final String WOPITEST = "wopitest";
    protected static final String JCR_DATA = "jcr:data";
    protected static final String EXO_LAST_MODIFIER = "exo:lastModifier";
    protected static final String EXO_LAST_MODIFIED_DATE = "exo:lastModifiedDate";
    protected static final String EXO_DATE_MODIFIED = "exo:dateModified";
    protected static final String JCR_LAST_MODIFIED = "jcr:lastModified";
    protected static final String MIX_VERSIONABLE = "mix:versionable";
    protected static final String EXO_OWNER = "exo:owner";
    protected static final String EXO_TITLE = "exo:title";
    protected static final String EXO_PRIVILEGEABLE = "exo:privilegeable";
    protected static final String JCR_MIME_TYPE = "jcr:mimeType";
    protected static final String EXO_NAME = "exo:name";
    protected static final String PATH = "path";
    protected static final String MSOFFICE_USER_PREFERENCES = "msoffice:userPreferences";
    protected static final String MSOFFICE_FILE = "msoffice:file";
    protected static final String MSOFFICE_PREFERENCES = "msoffice:preferences";
    protected final ExoCache<String, Key> keyCache;
    protected final SessionProviderService sessionProviders;
    protected final UserACL userACL;
    protected final RepositoryService jcrService;
    protected final OrganizationService organization;
    protected final DocumentService documentService;
    protected final IdentityRegistry identityRegistry;
    protected final Authenticator authenticator;
    protected NodeFinder nodeFinder;

    public AbstractOfficeOnlineService(SessionProviderService sessionProviders, RepositoryService jcrService, OrganizationService organization, DocumentService documentService, CacheService cacheService, UserACL userACL, IdentityRegistry identityRegistry, Authenticator authenticator, NodeFinder nodeFinder) {
        this.sessionProviders = sessionProviders;
        this.jcrService = jcrService;
        this.organization = organization;
        this.documentService = documentService;
        this.keyCache = cacheService.getCacheInstance(KEY_CACHE_NAME);
        this.userACL = userACL;
        this.identityRegistry = identityRegistry;
        this.authenticator = authenticator;
        this.nodeFinder = nodeFinder;
    }

    public Node nodeByUUID(String uuid, String workspace) throws FileNotFoundException, RepositoryException {
        try {
            Session userSession = this.getUserSession(workspace);
            return userSession.getNodeByUUID(uuid);
        }
        catch (ItemNotFoundException e) {
            LOG.warn("Cannot find node by UUID: {}, workspace: {}. Error: {}", new Object[]{uuid, workspace, e.getMessage()});
            throw new FileNotFoundException("File not found. FileId: " + uuid + ", workspace: " + workspace);
        }
    }

    protected Session getUserSession(String workspace) throws RepositoryException {
        if (workspace == null) {
            workspace = this.jcrService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
        }
        SessionProvider sp = this.sessionProviders.getSessionProvider(null);
        return sp.getSession(workspace, this.jcrService.getCurrentRepository());
    }

    protected Node nodeContent(Node node) throws RepositoryException {
        return node.getNode(JCR_CONTENT);
    }

    public DocumentContent getContent(EditorConfig config) throws OfficeOnlineException {
        try {
            Node node = this.nodeByUUID(config.getFileId(), config.getWorkspace());
            Node content = this.nodeContent(node);
            final String mimeType = content.getProperty(JCR_MIME_TYPE).getString();
            AutoCloseInputStream data = new AutoCloseInputStream(content.getProperty(JCR_DATA).getStream());
            final String filename = this.nodeTitle(node);
            return new DocumentContent((InputStream)data, node){
                final /* synthetic */ InputStream val$data;
                final /* synthetic */ Node val$node;
                {
                    this.val$data = inputStream;
                    this.val$node = node;
                }

                @Override
                public String getFilename() {
                    return filename;
                }

                @Override
                public String getType() {
                    return mimeType;
                }

                @Override
                public InputStream getData() {
                    return this.val$data;
                }

                @Override
                public String getVersion() throws RepositoryException {
                    return this.val$node.isNodeType(AbstractOfficeOnlineService.MIX_VERSIONABLE) ? this.val$node.getBaseVersion().getName() : null;
                }
            };
        }
        catch (RepositoryException e) {
            LOG.error("Cannot get content of node. FileId: " + config.getFileId(), new Object[]{e.getMessage()});
            throw new OfficeOnlineException("Cannot get file content. FileId: " + config.getFileId());
        }
    }

    protected StringBuilder platformUrl(String schema, String host, int port) {
        StringBuilder platformUrl = new StringBuilder();
        platformUrl.append(schema);
        platformUrl.append("://");
        platformUrl.append(host);
        if (port >= 0 && port != 80 && port != 443) {
            platformUrl.append(':');
            platformUrl.append(port);
        }
        platformUrl.append('/');
        platformUrl.append(PortalContainer.getCurrentPortalContainerName());
        return platformUrl;
    }

    protected StringBuilder platformRestUrl(CharSequence platformUrl) {
        StringBuilder restUrl = new StringBuilder(platformUrl);
        restUrl.append('/');
        restUrl.append(PortalContainer.getCurrentRestContextName());
        return restUrl;
    }

    protected User getUser(String username) {
        try {
            return this.organization.getUserHandler().findUserByName(username);
        }
        catch (Exception e) {
            LOG.error((Object)("Error searching user " + username), (Throwable)e);
            return null;
        }
    }

    protected URI explorerUri(String baseUrl, String ecmsLink) {
        URI uri;
        try {
            URI baseURI = new URI(baseUrl);
            ecmsLink = URLDecoder.decode(ecmsLink, StandardCharsets.UTF_8.name());
            String[] linkParts = ecmsLink.split("\\?");
            uri = linkParts.length >= 2 ? new URI(baseURI.getScheme(), null, baseURI.getHost(), baseURI.getPort(), linkParts[0], linkParts[1], null) : new URI(baseURI.getScheme(), null, baseURI.getHost(), baseURI.getPort(), ecmsLink, null, null);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error creating document URI", (Throwable)e);
            try {
                uri = URI.create(ecmsLink);
            }
            catch (Exception e1) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Error creating document URI from ECMS link and after error: " + e.getMessage()), (Throwable)e1);
                }
                uri = null;
            }
        }
        return uri;
    }

    protected String explorerLink(String jcrPath) {
        try {
            return this.documentService.getLinkInDocumentsApp(jcrPath);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error creating document link for " + jcrPath), (Throwable)e);
            return '/' + PortalContainer.getCurrentPortalContainerName();
        }
    }

    protected Long getSize(Node node) {
        long size = 0L;
        try {
            Node contentNode;
            if (node.isNodeType("exo:symlink")) {
                node = Utils.getNodeSymLink((Node)node);
            }
            if (node.hasNode(JCR_CONTENT) && (contentNode = node.getNode(JCR_CONTENT)).hasProperty(JCR_DATA)) {
                size = contentNode.getProperty(JCR_DATA).getLength();
            }
        }
        catch (Exception e) {
            String path = null;
            try {
                path = node.getPath();
            }
            catch (RepositoryException ex) {
                LOG.error((Object)"Couldn't get path of the node");
            }
            LOG.error("Couldn't get size of the document: {}", new Object[]{path});
        }
        return size;
    }

    public EditorConfig createEditorConfig(String userId, String fileId, String workspace, RequestInfo requestInfo) throws OfficeOnlineException, RepositoryException {
        Node node = this.nodeByUUID(fileId, workspace);
        ArrayList<Permissions> permissions = new ArrayList<Permissions>();
        if (PermissionUtil.canSetProperty((Node)node)) {
            permissions.add(Permissions.USER_CAN_WRITE);
            permissions.add(Permissions.USER_CAN_RENAME);
        } else {
            permissions.add(Permissions.READ_ONLY);
        }
        String baseUrl = this.platformUrl(requestInfo.getScheme(), requestInfo.getServerName(), requestInfo.getPort()).toString();
        EditorConfig.Builder configBuilder = new EditorConfig.Builder().userId(userId).fileId(fileId).workspace(workspace).permissions(permissions).baseUrl(baseUrl);
        AccessToken accessToken = this.generateAccessToken(configBuilder);
        configBuilder.accessToken(accessToken);
        return configBuilder.build();
    }

    public AccessToken generateAccessToken(EditorConfig.Builder configBuilder) throws OfficeOnlineException {
        try {
            Key key = (Key)this.keyCache.get((Serializable)((Object)SECRET_KEY));
            Cipher chiper = Cipher.getInstance(ALGORITHM);
            chiper.init(1, key);
            long expires = System.currentTimeMillis() + 1800000L;
            StringBuilder builder = new StringBuilder().append(configBuilder.workspace()).append(TOKEN_DELIMITER).append(configBuilder.userId()).append(TOKEN_DELIMITER).append(configBuilder.fileId()).append(TOKEN_DELIMITER).append(expires).append(TOKEN_DELIMITER).append(configBuilder.baseUrl());
            configBuilder.permissions().forEach(permission -> builder.append(TOKEN_DELIMITER).append(permission.getShortName()));
            byte[] encrypted = chiper.doFinal(builder.toString().getBytes());
            String token = new String(Base64.getUrlEncoder().encode(encrypted));
            return new AccessToken(token, expires);
        }
        catch (Exception e) {
            LOG.error("Error occured while generating token. {}", new Object[]{e.getMessage()});
            throw new OfficeOnlineException("Couldn't generate token from editor config.");
        }
    }

    public Node getNode(String workspace, String path) throws RepositoryException {
        SessionProvider sp;
        Session userSession;
        Item item;
        if (workspace == null) {
            workspace = this.jcrService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
        }
        if ((item = this.nodeFinder.getItem(userSession = (sp = this.sessionProviders.getSessionProvider(null)).getSession(workspace, this.jcrService.getCurrentRepository()), path, true)) != null && item.isNode()) {
            return (Node)item;
        }
        return null;
    }

    public EditorConfig buildEditorConfig(String token) throws OfficeOnlineException {
        String decryptedToken = "";
        try {
            Key key = (Key)this.keyCache.get((Serializable)((Object)SECRET_KEY));
            Cipher chiper = Cipher.getInstance(ALGORITHM);
            chiper.init(2, key);
            byte[] decoded = Base64.getUrlDecoder().decode(token.getBytes());
            decryptedToken = new String(chiper.doFinal(decoded));
        }
        catch (Exception e) {
            LOG.error("Error occured while decoding/decrypting accessToken. {}", new Object[]{e.getMessage()});
            throw new OfficeOnlineException("Cannot decode/decrypt accessToken");
        }
        ArrayList<Permissions> permissions = new ArrayList<Permissions>();
        List<String> values = Arrays.asList(decryptedToken.split(TOKEN_DELIMITER_PATTERN));
        if (values.size() > 4) {
            String workspace = values.get(0);
            if (workspace.equals("null")) {
                workspace = null;
            }
            String userId = values.get(1);
            String fileId = values.get(2);
            long expires = Long.parseLong(values.get(3));
            String baseUrl = values.get(4);
            values.stream().skip(5L).forEach(value -> permissions.add(Permissions.fromShortName(value)));
            return new EditorConfig.Builder().userId(userId).fileId(fileId).workspace(workspace).baseUrl(baseUrl).permissions(permissions).accessToken(new AccessToken(token, expires)).build();
        }
        throw new OfficeOnlineException("Decrypted token doesn't contain all required parameters");
    }

    protected boolean setUserConvoState(String userId) {
        Identity userIdentity = this.userIdentity(userId);
        if (userIdentity != null) {
            ConversationState state = new ConversationState(userIdentity);
            state.setAttribute("subject", (Object)userIdentity.getSubject());
            ConversationState.setCurrent((ConversationState)state);
            SessionProvider userProvider = new SessionProvider(state);
            this.sessionProviders.setSessionProvider(null, userProvider);
            return true;
        }
        LOG.warn((Object)("User identity not found " + userId + " for setting conversation state"));
        return false;
    }

    protected void restoreConvoState(ConversationState contextState, SessionProvider contextProvider) {
        ConversationState.setCurrent((ConversationState)contextState);
        this.sessionProviders.setSessionProvider(null, contextProvider);
    }

    protected Identity userIdentity(String userId) {
        Identity userIdentity = this.identityRegistry.getIdentity(userId);
        if (userIdentity == null) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("User identity not registered, trying to create it for: " + userId));
                }
                userIdentity = this.authenticator.createIdentity(userId);
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed to create user identity: " + userId), (Throwable)e);
            }
        }
        return userIdentity;
    }

    public void addFilePreferences(Node node, String userId, String path) throws RepositoryException {
        NodeImpl preferences;
        if (node.canAddMixin(MSOFFICE_FILE)) {
            this.addMixin(node, MSOFFICE_FILE);
        }
        Node userPreferences = !(preferences = (NodeImpl)node.getNode(MSOFFICE_PREFERENCES)).hasNode(userId) ? preferences.addNode(userId, MSOFFICE_USER_PREFERENCES) : preferences.getNode(userId);
        userPreferences.setProperty(PATH, path);
        if (!preferences.hasPermission("add_node")) {
            this.addWritePermissions((Node)preferences, userId);
        }
        node.save();
    }

    public String nodeTitle(Node node) throws RepositoryException {
        String title = null;
        if (node.hasProperty(EXO_TITLE)) {
            title = node.getProperty(EXO_TITLE).getString();
        } else if (node.hasProperty("jcr:content/dc:title")) {
            Property dcTitle = node.getProperty("jcr:content/dc:title");
            if (dcTitle.getDefinition().isMultiple()) {
                Value[] dctValues = dcTitle.getValues();
                if (dctValues.length > 0) {
                    title = dctValues[0].getString();
                }
            } else {
                title = dcTitle.getString();
            }
        } else if (node.hasProperty(EXO_NAME)) {
            title = node.getProperty(EXO_NAME).getString();
        }
        if (title == null) {
            title = node.getName();
        }
        try {
            title = URLDecoder.decode(title, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("Cannot decode node name using URLDecoder. {}", new Object[]{e.getMessage()});
        }
        return title;
    }

    private void addMixin(Node node, String mixin) throws RepositoryException {
        Session systemSession = this.jcrService.getCurrentRepository().getSystemSession(node.getSession().getWorkspace().getName());
        NodeImpl systemNode = (NodeImpl)systemSession.getItem(node.getPath());
        systemNode.addMixin(mixin);
        systemNode.save();
    }

    private void addWritePermissions(Node node, String userId) throws RepositoryException {
        Session systemSession = this.jcrService.getCurrentRepository().getSystemSession(node.getSession().getWorkspace().getName());
        NodeImpl systemNode = (NodeImpl)systemSession.getItem(node.getPath());
        systemNode.addMixin(EXO_PRIVILEGEABLE);
        systemNode.setPermission(userId, new String[]{"read", "add_node", "set_property"});
        systemNode.save();
    }

    protected Node getSymlink(Node node, String userId) throws RepositoryException {
        Node filePreferences;
        if (node.hasNode(MSOFFICE_PREFERENCES) && (filePreferences = node.getNode(MSOFFICE_PREFERENCES)).hasNode(userId)) {
            Node userPreferences = filePreferences.getNode(userId);
            String path = userPreferences.getProperty(PATH).getString();
            return (Node)node.getSession().getItem(path);
        }
        return null;
    }
}

