/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.officeonline;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.officeonline.WOPIService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class DocumentTypePlugin
extends BaseComponentPlugin {
    protected static final Log LOG = ExoLogger.getLogger(DocumentTypePlugin.class);
    private static final String DOCUMENT_TYPES_CONFIGURATION = "document-types-configuration";
    protected Map<String, String> fileExtensions = Collections.emptyMap();

    public DocumentTypePlugin(InitParams initParams) {
        ObjectParameter typesParam = initParams.getObjectParam(DOCUMENT_TYPES_CONFIGURATION);
        if (typesParam != null) {
            Object obj = typesParam.getObject();
            if (obj != null && WOPIService.DocumentTypesConfig.class.isAssignableFrom(obj.getClass())) {
                this.fileExtensions = ((WOPIService.DocumentTypesConfig)WOPIService.DocumentTypesConfig.class.cast(obj)).getFileExtensions();
            } else {
                this.fileExtensions = new HashMap<String, String>();
                LOG.error((Object)"The file extensions are not set");
            }
        }
    }

    public Map<String, String> getFileExtensions() {
        return this.fileExtensions;
    }
}

